
#include "stdafx.h"
#include "write.h"
#include "common.h"
#include "NtStatus/PTNtstatus.h"


FSWrite::FSWrite(void)
{
}

FSWrite::~FSWrite(void)
{
}

BOOL FSWrite::SendWriteRequest(HANDLE hHandle, PEVENT_INFORMATION EventInfo, ULONG EventLength, PVOID Buffer, ULONG BufferLength, ULONG* ReturnedLengthOutPointer, DWORD* LastError)
{
	BOOL status;
	ULONG returnedLength;

	status = DeviceIoControl(hHandle,
		IOCTL_EVENT_WRITE,
		EventInfo,
		EventLength,
		Buffer,
		BufferLength,
		&returnedLength,
		NULL
	);

	if (!status) 
	{
		DWORD errorCode = GetLastError();
		*LastError = errorCode;
	}
	else 
		*LastError = 0;

	*ReturnedLengthOutPointer = returnedLength;

	return status;
}

VOID FSWrite::DispatchWrite(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance) 
{
	PEVENT_INFORMATION pEventInfo = NULL;
	PPTFS_OPEN_INFO pOpenInfo = NULL;
	ULONG writtenLength = 0;
	NTSTATUS status;
	PTFS_FILE_INFO fileInfo;
	BOOL bufferAllocated = FALSE;
	ULONG returnedLength = 0;
	BOOL SendWriteRequestStatus = TRUE;
	DWORD SendWriteRequestLastError = 0;
	ULONG sizeOfEventInfo = FSCommon::DispatchGetEventInformationLength(0);

	pEventInfo = FSCommon::DispatchCommon(pEventContext, sizeOfEventInfo, pPTFSInstance, &fileInfo, &pOpenInfo);

	if (pEventContext->Operation.Write.RequestLength > 0) 
	{
		ULONG contextLength = pEventContext->Operation.Write.RequestLength;
		PEVENT_CONTEXT pContextBuf = (PEVENT_CONTEXT)malloc(contextLength);
		if (pContextBuf == NULL) 
		{
			free(pEventInfo);
			return;
		}
		SendWriteRequestStatus = SendWriteRequest(hHandle, pEventInfo, sizeOfEventInfo, pContextBuf,contextLength, &returnedLength, &SendWriteRequestLastError);
		pEventContext = pContextBuf;
		bufferAllocated = TRUE;
	}

	FSCommon::CheckFileName(pEventContext->Operation.Write.FileName);

	if (!SendWriteRequestStatus) 
	{
		if (SendWriteRequestLastError == ERROR_OPERATION_ABORTED) 
		{
			status = STATUS_CANCELLED;
		}
		else 
		{
			status = PTNtStatus::PTNtStatusFromWin32(SendWriteRequestLastError);
		}
	}
	else 
	{
		if (pPTFSInstance->pPTFSOperations->WriteFile) 
		{
			status = pPTFSInstance->pPTFSOperations->WriteFile( pEventContext->Operation.Write.FileName,
				(PCHAR)pEventContext + pEventContext->Operation.Write.BufferOffset,
				pEventContext->Operation.Write.BufferLength, &writtenLength,
				pEventContext->Operation.Write.ByteOffset.QuadPart, &fileInfo);
		}
		else 
		{
			status = STATUS_NOT_IMPLEMENTED;
		}
	}

	if (pOpenInfo != NULL)
		pOpenInfo->UserContext = fileInfo.Context;

	pEventInfo->Status = status;
	pEventInfo->BufferLength = 0;

	if (status == STATUS_SUCCESS)
	{
		pEventInfo->BufferLength = writtenLength;
		pEventInfo->Operation.Write.CurrentByteOffset.QuadPart =
			pEventContext->Operation.Write.ByteOffset.QuadPart + writtenLength;
	}

	FSCommon::SendEventInformation(hHandle, pEventInfo, sizeOfEventInfo, pPTFSInstance);
	free(pEventInfo);

	if (bufferAllocated)
		free(pEventContext);
}
