
#include "stdafx.h"
#include "volume.h"
#include "PTFSfileinfo.h"
#include "common.h"

FSVolume::FSVolume(void)
{
}

FSVolume::~FSVolume(void)
{
}

NTSTATUS PTFS_CALLBACK PTFSGetDiskFreeSpace(PULONGLONG FreeBytesAvailable, PULONGLONG TotalNumberOfBytes, PULONGLONG TotalNumberOfFreeBytes, PPTFS_FILE_INFO PTFSFileInfo)
{
	UNREFERENCED_PARAMETER(PTFSFileInfo);

	*FreeBytesAvailable = PTFS_DEFAULT_DISK_SIZE / 2;
	*TotalNumberOfBytes = PTFS_DEFAULT_DISK_SIZE;
	*TotalNumberOfFreeBytes = PTFS_DEFAULT_DISK_SIZE/2;

	return STATUS_SUCCESS;
}

NTSTATUS PTFS_CALLBACK PTFSGetVolumeInformation(LPWSTR VolumeNameBuffer, DWORD VolumeNameSize, LPDWORD VolumeSerialNumber,
	LPDWORD MaximumComponentLength, LPDWORD FileSystemFlags, LPWSTR FileSystemNameBuffer, DWORD FileSystemNameSize, PPTFS_FILE_INFO PTFSFileInfo)
{
	UNREFERENCED_PARAMETER(PTFSFileInfo);

	wcscpy_s(VolumeNameBuffer, VolumeNameSize, L"PTClive");
	*VolumeSerialNumber = PTFS_VOLUME_SERIAL_NUMBER;
	*MaximumComponentLength = 256;
	*FileSystemFlags = FILE_CASE_SENSITIVE_SEARCH | FILE_CASE_PRESERVED_NAMES | FILE_SUPPORTS_REMOTE_STORAGE | FILE_UNICODE_ON_DISK;

	wcscpy_s(FileSystemNameBuffer, FileSystemNameSize, L"PTFS");
	return STATUS_SUCCESS;
}

NTSTATUS FSVolume::PTFSFsVolumeInformation(PEVENT_INFORMATION pEventInfo, PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations)
{
	WCHAR volumeName[MAX_PATH];
	DWORD volumeSerial = 0;
	DWORD maxComLength = 0;
	DWORD fsFlags = 0;
	WCHAR fsName[MAX_PATH];
	ULONG remainingLength;
	ULONG bytesToCopy;
	NTSTATUS status = STATUS_NOT_IMPLEMENTED;
	PFILE_FS_VOLUME_INFORMATION volumeInfo = (PFILE_FS_VOLUME_INFORMATION)pEventInfo->Buffer;

	remainingLength = pEventContext->Operation.Volume.BufferLength;

	if (remainingLength < sizeof(FILE_FS_VOLUME_INFORMATION))
		return STATUS_BUFFER_OVERFLOW;

	RtlZeroMemory(volumeName, sizeof(volumeName));
	RtlZeroMemory(fsName, sizeof(fsName));

	if (pPTFSOperations->GetVolumeInformation)
	{
		status = pPTFSOperations->GetVolumeInformation(
			volumeName,
			sizeof(volumeName) / sizeof(WCHAR),
			&volumeSerial,
			&maxComLength,
			&fsFlags,
			fsName,
			sizeof(fsName) / sizeof(WCHAR),
			pFileInfo);
	}

	if (status == STATUS_NOT_IMPLEMENTED) 
	{
		status = PTFSGetVolumeInformation(
			volumeName,
			sizeof(volumeName) / sizeof(WCHAR),
			&volumeSerial,
			&maxComLength,
			&fsFlags,
			fsName,
			sizeof(fsName) / sizeof(WCHAR),
			pFileInfo);
	}

	if (status != STATUS_SUCCESS)
		return status;

	volumeInfo->VolumeCreationTime.QuadPart = 0;
	volumeInfo->VolumeSerialNumber = volumeSerial;
	volumeInfo->SupportsObjects = FALSE;

	remainingLength -= FIELD_OFFSET(FILE_FS_VOLUME_INFORMATION, VolumeLabel[0]);

	bytesToCopy = (ULONG)wcslen(volumeName) * sizeof(WCHAR);
	if (remainingLength < bytesToCopy)
		bytesToCopy = remainingLength;

	volumeInfo->VolumeLabelLength = bytesToCopy;
	RtlCopyMemory(volumeInfo->VolumeLabel, volumeName, bytesToCopy);
	remainingLength -= bytesToCopy;

	pEventInfo->BufferLength =pEventContext->Operation.Volume.BufferLength - remainingLength;
	return STATUS_SUCCESS;
}

NTSTATUS FSVolume::PTFSFsSizeInformation(PEVENT_INFORMATION pEventInfo, PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations) 
{
	ULONGLONG freeBytesAvailable = 0;
	ULONGLONG totalBytes = 0;
	ULONGLONG freeBytes = 0;
	NTSTATUS status = STATUS_NOT_IMPLEMENTED;
	ULONG allocationUnitSize = pFileInfo->pPTFSOptions->AllocationUnitSize;
	ULONG sectorSize = pFileInfo->pPTFSOptions->SectorSize;
	PFILE_FS_SIZE_INFORMATION sizeInfo =(PFILE_FS_SIZE_INFORMATION)pEventInfo->Buffer;

	if (pEventContext->Operation.Volume.BufferLength < sizeof(FILE_FS_SIZE_INFORMATION))
		return STATUS_BUFFER_OVERFLOW;

	if (pPTFSOperations->GetDiskFreeSpace)
	{
		status = pPTFSOperations->GetDiskFreeSpace(
			&freeBytesAvailable,
			&totalBytes,
			&freeBytes,
			pFileInfo);
	}

	if (status == STATUS_NOT_IMPLEMENTED) 
	{
		status = PTFSGetDiskFreeSpace(&freeBytesAvailable,
			&totalBytes,
			&freeBytes,
			pFileInfo);
	}

	if (status != STATUS_SUCCESS)
		return status;

	sizeInfo->TotalAllocationUnits.QuadPart = totalBytes / allocationUnitSize;
	sizeInfo->AvailableAllocationUnits.QuadPart = freeBytesAvailable / allocationUnitSize;
	sizeInfo->SectorsPerAllocationUnit = allocationUnitSize / sectorSize;
	sizeInfo->BytesPerSector = sectorSize;
	pEventInfo->BufferLength = sizeof(FILE_FS_SIZE_INFORMATION);
	return STATUS_SUCCESS;
}

NTSTATUS FSVolume::PTFSFsAttributeInformation(PEVENT_INFORMATION pEventInfo, PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations) 
{
	WCHAR volumeName[MAX_PATH];
	DWORD volumeSerial;
	DWORD maxComLength = 0;
	DWORD fsFlags = 0;
	WCHAR fsName[MAX_PATH];
	ULONG remainingLength;
	ULONG bytesToCopy;
	NTSTATUS status = STATUS_NOT_IMPLEMENTED;
	PFILE_FS_ATTRIBUTE_INFORMATION attrInfo = (PFILE_FS_ATTRIBUTE_INFORMATION)pEventInfo->Buffer;

	remainingLength = pEventContext->Operation.Volume.BufferLength;

	if (remainingLength < sizeof(FILE_FS_ATTRIBUTE_INFORMATION))
		return STATUS_BUFFER_OVERFLOW;

	RtlZeroMemory(volumeName, sizeof(volumeName));
	RtlZeroMemory(fsName, sizeof(fsName));

	if (pPTFSOperations->GetVolumeInformation)
	{
		status = pPTFSOperations->GetVolumeInformation(
			volumeName,
			sizeof(volumeName) / sizeof(WCHAR),
			&volumeSerial,
			&maxComLength,
			&fsFlags,
			fsName,
			sizeof(fsName) / sizeof(WCHAR),
			pFileInfo);
	}

	if (status == STATUS_NOT_IMPLEMENTED)
	{
		status = PTFSGetVolumeInformation(
			volumeName,
			sizeof(volumeName) / sizeof(WCHAR),
			&volumeSerial,
			&maxComLength,
			&fsFlags,
			fsName,
			sizeof(fsName) / sizeof(WCHAR),
			pFileInfo);
	}

	if (status != STATUS_SUCCESS) 
		return status;

	attrInfo->FileSystemAttributes = fsFlags;
	attrInfo->MaximumComponentNameLength = maxComLength;

	remainingLength -= FIELD_OFFSET(FILE_FS_ATTRIBUTE_INFORMATION, FileSystemName[0]);

	bytesToCopy = (ULONG)wcslen(fsName) * sizeof(WCHAR);
	if (remainingLength < bytesToCopy) 
	{
		bytesToCopy = remainingLength;
		status = STATUS_BUFFER_OVERFLOW;
	}

	attrInfo->FileSystemNameLength = bytesToCopy;
	RtlCopyMemory(attrInfo->FileSystemName, fsName, bytesToCopy);
	remainingLength -= bytesToCopy;
	pEventInfo->BufferLength = pEventContext->Operation.Volume.BufferLength - remainingLength;
	return status;
}

NTSTATUS FSVolume::PTFSFsFullSizeInformation(PEVENT_INFORMATION pEventInfo, PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations)
{
	ULONGLONG freeBytesAvailable = 0;
	ULONGLONG totalBytes = 0;
	ULONGLONG freeBytes = 0;
	NTSTATUS status = STATUS_NOT_IMPLEMENTED;
	ULONG allocationUnitSize = pFileInfo->pPTFSOptions->AllocationUnitSize;
	ULONG sectorSize = pFileInfo->pPTFSOptions->SectorSize;
	PFILE_FS_FULL_SIZE_INFORMATION sizeInfo = (PFILE_FS_FULL_SIZE_INFORMATION)pEventInfo->Buffer;

	if (pEventContext->Operation.Volume.BufferLength < sizeof(FILE_FS_FULL_SIZE_INFORMATION))
		return STATUS_BUFFER_OVERFLOW;

	if (pPTFSOperations->GetDiskFreeSpace) 
	{
		status = pPTFSOperations->GetDiskFreeSpace(
			&freeBytesAvailable,
			&totalBytes,
			&freeBytes,
			pFileInfo);
	}

	if (status == STATUS_NOT_IMPLEMENTED)
	{
		status = PTFSGetDiskFreeSpace(&freeBytesAvailable,
			&totalBytes,
			&freeBytes,
			pFileInfo);
	}

	if (status != STATUS_SUCCESS)
		return status;

	sizeInfo->TotalAllocationUnits.QuadPart = totalBytes / allocationUnitSize;
	sizeInfo->ActualAvailableAllocationUnits.QuadPart = freeBytes / allocationUnitSize;
	sizeInfo->CallerAvailableAllocationUnits.QuadPart = freeBytesAvailable / allocationUnitSize;
	sizeInfo->SectorsPerAllocationUnit = allocationUnitSize / sectorSize;
	sizeInfo->BytesPerSector = sectorSize;

	pEventInfo->BufferLength = sizeof(FILE_FS_FULL_SIZE_INFORMATION);
	return STATUS_SUCCESS;
}

VOID FSVolume::DispatchQueryVolumeInformation(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance)
{
	PEVENT_INFORMATION pEventInfo = NULL;
	PTFS_FILE_INFO fileInfo;
	PPTFS_OPEN_INFO pOpenInfo = NULL;
	ULONG sizeOfEventInfo = FSCommon::DispatchGetEventInformationLength(pEventContext->Operation.Volume.BufferLength);

	pEventInfo = (PEVENT_INFORMATION)malloc(sizeOfEventInfo);
	if (pEventInfo == NULL)
		return;

	RtlZeroMemory(pEventInfo, sizeOfEventInfo);
	RtlZeroMemory(&fileInfo, sizeof(PTFS_FILE_INFO));

	pOpenInfo = (PPTFS_OPEN_INFO)(INT_PTR)pEventContext->Context;

	pEventInfo->BufferLength = 0;
	pEventInfo->SerialNumber = pEventContext->SerialNumber;

	fileInfo.ProcessId = pEventContext->ProcessId;
	fileInfo.pPTFSOptions = pPTFSInstance->pPTFSOptions;

	pEventInfo->Status = STATUS_NOT_IMPLEMENTED;
	pEventInfo->BufferLength = 0;

	switch (pEventContext->Operation.Volume.FsInformationClass) 
	{
	case FileFsVolumeInformation:
		pEventInfo->Status = PTFSFsVolumeInformation(pEventInfo, pEventContext, &fileInfo, pPTFSInstance->pPTFSOperations);
		break;
	case FileFsSizeInformation:
		pEventInfo->Status = PTFSFsSizeInformation(pEventInfo, pEventContext, &fileInfo, pPTFSInstance->pPTFSOperations);
		break;
	case FileFsAttributeInformation:
		pEventInfo->Status = PTFSFsAttributeInformation(pEventInfo, pEventContext, &fileInfo, pPTFSInstance->pPTFSOperations);
		break;
	case FileFsFullSizeInformation:
		pEventInfo->Status = PTFSFsFullSizeInformation(pEventInfo, pEventContext, &fileInfo, pPTFSInstance->pPTFSOperations);
		break;
	default:
		break;
	}

	FSCommon::SendEventInformation(hHandle, pEventInfo, sizeOfEventInfo, NULL);
	free(pEventInfo);
}
