
#include "stdafx.h"
#include <stdio.h>
#include <stdlib.h>
#include "setfile.h"
#include "PTFSfileinfo.h"
#include "common.h"

#pragma warning(disable : 4244)

FSSetFile::FSSetFile(void)
{

}

FSSetFile::~FSSetFile(void)
{

}

NTSTATUS FSSetFile::PTFSSetAllocationInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations) 
{
	PFILE_ALLOCATION_INFORMATION allocInfo = (PFILE_ALLOCATION_INFORMATION)((PCHAR)pEventContext + pEventContext->Operation.SetFile.BufferOffset);
	NTSTATUS status;

	if (pPTFSOperations->SetAllocationSize) 
		status = pPTFSOperations->SetAllocationSize(pEventContext->Operation.SetFile.FileName, allocInfo->AllocationSize.QuadPart, pFileInfo);
	else 
		status = STATUS_NOT_IMPLEMENTED;

	return status;
}

NTSTATUS FSSetFile::PTFSSetBasicInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations) 
{
	FILETIME creation, lastAccess, lastWrite;
	NTSTATUS status;
	PFILE_BASIC_INFORMATION basicInfo = (PFILE_BASIC_INFORMATION)((PCHAR)pEventContext + pEventContext->Operation.SetFile.BufferOffset);

	if (!pPTFSOperations->SetFileAttributes)
		return STATUS_NOT_IMPLEMENTED;

	if (!pPTFSOperations->SetFileTime)
		return STATUS_NOT_IMPLEMENTED;

	status = pPTFSOperations->SetFileAttributes(pEventContext->Operation.SetFile.FileName, basicInfo->FileAttributes,pFileInfo);

	if (status != STATUS_SUCCESS)
		return status;

	creation.dwLowDateTime = basicInfo->CreationTime.LowPart;
	creation.dwHighDateTime = basicInfo->CreationTime.HighPart;
	lastAccess.dwLowDateTime = basicInfo->LastAccessTime.LowPart;
	lastAccess.dwHighDateTime = basicInfo->LastAccessTime.HighPart;
	lastWrite.dwLowDateTime = basicInfo->LastWriteTime.LowPart;
	lastWrite.dwHighDateTime = basicInfo->LastWriteTime.HighPart;

	return pPTFSOperations->SetFileTime(pEventContext->Operation.SetFile.FileName,&creation, &lastAccess, &lastWrite,pFileInfo);
}

NTSTATUS FSSetFile::PTFSSetDispositionInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations) 
{
	BOOLEAN DeleteFileFlag = FALSE;
	NTSTATUS result;

	if (pEventContext->Operation.SetFile.FileInformationClass == FileDispositionInformation) 
	{
		PFILE_DISPOSITION_INFORMATION dispositionInfo = (PFILE_DISPOSITION_INFORMATION)((PCHAR)pEventContext + pEventContext->Operation.SetFile.BufferOffset);
		DeleteFileFlag = dispositionInfo->DeleteFile;
	}
	else
	{ //FileDispositionInformationEx
		PFILE_DISPOSITION_INFORMATION_EX dispositionexInfo =(PFILE_DISPOSITION_INFORMATION_EX)((PCHAR)pEventContext + pEventContext->Operation.SetFile.BufferOffset);
		DeleteFileFlag = (dispositionexInfo->Flags & FILE_DISPOSITION_DELETE) != 0;
	}

	if (!pPTFSOperations->DeleteFile || !pPTFSOperations->DeleteDirectory)
		return STATUS_NOT_IMPLEMENTED;

	if (DeleteFileFlag == pFileInfo->DeleteOnClose)
		return STATUS_SUCCESS;

	if (pPTFSOperations->GetFileInformation && DeleteFileFlag) 
	{
		BY_HANDLE_FILE_INFORMATION byHandleFileInfo;
		ZeroMemory(&byHandleFileInfo, sizeof(BY_HANDLE_FILE_INFORMATION));
		result = pPTFSOperations->GetFileInformation(pEventContext->Operation.SetFile.FileName, &byHandleFileInfo, pFileInfo);

		if (result == STATUS_SUCCESS &&(byHandleFileInfo.dwFileAttributes & FILE_ATTRIBUTE_READONLY) != 0)
			return STATUS_CANNOT_DELETE;
	}

	pFileInfo->DeleteOnClose = DeleteFileFlag;

	if (pFileInfo->IsDirectory) 
		result = pPTFSOperations->DeleteDirectory(pEventContext->Operation.SetFile.FileName, pFileInfo);
	else 
		result = pPTFSOperations->DeleteFile(pEventContext->Operation.SetFile.FileName,pFileInfo);

	pFileInfo->DeleteOnClose = DeleteFileFlag;
	return result;
}

NTSTATUS FSSetFile::PTFSSetEndOfFileInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations) 
{
	PFILE_END_OF_FILE_INFORMATION endInfo = (PFILE_END_OF_FILE_INFORMATION)((PCHAR)pEventContext + pEventContext->Operation.SetFile.BufferOffset);

	if (!pPTFSOperations->SetEndOfFile)
		return STATUS_NOT_IMPLEMENTED;

	return pPTFSOperations->SetEndOfFile(pEventContext->Operation.SetFile.FileName, endInfo->EndOfFile.QuadPart, pFileInfo);
}

NTSTATUS FSSetFile::PTFSSetLinkInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations) 
{
	UNREFERENCED_PARAMETER(pEventContext);
	UNREFERENCED_PARAMETER(pFileInfo);
	UNREFERENCED_PARAMETER(pPTFSOperations);

	return STATUS_NOT_IMPLEMENTED;
}

NTSTATUS FSSetFile::PTFSSetRenameInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations) 
{
	PPTFS_RENAME_INFORMATION renameInfo = (PPTFS_RENAME_INFORMATION)((PCHAR)pEventContext + pEventContext->Operation.SetFile.BufferOffset);
	NTSTATUS status = STATUS_NOT_IMPLEMENTED;
	WCHAR* newName = NULL;

	if (!pPTFSOperations->MoveFile)
		return STATUS_NOT_IMPLEMENTED;

	if (renameInfo->FileName[0] != L'\\' && renameInfo->FileName[0] != L':') 
	{
		ULONGLONG pos;
		for (pos = pEventContext->Operation.SetFile.FileNameLength / sizeof(WCHAR);pos != 0; --pos) 
		{
			if (pEventContext->Operation.SetFile.FileName[pos] == '\\')
				break;
		}
		newName = (WCHAR*)malloc((pos + 1) * sizeof(WCHAR) + renameInfo->FileNameLength + sizeof(WCHAR));
		if (newName == NULL)
			return STATUS_INSUFFICIENT_RESOURCES;

		ZeroMemory(newName, (pos + 1) * sizeof(WCHAR) + renameInfo->FileNameLength + sizeof(WCHAR));
		RtlCopyMemory(newName, pEventContext->Operation.SetFile.FileName, (pos + 1) * sizeof(WCHAR));
		RtlCopyMemory((PCHAR)newName + (pos + 1) * sizeof(WCHAR),renameInfo->FileName, renameInfo->FileNameLength);
	}
	else 
	{
		newName = (WCHAR*)malloc(renameInfo->FileNameLength + sizeof(WCHAR));
		if (newName == NULL)
			return STATUS_INSUFFICIENT_RESOURCES;
		ZeroMemory(newName, renameInfo->FileNameLength + sizeof(WCHAR));
		RtlCopyMemory(newName, renameInfo->FileName, renameInfo->FileNameLength);
	}

	status = pPTFSOperations->MoveFile(pEventContext->Operation.SetFile.FileName, newName, renameInfo->ReplaceIfExists, pFileInfo);
	free(newName);
	return status;
}

NTSTATUS FSSetFile::PTFSSetValidDataLengthInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations)
{
	PFILE_VALID_DATA_LENGTH_INFORMATION validInfo = (PFILE_VALID_DATA_LENGTH_INFORMATION)( (PCHAR)pEventContext + pEventContext->Operation.SetFile.BufferOffset);

	if (!pPTFSOperations->SetEndOfFile)
		return STATUS_NOT_IMPLEMENTED;

	return pPTFSOperations->SetEndOfFile(pEventContext->Operation.SetFile.FileName,
		validInfo->ValidDataLength.QuadPart, pFileInfo);
}

VOID FSSetFile::DispatchSetInformation(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance) 
{
	PEVENT_INFORMATION pEventInfo = NULL;
	PPTFS_OPEN_INFO pOpenInfo = NULL;
	PTFS_FILE_INFO fileInfo;
	NTSTATUS status = STATUS_NOT_IMPLEMENTED;
	ULONG sizeOfEventInfo = FSCommon::DispatchGetEventInformationLength(0);

	if (pEventContext->Operation.SetFile.FileInformationClass == FileRenameInformation || 
		pEventContext->Operation.SetFile.FileInformationClass == FileRenameInformationEx) 
	{
		PPTFS_RENAME_INFORMATION renameInfo = (PPTFS_RENAME_INFORMATION)((PCHAR)pEventContext + pEventContext->Operation.SetFile.BufferOffset);
		sizeOfEventInfo = FSCommon::DispatchGetEventInformationLength(renameInfo->FileNameLength);
	}

	FSCommon::CheckFileName(pEventContext->Operation.SetFile.FileName);
	pEventInfo = FSCommon::DispatchCommon(pEventContext, sizeOfEventInfo, pPTFSInstance, &fileInfo, &pOpenInfo);

	switch (pEventContext->Operation.SetFile.FileInformationClass) 
	{
	case FileAllocationInformation:
		status = PTFSSetAllocationInformation(pEventContext, &fileInfo, pPTFSInstance->pPTFSOperations);
		break;

	case FileBasicInformation:
		status = PTFSSetBasicInformation(pEventContext, &fileInfo, pPTFSInstance->pPTFSOperations);
		break;

	case FileDispositionInformation:
	case FileDispositionInformationEx:
		status = PTFSSetDispositionInformation(pEventContext, &fileInfo, pPTFSInstance->pPTFSOperations);
		break;

	case FileEndOfFileInformation:
		status = PTFSSetEndOfFileInformation(pEventContext, &fileInfo, pPTFSInstance->pPTFSOperations);
		break;

	case FileLinkInformation:
		status = PTFSSetLinkInformation(pEventContext, &fileInfo,
			pPTFSInstance->pPTFSOperations);
		break;

	case FilePositionInformation:
		status = STATUS_NOT_IMPLEMENTED;
		break;

	case FileRenameInformation:
	case FileRenameInformationEx:
		status = PTFSSetRenameInformation(pEventContext, &fileInfo, pPTFSInstance->pPTFSOperations);
		break;

	case FileValidDataLengthInformation:
		status = PTFSSetValidDataLengthInformation(pEventContext, &fileInfo, pPTFSInstance->pPTFSOperations);
		break;
	default:
		break;
	}

	if (pOpenInfo != NULL)
		pOpenInfo->UserContext = fileInfo.Context;
	pEventInfo->BufferLength = 0;
	pEventInfo->Status = status;

	if (status == STATUS_SUCCESS) 
	{
		if (pEventContext->Operation.SetFile.FileInformationClass == FileDispositionInformation ||
			pEventContext->Operation.SetFile.FileInformationClass == FileDispositionInformationEx) 
		{
			pEventInfo->Operation.Delete.DeleteOnClose = fileInfo.DeleteOnClose;
		}
		else if (pEventContext->Operation.SetFile.FileInformationClass == FileRenameInformation ||
			pEventContext->Operation.SetFile.FileInformationClass == FileRenameInformationEx) 
		{
			PPTFS_RENAME_INFORMATION renameInfo = (PPTFS_RENAME_INFORMATION)((PCHAR)pEventContext + pEventContext->Operation.SetFile.BufferOffset);
			pEventInfo->BufferLength = renameInfo->FileNameLength;
			CopyMemory(pEventInfo->Buffer, renameInfo->FileName, renameInfo->FileNameLength);
		}
	}

	FSCommon::SendEventInformation(hHandle, pEventInfo, sizeOfEventInfo, pPTFSInstance);
	free(pEventInfo);
}
	