#include "stdafx.h"
#include "security.h"
#include <sddl.h>
#include "common.h"

FSSecurity::FSSecurity(void)
{

}

FSSecurity::~FSSecurity(void)
{

}

NTSTATUS FSSecurity::GetDefaultFileSecurity(LPCWSTR FileName, PSECURITY_INFORMATION SecurityInformation, PSECURITY_DESCRIPTOR SecurityDescriptor,
	ULONG BufferLength, PULONG LengthNeeded, PPTFS_FILE_INFO PTFSFileInfo)
{
	WCHAR buffer[1024];
	WCHAR finalBuffer[2048];
	PTOKEN_USER userToken = NULL;
	PTOKEN_GROUPS groupsToken = NULL;
	HANDLE tokenHandle;
	LPTSTR userSidString = NULL, groupSidString = NULL;

	UNREFERENCED_PARAMETER(FileName);

	if (OpenProcessToken(GetCurrentProcess(), TOKEN_READ, &tokenHandle) == FALSE)
	{
		return STATUS_NOT_IMPLEMENTED;
	}

	DWORD returnLength;
	if (!GetTokenInformation(tokenHandle, TokenUser, buffer, sizeof(buffer), &returnLength))
	{
		CloseHandle(tokenHandle);
		return STATUS_NOT_IMPLEMENTED;
	}

	userToken = (PTOKEN_USER)buffer;
	if (!ConvertSidToStringSid(userToken->User.Sid, &userSidString)) 
	{
		CloseHandle(tokenHandle);
		return STATUS_NOT_IMPLEMENTED;
	}

	if (!GetTokenInformation(tokenHandle, TokenGroups, buffer, sizeof(buffer),&returnLength)) 
	{
		CloseHandle(tokenHandle);
		return STATUS_NOT_IMPLEMENTED;
	}

	groupsToken = (PTOKEN_GROUPS)buffer;
	if (groupsToken->GroupCount > 0) 
	{
		if (!ConvertSidToStringSid(groupsToken->Groups[0].Sid, &groupSidString)) 
		{
			CloseHandle(tokenHandle);
			return STATUS_NOT_IMPLEMENTED;
		}
		swprintf_s(buffer, 1024, L"O:%lsG:%ls", userSidString, groupSidString);
	}
	else
		swprintf_s(buffer, 1024, L"O:%ls", userSidString);

	LocalFree(userSidString);
	LocalFree(groupSidString);
	CloseHandle(tokenHandle);

	if (PTFSFileInfo->IsDirectory)
		swprintf_s(finalBuffer, 2048, L"%lsD:PAI(A;OICI;FA;;;AU)", buffer);
	else
		swprintf_s(finalBuffer, 2048, L"%lsD:AI(A;ID;FA;;;AU)", buffer);

	PSECURITY_DESCRIPTOR SecurityDescriptorTmp = NULL;
	ULONG Size = 0;
	if (!ConvertStringSecurityDescriptorToSecurityDescriptor(finalBuffer, SDDL_REVISION_1, &SecurityDescriptorTmp, &Size))
	{
		return STATUS_NOT_IMPLEMENTED;
	}

	LPTSTR pStringBuffer = NULL;
	if (!ConvertSecurityDescriptorToStringSecurityDescriptor(SecurityDescriptorTmp, SDDL_REVISION_1, *SecurityInformation,&pStringBuffer, NULL)) 
	{
		return STATUS_NOT_IMPLEMENTED;
	}

	LocalFree(SecurityDescriptorTmp);
	SecurityDescriptorTmp = NULL;
	Size = 0;
	if (!ConvertStringSecurityDescriptorToSecurityDescriptor(pStringBuffer, SDDL_REVISION_1, &SecurityDescriptorTmp, &Size)) 
	{
		return STATUS_NOT_IMPLEMENTED;
	}

	if (Size > BufferLength) 
	{
		*LengthNeeded = Size;
		return STATUS_BUFFER_OVERFLOW;
	}

	memcpy(SecurityDescriptor, SecurityDescriptorTmp, Size);
	*LengthNeeded = Size;

	LocalFree(pStringBuffer);
	LocalFree(SecurityDescriptorTmp);

	return STATUS_SUCCESS;
}

VOID FSSecurity::DispatchQuerySecurity(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance) 
{
	PEVENT_INFORMATION pEventInfo = NULL;
	PTFS_FILE_INFO fileInfo;
	PPTFS_OPEN_INFO pOpenInfo = NULL;
	NTSTATUS status = STATUS_NOT_IMPLEMENTED;
	ULONG lengthNeeded = 0;
	ULONG eventInfoLength = FSCommon::DispatchGetEventInformationLength( pEventContext->Operation.Security.BufferLength);

	FSCommon::CheckFileName(pEventContext->Operation.Security.FileName);

	pEventInfo = FSCommon::DispatchCommon(pEventContext, eventInfoLength, pPTFSInstance, &fileInfo, &pOpenInfo);


	if (pPTFSInstance->pPTFSOperations->GetFileSecurity)
	{
		status = pPTFSInstance->pPTFSOperations->GetFileSecurity(
			pEventContext->Operation.Security.FileName,
			&pEventContext->Operation.Security.SecurityInformation,
			&pEventInfo->Buffer, pEventContext->Operation.Security.BufferLength,
			&lengthNeeded, &fileInfo);
	}

	if (status == STATUS_NOT_IMPLEMENTED) 
	{
		status = GetDefaultFileSecurity(
			pEventContext->Operation.Security.FileName,
			&pEventContext->Operation.Security.SecurityInformation,
			&pEventInfo->Buffer, pEventContext->Operation.Security.BufferLength,
			&lengthNeeded, &fileInfo);
	}

	pEventInfo->Status = status;

	if (status != STATUS_SUCCESS && status != STATUS_BUFFER_OVERFLOW)
		pEventInfo->BufferLength = 0;
	else
	{
		pEventInfo->BufferLength = lengthNeeded;
		if (pEventContext->Operation.Security.BufferLength < lengthNeeded) 
			pEventInfo->Status = STATUS_BUFFER_OVERFLOW;
	}

	FSCommon::SendEventInformation(hHandle, pEventInfo, eventInfoLength, pPTFSInstance);
	free(pEventInfo);
}

VOID FSSecurity::DispatchSetSecurity(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance) 
{
	PEVENT_INFORMATION pEventInfo;
	PTFS_FILE_INFO fileInfo;
	PPTFS_OPEN_INFO pOpenInfo;
	NTSTATUS status = STATUS_NOT_IMPLEMENTED;
	PSECURITY_DESCRIPTOR securityDescriptor;
	ULONG eventInfoLength = FSCommon::DispatchGetEventInformationLength(0);

	FSCommon::CheckFileName(pEventContext->Operation.SetSecurity.FileName);

	pEventInfo = FSCommon::DispatchCommon(pEventContext, eventInfoLength, pPTFSInstance,&fileInfo, &pOpenInfo);


	securityDescriptor = (PCHAR)pEventContext + pEventContext->Operation.SetSecurity.BufferOffset;

	if (pPTFSInstance->pPTFSOperations->SetFileSecurity) 
	{
		status = pPTFSInstance->pPTFSOperations->SetFileSecurity(
			pEventContext->Operation.SetSecurity.FileName,
			&pEventContext->Operation.SetSecurity.SecurityInformation,
			securityDescriptor, pEventContext->Operation.SetSecurity.BufferLength,
			&fileInfo);
	}

	if (status != STATUS_SUCCESS) 
	{
		pEventInfo->Status = STATUS_INVALID_PARAMETER;
		pEventInfo->BufferLength = 0;
	}
	else 
	{
		pEventInfo->Status = STATUS_SUCCESS;
		pEventInfo->BufferLength = 0;
	}

	FSCommon::SendEventInformation(hHandle, pEventInfo, eventInfoLength, pPTFSInstance);
	free(pEventInfo);
}
