#include "stdafx.h"
#include "read.h"
#include "common.h"

FSRead::FSRead(void)
{

}

FSRead::~FSRead(void)
{

}

VOID FSRead::DispatchRead(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance) 
{
	PEVENT_INFORMATION pEventInfo = NULL;
	PPTFS_OPEN_INFO pOpenInfo = NULL;
	ULONG readLength = 0;
	NTSTATUS status = STATUS_NOT_IMPLEMENTED;
	PTFS_FILE_INFO fileInfo;
	ULONG sizeOfEventInfo = FSCommon::DispatchGetEventInformationLength( pEventContext->Operation.Read.BufferLength);

	FSCommon::CheckFileName(pEventContext->Operation.Read.FileName);
	pEventInfo = FSCommon::DispatchCommon(pEventContext, sizeOfEventInfo, pPTFSInstance, &fileInfo, &pOpenInfo);

	CLogUtil::DebugLogString(DLEVEL_INFO, L"FSRead::DispatchRead Read %04d\n", pOpenInfo != NULL ? pOpenInfo->EventId : -1);

	if (pPTFSInstance->pPTFSOperations->ReadFile) 
	{
		status = pPTFSInstance->pPTFSOperations->ReadFile(
			pEventContext->Operation.Read.FileName, pEventInfo->Buffer,
			pEventContext->Operation.Read.BufferLength, &readLength,
			pEventContext->Operation.Read.ByteOffset.QuadPart, &fileInfo);
	}

	if (pOpenInfo != NULL)
		pOpenInfo->UserContext = fileInfo.Context;
	pEventInfo->BufferLength = 0;
	pEventInfo->Status = status;

	if (status == STATUS_SUCCESS) 
	{
		if (readLength == 0)
			pEventInfo->Status = STATUS_END_OF_FILE;
		else 
		{
			pEventInfo->BufferLength = readLength;
			pEventInfo->Operation.Read.CurrentByteOffset.QuadPart = pEventContext->Operation.Read.ByteOffset.QuadPart + readLength;
		}
	}

	FSCommon::SendEventInformation(hHandle, pEventInfo, sizeOfEventInfo, pPTFSInstance);
	free(pEventInfo);
}
