
#include "stdafx.h"
#include "lock.h"
#include "PTFSfileinfo.h"
#include "common.h"

FSLock::FSLock(void)
{

}

FSLock::~FSLock(void)
{

}

VOID FSLock::DispatchLock(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance)
{
	PTFS_FILE_INFO fileInfo;
	PEVENT_INFORMATION pEventInfo;
	PPTFS_OPEN_INFO pOpenInfo;
	NTSTATUS status;
	ULONG sizeOfEventInfo = FSCommon::DispatchGetEventInformationLength(0);

	FSCommon::CheckFileName(pEventContext->Operation.Lock.FileName);

	pEventInfo = FSCommon::DispatchCommon(pEventContext, sizeOfEventInfo, pPTFSInstance, &fileInfo, &pOpenInfo);

	pEventInfo->Status = STATUS_NOT_IMPLEMENTED;

	switch (pEventContext->MinorFunction) 
	{
	case IRP_MN_LOCK:
		if (pPTFSInstance->pPTFSOperations->LockFile) 
		{
			status = pPTFSInstance->pPTFSOperations->LockFile(
				pEventContext->Operation.Lock.FileName,
				pEventContext->Operation.Lock.ByteOffset.QuadPart,
				pEventContext->Operation.Lock.Length.QuadPart,
				&fileInfo);

			if (status != STATUS_NOT_IMPLEMENTED) 
				pEventInfo->Status = status != STATUS_SUCCESS ? STATUS_LOCK_NOT_GRANTED : STATUS_SUCCESS;
		}
		break;
	case IRP_MN_UNLOCK_ALL:
		break;
	case IRP_MN_UNLOCK_ALL_BY_KEY:
		break;
	case IRP_MN_UNLOCK_SINGLE:
		if (pPTFSInstance->pPTFSOperations->UnlockFile) 
		{
			status = pPTFSInstance->pPTFSOperations->UnlockFile(
				pEventContext->Operation.Lock.FileName,
				pEventContext->Operation.Lock.ByteOffset.QuadPart,
				pEventContext->Operation.Lock.Length.QuadPart,
				&fileInfo);

			if (status != STATUS_NOT_IMPLEMENTED) 
				pEventInfo->Status = STATUS_SUCCESS;
		}
		break;

	default:
		break;
	}

	if (pOpenInfo != NULL)
		pOpenInfo->UserContext = fileInfo.Context;

	FSCommon::SendEventInformation(hHandle, pEventInfo, sizeOfEventInfo, pPTFSInstance);

	free(pEventInfo);
}
