#include "stdafx.h"
#include "flush.h"
#include "common.h"

FSFlush::FSFlush(void)
{

}

FSFlush::~FSFlush(void)
{

}

VOID FSFlush::DispatchFlush(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance)
{
	PTFS_FILE_INFO fileInfo;
	PEVENT_INFORMATION pEventInfo = NULL;
	PPTFS_OPEN_INFO pOpenInfo = NULL;
	NTSTATUS status;
	ULONG sizeOfEventInfo = FSCommon::DispatchGetEventInformationLength(0);

	FSCommon::CheckFileName(pEventContext->Operation.Flush.FileName);

	pEventInfo = FSCommon::DispatchCommon(pEventContext, sizeOfEventInfo, pPTFSInstance, &fileInfo, &pOpenInfo);

	if (pPTFSInstance->pPTFSOperations->FlushFileBuffers)
		status = pPTFSInstance->pPTFSOperations->FlushFileBuffers(pEventContext->Operation.Flush.FileName, &fileInfo);
	else
		status = STATUS_NOT_IMPLEMENTED;

	if (status == STATUS_NOT_IMPLEMENTED) 
		pEventInfo->Status = STATUS_SUCCESS;
	else 
		pEventInfo->Status = status != STATUS_SUCCESS ? STATUS_NOT_SUPPORTED : STATUS_SUCCESS;

	if (pOpenInfo != NULL)
		pOpenInfo->UserContext = fileInfo.Context;

	FSCommon::SendEventInformation(hHandle, pEventInfo, sizeOfEventInfo, pPTFSInstance);
	free(pEventInfo);
}
