#pragma once

#include "PTFS.h"
#include "PTFSFileinfo.h"

class FSFileInfo
{
public:
    FSFileInfo(void);
    ~FSFileInfo(void);

public:
    static NTSTATUS
        PTFSFillFileBasicInfo(PFILE_BASIC_INFORMATION BasicInfo,
            PBY_HANDLE_FILE_INFORMATION FileInfo,
            PULONG RemainingLength);

    static NTSTATUS
        PTFSFillFileStandardInfo(PFILE_STANDARD_INFORMATION StandardInfo,
            PBY_HANDLE_FILE_INFORMATION FileInfo,
            PULONG RemainingLength,
            PPTFS_FILE_INFO PTFSFileInfo,
            PPTFS_INSTANCE pPTFSInstance);

    static NTSTATUS
        PTFSFillFilePositionInfo(PFILE_POSITION_INFORMATION PosInfo,
            PBY_HANDLE_FILE_INFORMATION FileInfo,
            PULONG RemainingLength);

    static NTSTATUS
        PTFSFillInternalInfo(PFILE_INTERNAL_INFORMATION InternalInfo,
            PBY_HANDLE_FILE_INFORMATION FileInfo,
            PULONG RemainingLength);

    static NTSTATUS
        PTFSFillFileAllInfo(PFILE_ALL_INFORMATION AllInfo,
            PBY_HANDLE_FILE_INFORMATION FileInfo,
            PULONG RemainingLength, PEVENT_CONTEXT pEventContext,
            PPTFS_FILE_INFO PTFSFileInfo,
            PPTFS_INSTANCE pPTFSInstance);

    static NTSTATUS
        PTFSFillFileNameInfo(PFILE_NAME_INFORMATION NameInfo,
            PBY_HANDLE_FILE_INFORMATION FileInfo,
            PULONG RemainingLength, PEVENT_CONTEXT pEventContext);

    static NTSTATUS
        PTFSFillFileAttributeTagInfo(PFILE_ATTRIBUTE_TAG_INFORMATION AttrTagInfo,
            PBY_HANDLE_FILE_INFORMATION FileInfo,
            PULONG RemainingLength);

    static NTSTATUS
        PTFSFillNetworkOpenInfo(PFILE_NETWORK_OPEN_INFORMATION NetInfo,
            PBY_HANDLE_FILE_INFORMATION FileInfo,
            PULONG RemainingLength,
            PPTFS_INSTANCE pPTFSInstance);

    static NTSTATUS
        PTFSFillNetworkPhysicalNameInfo(
            PFILE_NETWORK_PHYSICAL_NAME_INFORMATION NetInfo,
            PBY_HANDLE_FILE_INFORMATION FileInfo, PULONG RemainingLength,
            PEVENT_CONTEXT pEventContext);

    static NTSTATUS
        PTFSFillIdInfo(PFILE_ID_INFORMATION IdInfo,
            PBY_HANDLE_FILE_INFORMATION FileInfo, PULONG RemainingLength);

    static int  WINAPI PTFSFillFindStreamData(PWIN32_FIND_STREAM_DATA FindStreamData,
        PPTFS_FILE_INFO FileInfo);

    static VOID ClearFindStreamData(PLIST_ENTRY ListHead);

    static NTSTATUS
        PTFSFindStreams(PFILE_STREAM_INFORMATION StreamInfo, PPTFS_FILE_INFO FileInfo,
            PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance,
            PULONG RemainingLength);

    static VOID DispatchQueryInformation(HANDLE hHandle, PEVENT_CONTEXT pEventContext,
        PPTFS_INSTANCE pPTFSInstance);

    };


