
#include "stdafx.h"
#include "fileinfo.h"
#include <stdio.h>
#include "common.h"
#include "List/list.h"

FSFileInfo::FSFileInfo(void)
{
}

FSFileInfo::~FSFileInfo(void)
{
}

NTSTATUS FSFileInfo::PTFSFillFileBasicInfo(PFILE_BASIC_INFORMATION BasicInfo, PBY_HANDLE_FILE_INFORMATION FileInfo, PULONG RemainingLength)
{
	if (*RemainingLength < sizeof(FILE_BASIC_INFORMATION))
		return STATUS_BUFFER_OVERFLOW;

	BasicInfo->CreationTime.LowPart = FileInfo->ftCreationTime.dwLowDateTime;
	BasicInfo->CreationTime.HighPart = FileInfo->ftCreationTime.dwHighDateTime;
	BasicInfo->LastAccessTime.LowPart = FileInfo->ftLastAccessTime.dwLowDateTime;
	BasicInfo->LastAccessTime.HighPart = FileInfo->ftLastAccessTime.dwHighDateTime;
	BasicInfo->LastWriteTime.LowPart = FileInfo->ftLastWriteTime.dwLowDateTime;
	BasicInfo->LastWriteTime.HighPart = FileInfo->ftLastWriteTime.dwHighDateTime;
	BasicInfo->ChangeTime.LowPart = FileInfo->ftLastWriteTime.dwLowDateTime;
	BasicInfo->ChangeTime.HighPart = FileInfo->ftLastWriteTime.dwHighDateTime;
	BasicInfo->FileAttributes = FileInfo->dwFileAttributes;

	*RemainingLength -= sizeof(FILE_BASIC_INFORMATION);

	return STATUS_SUCCESS;
}

NTSTATUS FSFileInfo::PTFSFillFileStandardInfo(PFILE_STANDARD_INFORMATION StandardInfo, PBY_HANDLE_FILE_INFORMATION FileInfo, PULONG RemainingLength,
	PPTFS_FILE_INFO PTFSFileInfo, PPTFS_INSTANCE pPTFSInstance)
{
	if (*RemainingLength < sizeof(FILE_STANDARD_INFORMATION))
		return STATUS_BUFFER_OVERFLOW;

	StandardInfo->AllocationSize.HighPart = FileInfo->nFileSizeHigh;
	StandardInfo->AllocationSize.LowPart = FileInfo->nFileSizeLow;
	FSCommon::AlignAllocationSize(&StandardInfo->AllocationSize, pPTFSInstance->pPTFSOptions);
	StandardInfo->EndOfFile.HighPart = FileInfo->nFileSizeHigh;
	StandardInfo->EndOfFile.LowPart = FileInfo->nFileSizeLow;
	StandardInfo->NumberOfLinks = FileInfo->nNumberOfLinks;
	StandardInfo->DeletePending = PTFSFileInfo->DeleteOnClose;
	StandardInfo->Directory = FALSE;

	if (FileInfo->dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		StandardInfo->Directory = TRUE;

	*RemainingLength -= sizeof(FILE_STANDARD_INFORMATION);

	return STATUS_SUCCESS;
}

NTSTATUS FSFileInfo::PTFSFillFilePositionInfo(PFILE_POSITION_INFORMATION PosInfo, PBY_HANDLE_FILE_INFORMATION FileInfo, PULONG RemainingLength)
{
	UNREFERENCED_PARAMETER(FileInfo);

	if (*RemainingLength < sizeof(FILE_POSITION_INFORMATION))
		return STATUS_BUFFER_OVERFLOW;

	PosInfo->CurrentByteOffset.QuadPart = 0;
	*RemainingLength -= sizeof(FILE_POSITION_INFORMATION);

	return STATUS_SUCCESS;
}

NTSTATUS FSFileInfo::PTFSFillInternalInfo(PFILE_INTERNAL_INFORMATION InternalInfo, PBY_HANDLE_FILE_INFORMATION FileInfo, PULONG RemainingLength) 
{
	if (*RemainingLength < sizeof(FILE_INTERNAL_INFORMATION))
		return STATUS_BUFFER_OVERFLOW;

	InternalInfo->IndexNumber.HighPart = FileInfo->nFileIndexHigh;
	InternalInfo->IndexNumber.LowPart = FileInfo->nFileIndexLow;

	*RemainingLength -= sizeof(FILE_INTERNAL_INFORMATION);

	return STATUS_SUCCESS;
}

NTSTATUS FSFileInfo::PTFSFillFileAllInfo(PFILE_ALL_INFORMATION AllInfo, PBY_HANDLE_FILE_INFORMATION FileInfo, PULONG RemainingLength, PEVENT_CONTEXT pEventContext,
	PPTFS_FILE_INFO PTFSFileInfo, PPTFS_INSTANCE pPTFSInstance) 
{
	ULONG allRemainingLength = *RemainingLength;

	if (*RemainingLength < sizeof(FILE_ALL_INFORMATION)) 
		return STATUS_BUFFER_OVERFLOW;

	// FileBasicInformation
	PTFSFillFileBasicInfo(&AllInfo->BasicInformation, FileInfo, RemainingLength);

	// FileStandardInformation
	PTFSFillFileStandardInfo(&AllInfo->StandardInformation, FileInfo,RemainingLength, PTFSFileInfo, pPTFSInstance);

	// FileInternalInformation
	PTFSFillInternalInfo(&AllInfo->InternalInformation, FileInfo,RemainingLength);

	AllInfo->EaInformation.EaSize = 0;

	// FilePositionInformation
	PTFSFillFilePositionInfo(&AllInfo->PositionInformation, FileInfo,RemainingLength);

	if (allRemainingLength < sizeof(FILE_ALL_INFORMATION) + pEventContext->Operation.File.FileNameLength)
	{
		AllInfo->NameInformation.FileNameLength = pEventContext->Operation.File.FileNameLength;
		AllInfo->NameInformation.FileName[0] = pEventContext->Operation.File.FileName[0];
		allRemainingLength -= sizeof(FILE_ALL_INFORMATION);
		*RemainingLength = allRemainingLength;
		return STATUS_BUFFER_OVERFLOW;
	}

	// FileNameInformation
	AllInfo->NameInformation.FileNameLength = pEventContext->Operation.File.FileNameLength;
	RtlCopyMemory(&(AllInfo->NameInformation.FileName[0]), pEventContext->Operation.File.FileName, pEventContext->Operation.File.FileNameLength);

	allRemainingLength -= (sizeof(FILE_ALL_INFORMATION) - sizeof(FILE_NAME_INFORMATION));
	allRemainingLength -= FIELD_OFFSET(FILE_NAME_INFORMATION, FileName[0]);
	allRemainingLength -= AllInfo->NameInformation.FileNameLength;

	*RemainingLength = allRemainingLength;

	return STATUS_SUCCESS;
}

NTSTATUS FSFileInfo::PTFSFillFileNameInfo(PFILE_NAME_INFORMATION NameInfo, PBY_HANDLE_FILE_INFORMATION FileInfo,
	PULONG RemainingLength, PEVENT_CONTEXT pEventContext) 
{
	UNREFERENCED_PARAMETER(FileInfo);

	if (*RemainingLength < sizeof(FILE_NAME_INFORMATION) + pEventContext->Operation.File.FileNameLength) 
		return STATUS_BUFFER_OVERFLOW;

	NameInfo->FileNameLength = pEventContext->Operation.File.FileNameLength;
	RtlCopyMemory(&(NameInfo->FileName[0]), pEventContext->Operation.File.FileName, pEventContext->Operation.File.FileNameLength);

	*RemainingLength -= FIELD_OFFSET(FILE_NAME_INFORMATION, FileName[0]);
	*RemainingLength -= NameInfo->FileNameLength;

	return STATUS_SUCCESS;
}

NTSTATUS FSFileInfo::PTFSFillFileAttributeTagInfo(PFILE_ATTRIBUTE_TAG_INFORMATION AttrTagInfo, PBY_HANDLE_FILE_INFORMATION FileInfo, PULONG RemainingLength) 
{
	if (*RemainingLength < sizeof(FILE_ATTRIBUTE_TAG_INFORMATION))
		return STATUS_BUFFER_OVERFLOW;

	AttrTagInfo->FileAttributes = FileInfo->dwFileAttributes;
	AttrTagInfo->ReparseTag = 0;
	*RemainingLength -= sizeof(FILE_ATTRIBUTE_TAG_INFORMATION);

	return STATUS_SUCCESS;
}

NTSTATUS FSFileInfo::PTFSFillNetworkOpenInfo(PFILE_NETWORK_OPEN_INFORMATION NetInfo, PBY_HANDLE_FILE_INFORMATION FileInfo,
	PULONG RemainingLength, PPTFS_INSTANCE pPTFSInstance) 
{
	if (*RemainingLength < sizeof(FILE_NETWORK_OPEN_INFORMATION))
		return STATUS_BUFFER_OVERFLOW;

	NetInfo->CreationTime.LowPart = FileInfo->ftCreationTime.dwLowDateTime;
	NetInfo->CreationTime.HighPart = FileInfo->ftCreationTime.dwHighDateTime;
	NetInfo->LastAccessTime.LowPart = FileInfo->ftLastAccessTime.dwLowDateTime;
	NetInfo->LastAccessTime.HighPart = FileInfo->ftLastAccessTime.dwHighDateTime;
	NetInfo->LastWriteTime.LowPart = FileInfo->ftLastWriteTime.dwLowDateTime;
	NetInfo->LastWriteTime.HighPart = FileInfo->ftLastWriteTime.dwHighDateTime;
	NetInfo->ChangeTime.LowPart = FileInfo->ftLastWriteTime.dwLowDateTime;
	NetInfo->ChangeTime.HighPart = FileInfo->ftLastWriteTime.dwHighDateTime;
	NetInfo->AllocationSize.HighPart = FileInfo->nFileSizeHigh;
	NetInfo->AllocationSize.LowPart = FileInfo->nFileSizeLow;
	FSCommon::AlignAllocationSize(&NetInfo->AllocationSize, pPTFSInstance->pPTFSOptions);
	NetInfo->EndOfFile.HighPart = FileInfo->nFileSizeHigh;
	NetInfo->EndOfFile.LowPart = FileInfo->nFileSizeLow;
	NetInfo->FileAttributes = FileInfo->dwFileAttributes;

	*RemainingLength -= sizeof(FILE_NETWORK_OPEN_INFORMATION);

	return STATUS_SUCCESS;
}

NTSTATUS FSFileInfo::PTFSFillNetworkPhysicalNameInfo( PFILE_NETWORK_PHYSICAL_NAME_INFORMATION NetInfo,
	PBY_HANDLE_FILE_INFORMATION FileInfo, PULONG RemainingLength, PEVENT_CONTEXT pEventContext) 
{
	UNREFERENCED_PARAMETER(FileInfo);

	if (*RemainingLength < sizeof(FILE_NETWORK_PHYSICAL_NAME_INFORMATION) + pEventContext->Operation.File.FileNameLength)
		return STATUS_BUFFER_OVERFLOW;

	NetInfo->FileNameLength = pEventContext->Operation.File.FileNameLength;
	CopyMemory(NetInfo->FileName, pEventContext->Operation.File.FileName, pEventContext->Operation.File.FileNameLength);

	*RemainingLength -= FIELD_OFFSET(FILE_NETWORK_PHYSICAL_NAME_INFORMATION, FileName[0]);
	*RemainingLength -= NetInfo->FileNameLength;

	return STATUS_SUCCESS;
}

NTSTATUS FSFileInfo::PTFSFillIdInfo(PFILE_ID_INFORMATION IdInfo, PBY_HANDLE_FILE_INFORMATION FileInfo, PULONG RemainingLength) 
{
	if (*RemainingLength < sizeof(FILE_ID_INFORMATION))
		return STATUS_BUFFER_OVERFLOW;

	IdInfo->VolumeSerialNumber = FileInfo->dwVolumeSerialNumber;
	ZeroMemory(IdInfo->FileId.Identifier, sizeof(IdInfo->FileId.Identifier));

	((DWORD*)(IdInfo->FileId.Identifier))[0] = FileInfo->nFileIndexLow;
	((DWORD*)(IdInfo->FileId.Identifier))[1] = FileInfo->nFileIndexHigh;

	*RemainingLength -= sizeof(FILE_ID_INFORMATION);

	return STATUS_SUCCESS;
}

typedef struct _PTFS_FIND_STREAM_DATA {
	WIN32_FIND_STREAM_DATA FindStreamData;
	LIST_ENTRY ListEntry;
} PTFS_FIND_STREAM_DATA, * PPTFS_FIND_STREAM_DATA;

int WINAPI FSFileInfo::PTFSFillFindStreamData(PWIN32_FIND_STREAM_DATA FindStreamData, PPTFS_FILE_INFO FileInfo)
{
	PLIST_ENTRY listHead = ((PPTFS_OPEN_INFO)(UINT_PTR)FileInfo->PTFSContext)->StreamListHead;
	PPTFS_FIND_STREAM_DATA findStreamData;

	findStreamData =(PPTFS_FIND_STREAM_DATA)malloc(sizeof(PTFS_FIND_STREAM_DATA));
	if (findStreamData == NULL)
		return 0;

	ZeroMemory(findStreamData, sizeof(PTFS_FIND_STREAM_DATA));
	InitializeListHead(&findStreamData->ListEntry);

	findStreamData->FindStreamData = *FindStreamData;

	InsertTailList(listHead, &findStreamData->ListEntry);
	return 0;
}

VOID FSFileInfo::ClearFindStreamData(PLIST_ENTRY ListHead)
{
	// free all list entries
	while (!IsListEmpty(ListHead))
	{
		PLIST_ENTRY entry = RemoveHeadList(ListHead);
		PPTFS_FIND_STREAM_DATA find = CONTAINING_RECORD(entry, PTFS_FIND_STREAM_DATA, ListEntry);
		free(find);
	}
}

NTSTATUS FSFileInfo::PTFSFindStreams(PFILE_STREAM_INFORMATION StreamInfo, PPTFS_FILE_INFO FileInfo, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance,
	PULONG RemainingLength) 
{
	PPTFS_OPEN_INFO pOpenInfo = (PPTFS_OPEN_INFO)(UINT_PTR)FileInfo->PTFSContext;
	NTSTATUS status = STATUS_SUCCESS;

	if (!pPTFSInstance->pPTFSOperations->FindStreams)
		return STATUS_NOT_IMPLEMENTED;

	if (pOpenInfo->StreamListHead == NULL)
	{
		pOpenInfo->StreamListHead = (PLIST_ENTRY)malloc(sizeof(LIST_ENTRY));
		if (pOpenInfo->StreamListHead != NULL)
			InitializeListHead(pOpenInfo->StreamListHead);
		else
			status = STATUS_NO_MEMORY;
	}

	if (status == STATUS_SUCCESS && IsListEmpty(pOpenInfo->StreamListHead)) 
	{
		status = pPTFSInstance->pPTFSOperations->FindStreams(pEventContext->Operation.File.FileName, PTFSFillFindStreamData, FileInfo);
	}

	if (status == STATUS_SUCCESS)
	{
		PLIST_ENTRY listHead, entry;
		ULONG entrySize;

		listHead = pOpenInfo->StreamListHead;
		entrySize = 0;

		for (entry = listHead->Flink; entry != listHead; entry = entry->Flink) 
		{
			PPTFS_FIND_STREAM_DATA find = CONTAINING_RECORD(entry, PTFS_FIND_STREAM_DATA, ListEntry);
			ULONG nextEntryOffset = entrySize;
			ULONG streamNameLength = (ULONG)wcslen(find->FindStreamData.cStreamName) * sizeof(WCHAR);
			entrySize = sizeof(FILE_STREAM_INFORMATION) + streamNameLength;
			entrySize = QuadAlign(entrySize);

			if (*RemainingLength < entrySize) 
			{
				status = STATUS_BUFFER_OVERFLOW;
				break;
			}

			if (nextEntryOffset > 0) 
			{
				StreamInfo->NextEntryOffset = nextEntryOffset;
				StreamInfo = (PFILE_STREAM_INFORMATION)((LPBYTE)StreamInfo + StreamInfo->NextEntryOffset);
			}

			StreamInfo->StreamNameLength = streamNameLength;
			memcpy(StreamInfo->StreamName, find->FindStreamData.cStreamName, streamNameLength);
			StreamInfo->StreamSize = find->FindStreamData.StreamSize;
			StreamInfo->StreamAllocationSize = find->FindStreamData.StreamSize;
			StreamInfo->NextEntryOffset = 0;
			FSCommon::AlignAllocationSize(&StreamInfo->StreamAllocationSize, pPTFSInstance->pPTFSOptions);
			*RemainingLength -= entrySize;
		}

		if (status != STATUS_BUFFER_OVERFLOW)
			ClearFindStreamData(pOpenInfo->StreamListHead);
	}
	else
		ClearFindStreamData(pOpenInfo->StreamListHead);

	return status;
}

VOID FSFileInfo::DispatchQueryInformation(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance) 
{
	PEVENT_INFORMATION pEventInfo = NULL;
	PTFS_FILE_INFO fileInfo;
	BY_HANDLE_FILE_INFORMATION byHandleFileInfo;
	ULONG remainingLength;
	NTSTATUS status = STATUS_INVALID_PARAMETER;
	PPTFS_OPEN_INFO pOpenInfo = NULL;
	ULONG sizeOfEventInfo = FSCommon::DispatchGetEventInformationLength(pEventContext->Operation.File.BufferLength);

	FSCommon::CheckFileName(pEventContext->Operation.File.FileName);

	ZeroMemory(&byHandleFileInfo, sizeof(BY_HANDLE_FILE_INFORMATION));

	pEventInfo = FSCommon::DispatchCommon(pEventContext, sizeOfEventInfo, pPTFSInstance, &fileInfo, &pOpenInfo);

	pEventInfo->BufferLength = pEventContext->Operation.File.BufferLength;

	if (pPTFSInstance->pPTFSOperations->GetFileInformation)
	{
		status = pPTFSInstance->pPTFSOperations->GetFileInformation(pEventContext->Operation.File.FileName, &byHandleFileInfo, &fileInfo);
	}

	remainingLength = pEventInfo->BufferLength;

	if (status != STATUS_SUCCESS) 
	{
		pEventInfo->Status = STATUS_INVALID_PARAMETER;
		pEventInfo->BufferLength = 0;
	}
	else
	{
		switch (pEventContext->Operation.File.FileInformationClass)
		{
		case FileBasicInformation:
			status = PTFSFillFileBasicInfo((PFILE_BASIC_INFORMATION)pEventInfo->Buffer, &byHandleFileInfo, &remainingLength);
			break;

		case FileIdInformation:
			status = PTFSFillIdInfo((PFILE_ID_INFORMATION)pEventInfo->Buffer, &byHandleFileInfo, &remainingLength);
			break;

		case FileInternalInformation:
			status = PTFSFillInternalInfo((PFILE_INTERNAL_INFORMATION)pEventInfo->Buffer, &byHandleFileInfo, &remainingLength);
			break;

		case FileEaInformation:
			status = STATUS_SUCCESS;
			remainingLength -= sizeof(FILE_EA_INFORMATION);
			break;

		case FileStandardInformation:
			status = PTFSFillFileStandardInfo((PFILE_STANDARD_INFORMATION)pEventInfo->Buffer, &byHandleFileInfo, &remainingLength, &fileInfo, pPTFSInstance);
			break;

		case FileAllInformation:
			status = PTFSFillFileAllInfo((PFILE_ALL_INFORMATION)pEventInfo->Buffer, &byHandleFileInfo, &remainingLength, pEventContext, &fileInfo, pPTFSInstance);
			break;

		case FileAlternateNameInformation:
			status = STATUS_NOT_IMPLEMENTED;
			break;

		case FileAttributeTagInformation:
			status = PTFSFillFileAttributeTagInfo( (PFILE_ATTRIBUTE_TAG_INFORMATION)pEventInfo->Buffer, &byHandleFileInfo, &remainingLength);
			break;

		case FileCompressionInformation:
			status = STATUS_NOT_IMPLEMENTED;
			break;

		case FileNormalizedNameInformation:
		case FileNameInformation:
			status = PTFSFillFileNameInfo((PFILE_NAME_INFORMATION)pEventInfo->Buffer, &byHandleFileInfo, &remainingLength, pEventContext);
			break;

		case FileNetworkOpenInformation:
			status = PTFSFillNetworkOpenInfo((PFILE_NETWORK_OPEN_INFORMATION)pEventInfo->Buffer, &byHandleFileInfo, &remainingLength, pPTFSInstance);
			break;

		case FilePositionInformation:
			status = PTFSFillFilePositionInfo((PFILE_POSITION_INFORMATION)pEventInfo->Buffer, &byHandleFileInfo, &remainingLength);
			break;
		case FileStreamInformation:
			status = PTFSFindStreams((PFILE_STREAM_INFORMATION)pEventInfo->Buffer,&fileInfo, pEventContext, pPTFSInstance, &remainingLength);
			break;
		case FileNetworkPhysicalNameInformation:
			status = PTFSFillNetworkPhysicalNameInfo((PFILE_NETWORK_PHYSICAL_NAME_INFORMATION)pEventInfo->Buffer, &byHandleFileInfo, &remainingLength, pEventContext);
			break;
		default: 
		{
			status = STATUS_INVALID_PARAMETER;
		}
		break;
	}

		pEventInfo->Status = status;
		pEventInfo->BufferLength = pEventContext->Operation.File.BufferLength - remainingLength;
	}

	if (pOpenInfo != NULL)
		pOpenInfo->UserContext = fileInfo.Context;

	FSCommon::SendEventInformation(hHandle, pEventInfo, sizeOfEventInfo, pPTFSInstance);
	free(pEventInfo);
}
