#pragma once

#include "PTFS.h"
#include "PTFSFileinfo.h"

class FSDirectory
{
public:
    FSDirectory(void);
    ~FSDirectory(void);

public:

    static VOID PTFSFillDirInfo(PFILE_DIRECTORY_INFORMATION Buffer,
        PWIN32_FIND_DATAW FindData, ULONG Index,
        PPTFS_INSTANCE pPTFSInstance);

    static VOID PTFSFillFullDirInfo(PFILE_FULL_DIR_INFORMATION Buffer,
        PWIN32_FIND_DATAW FindData, ULONG Index,
        PPTFS_INSTANCE pPTFSInstance);

    static VOID PTFSFillIdFullDirInfo(PFILE_ID_FULL_DIR_INFORMATION Buffer,
        PWIN32_FIND_DATAW FindData, ULONG Index,
        PPTFS_INSTANCE pPTFSInstance);

    static VOID PTFSFillIdBothDirInfo(PFILE_ID_BOTH_DIR_INFORMATION Buffer,
        PWIN32_FIND_DATAW FindData, ULONG Index,
        PPTFS_INSTANCE pPTFSInstance);

    static VOID PTFSFillIdExtBothDirInfo(PFILE_ID_EXTD_BOTH_DIR_INFORMATION Buffer,
        PWIN32_FIND_DATAW FindData, ULONG Index,
        PPTFS_INSTANCE pPTFSInstance);

    static VOID PTFSFillIdExtDirInfo(PFILE_ID_EXTD_DIR_INFORMATION pBuffer,
        PWIN32_FIND_DATAW pWin32FindData, ULONG Index,
        PPTFS_INSTANCE pPTFSInstance);

    static VOID PTFSFillBothDirInfo(PFILE_BOTH_DIR_INFORMATION Buffer,
        PWIN32_FIND_DATAW FindData, ULONG Index,
        PPTFS_INSTANCE pPTFSInstance);

    static VOID PTFSFillNamesInfo(PFILE_NAMES_INFORMATION Buffer,
        PWIN32_FIND_DATAW FindData, ULONG Index);

    static ULONG PTFSFillDirectoryInformation(FILE_INFORMATION_CLASS DirectoryInfo,
        PVOID Buffer, PULONG LengthRemaining,
        PWIN32_FIND_DATAW FindData, ULONG Index,
        PPTFS_INSTANCE pPTFSInstance);

    static int PTFSFillFileDataEx(PWIN32_FIND_DATAW FindData, PPTFS_FILE_INFO FileInfo,
        BOOLEAN InsertTail);

    static int WINAPI PTFSFillFileData(PWIN32_FIND_DATAW FindData,
        PPTFS_FILE_INFO FileInfo);

    static VOID ClearFindData(PLIST_ENTRY ListHead);

    static LONG MatchFiles(PEVENT_CONTEXT pEventContext, PEVENT_INFORMATION EventInfo,
        PLIST_ENTRY FindDataList, BOOLEAN PatternCheck,
        PPTFS_INSTANCE pPTFSInstance);

    static VOID AddMissingCurrentAndParentFolder(PEVENT_CONTEXT pEventContext,
        PLIST_ENTRY FindDataList,
        PPTFS_FILE_INFO fileInfo);


    static BOOL PTFSIsNameInExpression(LPCWSTR Expression, // matching pattern
        LPCWSTR Name,       // file name
        BOOL IgnoreCase);

    static  VOID DispatchDirectoryInformation(HANDLE hHandle, PEVENT_CONTEXT pEventContext,
        PPTFS_INSTANCE pPTFSInstance);
};


