#include "stdafx.h"
#include "directory.h"
#include "PTFSFileinfo.h"
#include "list\list.h"
#include "common.h"

#ifdef _MSC_VER
#if _MSC_VER < 1300 // VC6
typedef ULONG ULONG_PTR;
#endif
#endif


FSDirectory::FSDirectory(void)
{
}

FSDirectory::~FSDirectory(void)
{
}

VOID FSDirectory::PTFSFillDirInfo(PFILE_DIRECTORY_INFORMATION pBuffer, PWIN32_FIND_DATAW pWin32FindData, ULONG Index, PPTFS_INSTANCE pPTFSInstance)
{
	ULONG nameBytes = (ULONG)wcslen(pWin32FindData->cFileName) * sizeof(WCHAR);

	pBuffer->FileIndex = Index;
	pBuffer->FileAttributes = pWin32FindData->dwFileAttributes;
	pBuffer->FileNameLength = nameBytes;

	pBuffer->EndOfFile.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->EndOfFile.LowPart = pWin32FindData->nFileSizeLow;
	pBuffer->AllocationSize.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->AllocationSize.LowPart = pWin32FindData->nFileSizeLow;
	FSCommon::AlignAllocationSize(&pBuffer->AllocationSize, pPTFSInstance->pPTFSOptions);

	pBuffer->CreationTime.HighPart = pWin32FindData->ftCreationTime.dwHighDateTime;
	pBuffer->CreationTime.LowPart = pWin32FindData->ftCreationTime.dwLowDateTime;

	pBuffer->LastAccessTime.HighPart = pWin32FindData->ftLastAccessTime.dwHighDateTime;
	pBuffer->LastAccessTime.LowPart = pWin32FindData->ftLastAccessTime.dwLowDateTime;

	pBuffer->LastWriteTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->LastWriteTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->ChangeTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->ChangeTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	RtlCopyMemory(pBuffer->FileName, pWin32FindData->cFileName, nameBytes);
}

VOID FSDirectory::PTFSFillFullDirInfo(PFILE_FULL_DIR_INFORMATION pBuffer, PWIN32_FIND_DATAW pWin32FindData, ULONG Index, PPTFS_INSTANCE pPTFSInstance)
{
	ULONG nameBytes = (ULONG)wcslen(pWin32FindData->cFileName) * sizeof(WCHAR);

	pBuffer->FileIndex = Index;
	pBuffer->FileAttributes = pWin32FindData->dwFileAttributes;
	pBuffer->FileNameLength = nameBytes;

	pBuffer->EndOfFile.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->EndOfFile.LowPart = pWin32FindData->nFileSizeLow;
	pBuffer->AllocationSize.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->AllocationSize.LowPart = pWin32FindData->nFileSizeLow;
	FSCommon::AlignAllocationSize(&pBuffer->AllocationSize, pPTFSInstance->pPTFSOptions);

	pBuffer->CreationTime.HighPart = pWin32FindData->ftCreationTime.dwHighDateTime;
	pBuffer->CreationTime.LowPart = pWin32FindData->ftCreationTime.dwLowDateTime;

	pBuffer->LastAccessTime.HighPart = pWin32FindData->ftLastAccessTime.dwHighDateTime;
	pBuffer->LastAccessTime.LowPart = pWin32FindData->ftLastAccessTime.dwLowDateTime;

	pBuffer->LastWriteTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->LastWriteTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->ChangeTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->ChangeTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->EaSize = 0;

	RtlCopyMemory(pBuffer->FileName, pWin32FindData->cFileName, nameBytes);
}

VOID FSDirectory::PTFSFillIdFullDirInfo(PFILE_ID_FULL_DIR_INFORMATION pBuffer, PWIN32_FIND_DATAW pWin32FindData, ULONG Index, PPTFS_INSTANCE pPTFSInstance)
{
	ULONG nameBytes = (ULONG)wcslen(pWin32FindData->cFileName) * sizeof(WCHAR);

	pBuffer->FileIndex = Index;
	pBuffer->FileAttributes = pWin32FindData->dwFileAttributes;
	pBuffer->FileNameLength = nameBytes;

	pBuffer->EndOfFile.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->EndOfFile.LowPart = pWin32FindData->nFileSizeLow;
	pBuffer->AllocationSize.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->AllocationSize.LowPart = pWin32FindData->nFileSizeLow;
	FSCommon::AlignAllocationSize(&pBuffer->AllocationSize, pPTFSInstance->pPTFSOptions);

	pBuffer->CreationTime.HighPart = pWin32FindData->ftCreationTime.dwHighDateTime;
	pBuffer->CreationTime.LowPart = pWin32FindData->ftCreationTime.dwLowDateTime;

	pBuffer->LastAccessTime.HighPart = pWin32FindData->ftLastAccessTime.dwHighDateTime;
	pBuffer->LastAccessTime.LowPart = pWin32FindData->ftLastAccessTime.dwLowDateTime;

	pBuffer->LastWriteTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->LastWriteTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->ChangeTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->ChangeTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->EaSize = 0;
	pBuffer->FileId.QuadPart = 0;

	RtlCopyMemory(pBuffer->FileName, pWin32FindData->cFileName, nameBytes);
}

VOID FSDirectory::PTFSFillIdBothDirInfo(PFILE_ID_BOTH_DIR_INFORMATION pBuffer, PWIN32_FIND_DATAW pWin32FindData, ULONG Index, PPTFS_INSTANCE pPTFSInstance)
{
	ULONG nameBytes = (ULONG)wcslen(pWin32FindData->cFileName) * sizeof(WCHAR);

	pBuffer->FileIndex = Index;
	pBuffer->FileAttributes = pWin32FindData->dwFileAttributes;
	pBuffer->FileNameLength = nameBytes;
	pBuffer->ShortNameLength = 0;

	pBuffer->EndOfFile.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->EndOfFile.LowPart = pWin32FindData->nFileSizeLow;
	pBuffer->AllocationSize.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->AllocationSize.LowPart = pWin32FindData->nFileSizeLow;
	FSCommon::AlignAllocationSize(&pBuffer->AllocationSize, pPTFSInstance->pPTFSOptions);

	pBuffer->CreationTime.HighPart = pWin32FindData->ftCreationTime.dwHighDateTime;
	pBuffer->CreationTime.LowPart = pWin32FindData->ftCreationTime.dwLowDateTime;

	pBuffer->LastAccessTime.HighPart = pWin32FindData->ftLastAccessTime.dwHighDateTime;
	pBuffer->LastAccessTime.LowPart = pWin32FindData->ftLastAccessTime.dwLowDateTime;

	pBuffer->LastWriteTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->LastWriteTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->ChangeTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->ChangeTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->EaSize = 0;
	pBuffer->FileId.QuadPart = 0;

	RtlCopyMemory(pBuffer->FileName, pWin32FindData->cFileName, nameBytes);
}

VOID FSDirectory::PTFSFillIdExtBothDirInfo(PFILE_ID_EXTD_BOTH_DIR_INFORMATION pBuffer, PWIN32_FIND_DATAW pWin32FindData, ULONG Index, PPTFS_INSTANCE pPTFSInstance)
{
	ULONG nameBytes = (ULONG)wcslen(pWin32FindData->cFileName) * sizeof(WCHAR);

	pBuffer->FileIndex = Index;
	pBuffer->FileAttributes = pWin32FindData->dwFileAttributes;
	pBuffer->FileNameLength = nameBytes;
	pBuffer->ShortNameLength = 0;

	pBuffer->EndOfFile.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->EndOfFile.LowPart = pWin32FindData->nFileSizeLow;
	pBuffer->AllocationSize.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->AllocationSize.LowPart = pWin32FindData->nFileSizeLow;
	FSCommon::AlignAllocationSize(&pBuffer->AllocationSize, pPTFSInstance->pPTFSOptions);

	pBuffer->CreationTime.HighPart = pWin32FindData->ftCreationTime.dwHighDateTime;
	pBuffer->CreationTime.LowPart = pWin32FindData->ftCreationTime.dwLowDateTime;

	pBuffer->LastAccessTime.HighPart = pWin32FindData->ftLastAccessTime.dwHighDateTime;
	pBuffer->LastAccessTime.LowPart = pWin32FindData->ftLastAccessTime.dwLowDateTime;

	pBuffer->LastWriteTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->LastWriteTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->ChangeTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->ChangeTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->EaSize = 0;
	pBuffer->ReparsePointTag = 0;
	RtlFillMemory(&pBuffer->FileId.Identifier, sizeof pBuffer->FileId.Identifier, 0);

	RtlCopyMemory(pBuffer->FileName, pWin32FindData->cFileName, nameBytes);
}

VOID FSDirectory::PTFSFillIdExtDirInfo(PFILE_ID_EXTD_DIR_INFORMATION pBuffer, PWIN32_FIND_DATAW pWin32FindData, ULONG Index, PPTFS_INSTANCE pPTFSInstance)
{
	ULONG nameBytes = (ULONG)wcslen(pWin32FindData->cFileName) * sizeof(WCHAR);

	pBuffer->FileIndex = Index;
	pBuffer->FileAttributes = pWin32FindData->dwFileAttributes;
	pBuffer->FileNameLength = nameBytes;

	pBuffer->EndOfFile.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->EndOfFile.LowPart = pWin32FindData->nFileSizeLow;
	pBuffer->AllocationSize.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->AllocationSize.LowPart = pWin32FindData->nFileSizeLow;
	FSCommon::AlignAllocationSize(&pBuffer->AllocationSize, pPTFSInstance->pPTFSOptions);

	pBuffer->CreationTime.HighPart = pWin32FindData->ftCreationTime.dwHighDateTime;
	pBuffer->CreationTime.LowPart = pWin32FindData->ftCreationTime.dwLowDateTime;

	pBuffer->LastAccessTime.HighPart = pWin32FindData->ftLastAccessTime.dwHighDateTime;
	pBuffer->LastAccessTime.LowPart = pWin32FindData->ftLastAccessTime.dwLowDateTime;

	pBuffer->LastWriteTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->LastWriteTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->ChangeTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->ChangeTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->EaSize = 0;
	pBuffer->ReparsePointTag = 0;
	RtlFillMemory(&pBuffer->FileId.Identifier, sizeof pBuffer->FileId.Identifier, 0);

	RtlCopyMemory(pBuffer->FileName, pWin32FindData->cFileName, nameBytes);
}

VOID FSDirectory::PTFSFillBothDirInfo(PFILE_BOTH_DIR_INFORMATION pBuffer, PWIN32_FIND_DATAW pWin32FindData, ULONG Index, PPTFS_INSTANCE pPTFSInstance)
{
	ULONG nameBytes = (ULONG)wcslen(pWin32FindData->cFileName) * sizeof(WCHAR);

	pBuffer->FileIndex = Index;
	pBuffer->FileAttributes = pWin32FindData->dwFileAttributes;
	pBuffer->FileNameLength = nameBytes;
	pBuffer->ShortNameLength = 0;

	pBuffer->EndOfFile.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->EndOfFile.LowPart = pWin32FindData->nFileSizeLow;
	pBuffer->AllocationSize.HighPart = pWin32FindData->nFileSizeHigh;
	pBuffer->AllocationSize.LowPart = pWin32FindData->nFileSizeLow;
	FSCommon::AlignAllocationSize(&pBuffer->AllocationSize, pPTFSInstance->pPTFSOptions);

	pBuffer->CreationTime.HighPart = pWin32FindData->ftCreationTime.dwHighDateTime;
	pBuffer->CreationTime.LowPart = pWin32FindData->ftCreationTime.dwLowDateTime;

	pBuffer->LastAccessTime.HighPart = pWin32FindData->ftLastAccessTime.dwHighDateTime;
	pBuffer->LastAccessTime.LowPart = pWin32FindData->ftLastAccessTime.dwLowDateTime;

	pBuffer->LastWriteTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->LastWriteTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->ChangeTime.HighPart = pWin32FindData->ftLastWriteTime.dwHighDateTime;
	pBuffer->ChangeTime.LowPart = pWin32FindData->ftLastWriteTime.dwLowDateTime;

	pBuffer->EaSize = 0;

	RtlCopyMemory(pBuffer->FileName, pWin32FindData->cFileName, nameBytes);
}

VOID FSDirectory::PTFSFillNamesInfo(PFILE_NAMES_INFORMATION pBuffer, PWIN32_FIND_DATAW pWin32FindData, ULONG Index)
{
	ULONG nameBytes = (ULONG)wcslen(pWin32FindData->cFileName) * sizeof(WCHAR);

	pBuffer->FileIndex = Index;
	pBuffer->FileNameLength = nameBytes;

	RtlCopyMemory(pBuffer->FileName, pWin32FindData->cFileName, nameBytes);
}

ULONG FSDirectory::PTFSFillDirectoryInformation(FILE_INFORMATION_CLASS DirectoryInfo, PVOID pBuffer, PULONG LengthRemaining, PWIN32_FIND_DATAW pWin32FindData, ULONG Index, PPTFS_INSTANCE pPTFSInstance)
{
	ULONG nameBytes;
	ULONG thisEntrySize;

	nameBytes = (ULONG)wcslen(pWin32FindData->cFileName) * sizeof(WCHAR);

	thisEntrySize = nameBytes;

	switch (DirectoryInfo)
	{
	case FileDirectoryInformation:
		thisEntrySize += sizeof(FILE_DIRECTORY_INFORMATION);
		break;
	case FileFullDirectoryInformation:
		thisEntrySize += sizeof(FILE_FULL_DIR_INFORMATION);
		break;
	case FileIdFullDirectoryInformation:
		thisEntrySize += sizeof(FILE_ID_FULL_DIR_INFORMATION);
		break;
	case FileNamesInformation:
		thisEntrySize += sizeof(FILE_NAMES_INFORMATION);
		break;
	case FileBothDirectoryInformation:
		thisEntrySize += sizeof(FILE_BOTH_DIR_INFORMATION);
		break;
	case FileIdBothDirectoryInformation:
		thisEntrySize += sizeof(FILE_ID_BOTH_DIR_INFORMATION);
		break;
	case FileIdExtdBothDirectoryInformation:
		thisEntrySize += sizeof(FILE_ID_EXTD_BOTH_DIR_INFORMATION);
		break;
	case FileIdExtdDirectoryInformation:
		thisEntrySize += sizeof(FILE_ID_EXTD_DIR_INFORMATION);
		break;
	default:
		break;
	}

	thisEntrySize = QuadAlign(thisEntrySize);

	if (*LengthRemaining < thisEntrySize)
	{
		return 0;
	}

	RtlZeroMemory(pBuffer, thisEntrySize);

	switch (DirectoryInfo)
	{
	case FileDirectoryInformation:
		PTFSFillDirInfo((PFILE_DIRECTORY_INFORMATION)pBuffer, pWin32FindData, Index, pPTFSInstance);
		break;
	case FileFullDirectoryInformation:
		PTFSFillFullDirInfo((PFILE_FULL_DIR_INFORMATION)pBuffer, pWin32FindData, Index, pPTFSInstance);
		break;
	case FileIdFullDirectoryInformation:
		PTFSFillIdFullDirInfo((PFILE_ID_FULL_DIR_INFORMATION)pBuffer, pWin32FindData, Index, pPTFSInstance);
		break;
	case FileNamesInformation:
		PTFSFillNamesInfo((PFILE_NAMES_INFORMATION)pBuffer, pWin32FindData, Index);
		break;
	case FileBothDirectoryInformation:
		PTFSFillBothDirInfo((PFILE_BOTH_DIR_INFORMATION)pBuffer, pWin32FindData, Index, pPTFSInstance);
		break;
	case FileIdBothDirectoryInformation:
		PTFSFillIdBothDirInfo((PFILE_ID_BOTH_DIR_INFORMATION)pBuffer, pWin32FindData, Index, pPTFSInstance);
		break;
	case FileIdExtdBothDirectoryInformation:
		PTFSFillIdExtBothDirInfo((PFILE_ID_EXTD_BOTH_DIR_INFORMATION)pBuffer, pWin32FindData, Index, pPTFSInstance);
		break;
	case FileIdExtdDirectoryInformation:
		PTFSFillIdExtDirInfo((PFILE_ID_EXTD_DIR_INFORMATION)pBuffer, pWin32FindData, Index, pPTFSInstance);
		break;
	default:
		break;
	}

	*LengthRemaining -= thisEntrySize;

	return thisEntrySize;
}

int FSDirectory::PTFSFillFileDataEx(PWIN32_FIND_DATAW pWin32FindData, PPTFS_FILE_INFO pFileInfo, BOOLEAN InsertTail)
{
	PLIST_ENTRY listHead = ((PPTFS_OPEN_INFO)(UINT_PTR)pFileInfo->PTFSContext)->DirListHead;
	PPTFS_FIND_DATA findData;

	findData = (PPTFS_FIND_DATA)malloc(sizeof(PTFS_FIND_DATA));
	if (findData == NULL)
	{
		return 0;
	}
	ZeroMemory(findData, sizeof(PTFS_FIND_DATA));
	InitializeListHead(&findData->ListEntry);

	findData->win32FindData = *pWin32FindData;

	if (InsertTail)
		InsertTailList(listHead, &findData->ListEntry);
	else
		InsertHeadList(listHead, &findData->ListEntry);
	return 0;
}

int WINAPI FSDirectory::PTFSFillFileData(PWIN32_FIND_DATAW pWin32FindData, PPTFS_FILE_INFO pFileInfo)
{
	return PTFSFillFileDataEx(pWin32FindData, pFileInfo, TRUE);
}

VOID FSDirectory::ClearFindData(PLIST_ENTRY ListHead)
{
	while (!IsListEmpty(ListHead))
	{
		PLIST_ENTRY entry = RemoveHeadList(ListHead);
		PPTFS_FIND_DATA pFind = CONTAINING_RECORD(entry, PTFS_FIND_DATA, ListEntry);
		free(pFind);
	}
}

LONG FSDirectory::MatchFiles(PEVENT_CONTEXT pEventContext, PEVENT_INFORMATION EventInfo,PLIST_ENTRY FindDataList, BOOLEAN PatternCheck, PPTFS_INSTANCE pPTFSInstance) 
{
	PLIST_ENTRY thisEntry, listHead, nextEntry;
	ULONG lengthRemaining = EventInfo->BufferLength;
	PVOID currentBuffer = EventInfo->Buffer;
	PVOID lastBuffer = currentBuffer;
	ULONG index = 0;
	PWCHAR pattern = NULL;

	if (PatternCheck && pEventContext->Operation.Directory.SearchPatternLength != 0) 
	{
		pattern = (PWCHAR)((SIZE_T)&pEventContext->Operation.Directory.SearchPatternBase[0] + (SIZE_T)pEventContext->Operation.Directory.SearchPatternOffset);
	}

	listHead = FindDataList;

	for (thisEntry = listHead->Flink; thisEntry != listHead; thisEntry = nextEntry) 
	{
		PPTFS_FIND_DATA pFind = NULL;
		nextEntry = thisEntry->Flink;

		pFind = CONTAINING_RECORD(thisEntry, PTFS_FIND_DATA, ListEntry);

		if (!pattern || PTFSIsNameInExpression(pattern, pFind->win32FindData.cFileName, TRUE))
		{
			if (pEventContext->Operation.Directory.FileIndex <= index) 
			{
				ULONG entrySize = PTFSFillDirectoryInformation( (FILE_INFORMATION_CLASS)pEventContext->Operation.Directory.FileInformationClass,
					currentBuffer, &lengthRemaining, &pFind->win32FindData, index + 1, pPTFSInstance);

				if (entrySize == 0)
					break;

				lastBuffer = currentBuffer;

				if (pEventContext->Flags & SL_RETURN_SINGLE_ENTRY) 
				{
					index++;
					break;
				}

				((PFILE_BOTH_DIR_INFORMATION)currentBuffer)->NextEntryOffset = entrySize;
				currentBuffer = (PCHAR)currentBuffer + entrySize;
			}

			index++;
		}
	}

	((PFILE_BOTH_DIR_INFORMATION)lastBuffer)->NextEntryOffset = 0;
	EventInfo->BufferLength = pEventContext->Operation.Directory.BufferLength - lengthRemaining;

	if (index <= pEventContext->Operation.Directory.FileIndex) {

		if (thisEntry != listHead)
			return -2; // BUFFER_OVERFLOW

		return -1; // NO_MORE_FILES
	}

	return index;
}

VOID FSDirectory::AddMissingCurrentAndParentFolder(PEVENT_CONTEXT pEventContext, PLIST_ENTRY FindDataList, PPTFS_FILE_INFO fileInfo) 
{
	PLIST_ENTRY thisEntry, listHead, nextEntry;
	PWCHAR pattern = NULL;
	BOOLEAN currentFolder = FALSE, parentFolder = FALSE;
	WIN32_FIND_DATAW findData;
	FILETIME systime;

	if (pEventContext->Operation.Directory.SearchPatternLength != 0)
		pattern = (PWCHAR)((SIZE_T)&pEventContext->Operation.Directory.SearchPatternBase[0] + (SIZE_T)pEventContext->Operation.Directory.SearchPatternOffset);

	if (wcscmp(pEventContext->Operation.Directory.DirectoryName, L"\\") == 0 || (pattern != NULL && wcscmp(pattern, L"*") != 0))
		return;

	listHead = FindDataList;
	for (thisEntry = listHead->Flink; thisEntry != listHead;thisEntry = nextEntry) 
	{
		PPTFS_FIND_DATA pFind = NULL;
		nextEntry = thisEntry->Flink;

		pFind = CONTAINING_RECORD(thisEntry, PTFS_FIND_DATA, ListEntry);

		if (wcscmp(pFind->win32FindData.cFileName, L".") == 0)
			currentFolder = TRUE;
		if (wcscmp(pFind->win32FindData.cFileName, L"..") == 0)
			parentFolder = TRUE;
		if (currentFolder == TRUE && parentFolder == TRUE)
			return;
	}

	GetSystemTimeAsFileTime(&systime);
	ZeroMemory(&findData, sizeof(WIN32_FIND_DATAW));
	findData.dwFileAttributes = FILE_ATTRIBUTE_DIRECTORY;
	findData.ftCreationTime = systime;
	findData.ftLastAccessTime = systime;
	findData.ftLastWriteTime = systime;

	if (!parentFolder) 
	{
		findData.cFileName[0] = '.';
		findData.cFileName[1] = '.';
		PTFSFillFileDataEx(&findData, fileInfo, FALSE);
	}

	if (!currentFolder) 
	{
		findData.cFileName[0] = '.';
		findData.cFileName[1] = '\0';
		PTFSFillFileDataEx(&findData, fileInfo, FALSE);
	}
}

VOID FSDirectory::DispatchDirectoryInformation(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance) 
{
	PEVENT_INFORMATION pEventInfo = NULL;
	PTFS_FILE_INFO fileInfo;
	PPTFS_OPEN_INFO pOpenInfo = NULL;
	NTSTATUS status = STATUS_SUCCESS;
	ULONG fileInfoClass = pEventContext->Operation.Directory.FileInformationClass;
	BOOLEAN patternCheck = TRUE;
	ULONG sizeOfEventInfo = FSCommon::DispatchGetEventInformationLength(pEventContext->Operation.Directory.BufferLength);

	FSCommon::CheckFileName(pEventContext->Operation.Directory.DirectoryName);

	pEventInfo = FSCommon::DispatchCommon(pEventContext, sizeOfEventInfo, pPTFSInstance,&fileInfo, &pOpenInfo);

	if (fileInfoClass != FileDirectoryInformation &&
		fileInfoClass != FileIdFullDirectoryInformation &&
		fileInfoClass != FileFullDirectoryInformation &&
		fileInfoClass != FileNamesInformation &&
		fileInfoClass != FileIdBothDirectoryInformation &&
		fileInfoClass != FileBothDirectoryInformation &&
		fileInfoClass != FileIdExtdBothDirectoryInformation &&
		fileInfoClass != FileIdExtdDirectoryInformation)
	{
		pEventInfo->BufferLength = 0;
		pEventInfo->Status = STATUS_NOT_IMPLEMENTED;
		FSCommon::SendEventInformation(hHandle, pEventInfo, sizeOfEventInfo, pPTFSInstance);
		free(pEventInfo);
		return;
	}

	pEventInfo->BufferLength = pEventContext->Operation.Directory.BufferLength;

	if (pOpenInfo->DirListHead == NULL) 
	{
		pOpenInfo->DirListHead = (PLIST_ENTRY)malloc(sizeof(LIST_ENTRY));
		if (pOpenInfo->DirListHead != NULL)
		{
			InitializeListHead(pOpenInfo->DirListHead);
		}
		else
		{
			pEventInfo->BufferLength = 0;
			pEventInfo->Status = STATUS_NO_MEMORY;
			FSCommon::SendEventInformation(hHandle, pEventInfo, sizeOfEventInfo, pPTFSInstance);
			free(pEventInfo);
			return;
		}
	}

	if (pEventContext->Operation.Directory.FileIndex == 0) 
		ClearFindData(pOpenInfo->DirListHead);

	if (IsListEmpty(pOpenInfo->DirListHead))
	{
		if (pPTFSInstance->pPTFSOperations->FindFilesWithPattern)
		{
			LPCWSTR pattern = L"*";

			if (pEventContext->Operation.Directory.SearchPatternLength != 0)
				pattern = (PWCHAR)((SIZE_T)&pEventContext->Operation.Directory.SearchPatternBase[0] + (SIZE_T)pEventContext->Operation.Directory.SearchPatternOffset);

			patternCheck = FALSE;
			status = pPTFSInstance->pPTFSOperations->FindFilesWithPattern(pEventContext->Operation.Directory.DirectoryName, pattern, PTFSFillFileData, &fileInfo);
		}
		else
		{
			status = STATUS_NOT_IMPLEMENTED;
		}

		if (status == STATUS_NOT_IMPLEMENTED &&pPTFSInstance->pPTFSOperations->FindFiles)
		{
			patternCheck = TRUE;
			status = pPTFSInstance->pPTFSOperations->FindFiles(pEventContext->Operation.Directory.DirectoryName, PTFSFillFileData, &fileInfo);
		}
	}

	if (status != STATUS_SUCCESS)
	{
		if (pEventContext->Operation.Directory.FileIndex == 0) 
		{
			pEventInfo->Status = STATUS_NO_SUCH_FILE;
		}
		else 
		{
			pEventInfo->Status = STATUS_NO_MORE_FILES;
		}

		pEventInfo->BufferLength = 0;
		pEventInfo->Operation.Directory.Index = pEventContext->Operation.Directory.FileIndex;
		ClearFindData(pOpenInfo->DirListHead);
	}
	else 
	{
		LONG index;
		pEventInfo->Status = STATUS_SUCCESS;

		AddMissingCurrentAndParentFolder(pEventContext, pOpenInfo->DirListHead,&fileInfo);
		index = MatchFiles(pEventContext, pEventInfo, pOpenInfo->DirListHead, patternCheck, pPTFSInstance);

		if (index < 0) 
		{
			pEventInfo->BufferLength = 0;
			pEventInfo->Operation.Directory.Index = pEventContext->Operation.Directory.FileIndex;
			if (index == -1)
			{
				if (pEventContext->Operation.Directory.FileIndex == 0)
				{
					pEventInfo->Status = STATUS_NO_SUCH_FILE;
				}
				else
				{
					pEventInfo->Status = STATUS_NO_MORE_FILES;
				}
			}
			else
			{
				pEventInfo->Status = STATUS_BUFFER_OVERFLOW;
			}

			ClearFindData(pOpenInfo->DirListHead);
		}
		else
		{
			pEventInfo->Operation.Directory.Index = index;
		}
	}

	pOpenInfo->UserContext = fileInfo.Context;
	FSCommon::SendEventInformation(hHandle, pEventInfo, sizeOfEventInfo, pPTFSInstance);
	free(pEventInfo);
}

BOOL  FSDirectory::PTFSIsNameInExpression(LPCWSTR Expression, LPCWSTR Name, BOOL IgnoreCase) 
{
	ULONG ei = 0;
	ULONG ni = 0;

	while (Expression[ei] != '\0')
	{
		if (Expression[ei] == L'*')
		{
			ei++;
			if (Expression[ei] == '\0')
				return TRUE;

			while (Name[ni] != '\0')
			{
				if (PTFSIsNameInExpression(&Expression[ei], &Name[ni], IgnoreCase))
					return TRUE;
				ni++;
			}

		}
		else if (Expression[ei] == DOS_STAR)
		{
			ULONG p = ni;
			ULONG lastDot = 0;
			ei++;

			while (Name[p] != '\0')
			{
				if (Name[p] == L'.')
					lastDot = p;
				p++;
			}

			BOOL endReached = FALSE;
			while (!endReached)
			{
				endReached = (Name[ni] == '\0' || ni == lastDot);
				if (!endReached)
				{
					if (PTFSIsNameInExpression(&Expression[ei], &Name[ni], IgnoreCase))
						return TRUE;
					ni++;
				}
			}
		}
		else if (Expression[ei] == DOS_QM)
		{
			ei++;
			if (Name[ni] != L'.')
			{
				ni++;
			}
			else
			{
				ULONG p = ni + 1;
				while (Name[p] != '\0')
				{
					if (Name[p] == L'.')
						break;
					p++;
				}

				if (Name[p] == L'.')
					ni++;
			}
		}
		else if (Expression[ei] == DOS_DOT)
		{
			ei++;
			if (Name[ni] == L'.')
				ni++;
		}
		else
		{
			if (Expression[ei] == L'?')
			{
				ei++;
				ni++;
			}
			else if (IgnoreCase && towupper(Expression[ei]) == towupper(Name[ni]))
			{
				ei++;
				ni++;
			}
			else if (!IgnoreCase && Expression[ei] == Name[ni])
			{
				ei++;
				ni++;
			}
			else
			{
				return FALSE;
			}
		}
	}

	if (ei == wcslen(Expression) && ni == wcslen(Name))
		return TRUE;

	return FALSE;
}
