#include "stdafx.h"
#include "create.h"
#include "common.h"

FSCreate::FSCreate(void)
{
}

FSCreate::~FSCreate(void)
{
}

VOID FSCreate::SetIOSecurityContext(PEVENT_CONTEXT pEventContext, PPTFS_IO_SECURITY_CONTEXT IoSecurityContext)
{
	PUNICODE_STRING_INTERMEDIATE pIntermediateObjName = NULL;
	PUNICODE_STRING_INTERMEDIATE pIntermediateObjType = NULL;

	IoSecurityContext->AccessState.SecurityEvaluated = pEventContext->Operation.Create.SecurityContext.AccessState.SecurityEvaluated;
	IoSecurityContext->AccessState.GenerateAudit = pEventContext->Operation.Create.SecurityContext.AccessState.GenerateAudit;
	IoSecurityContext->AccessState.GenerateOnClose = pEventContext->Operation.Create.SecurityContext.AccessState.GenerateOnClose;
	IoSecurityContext->AccessState.AuditPrivileges = pEventContext->Operation.Create.SecurityContext.AccessState.AuditPrivileges;
	IoSecurityContext->AccessState.Flags = pEventContext->Operation.Create.SecurityContext.AccessState.Flags;
	IoSecurityContext->AccessState.RemainingDesiredAccess = pEventContext->Operation.Create.SecurityContext.AccessState.RemainingDesiredAccess;
	IoSecurityContext->AccessState.PreviouslyGrantedAccess = pEventContext->Operation.Create.SecurityContext.AccessState.PreviouslyGrantedAccess;
	IoSecurityContext->AccessState.OriginalDesiredAccess = pEventContext->Operation.Create.SecurityContext.AccessState.OriginalDesiredAccess;

	if (pEventContext->Operation.Create.SecurityContext.AccessState.SecurityDescriptorOffset > 0)
	{
		IoSecurityContext->AccessState.SecurityDescriptor = (PSECURITY_DESCRIPTOR)((char*)&pEventContext->Operation.Create.SecurityContext.AccessState +
			pEventContext->Operation.Create.SecurityContext.AccessState.SecurityDescriptorOffset);
	}
	else
	{
		IoSecurityContext->AccessState.SecurityDescriptor = NULL;
	}

	pIntermediateObjName = (PUNICODE_STRING_INTERMEDIATE)((char*)&pEventContext->Operation.Create.SecurityContext.AccessState +
		pEventContext->Operation.Create.SecurityContext.AccessState.UnicodeStringObjectNameOffset);
	pIntermediateObjType = (PUNICODE_STRING_INTERMEDIATE)((char*)&pEventContext->Operation.Create.SecurityContext.AccessState +
		pEventContext->Operation.Create.SecurityContext.AccessState.UnicodeStringObjectTypeOffset);

	IoSecurityContext->AccessState.ObjectName.Length = pIntermediateObjName->Length;
	IoSecurityContext->AccessState.ObjectName.MaximumLength = pIntermediateObjName->MaximumLength;
	IoSecurityContext->AccessState.ObjectName.Buffer = &pIntermediateObjName->Buffer[0];
	IoSecurityContext->AccessState.ObjectType.Length = pIntermediateObjType->Length;
	IoSecurityContext->AccessState.ObjectType.MaximumLength = pIntermediateObjType->MaximumLength;
	IoSecurityContext->AccessState.ObjectType.Buffer = &pIntermediateObjType->Buffer[0];
	IoSecurityContext->DesiredAccess = pEventContext->Operation.Create.SecurityContext.DesiredAccess;
}

BOOL FSCreate::CreateSuccesStatusCheck(NTSTATUS status, ULONG disposition) 
{
  if (NT_SUCCESS(status))
    return TRUE;

  if (status == STATUS_OBJECT_NAME_COLLISION &&
    (disposition == FILE_OPEN_IF || disposition == FILE_SUPERSEDE || disposition == FILE_OVERWRITE_IF))
    return TRUE;

  return FALSE;
}

VOID FSCreate::DispatchCreate(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance)
{
	static int eventId = 0;
	EVENT_INFORMATION eventInfo;
	NTSTATUS status = STATUS_INSUFFICIENT_RESOURCES;
	PTFS_FILE_INFO fileInfo;
	ULONG disposition;	
	PPTFS_OPEN_INFO pOpenInfo = NULL;
	DWORD options;
	PTFS_IO_SECURITY_CONTEXT IoSecurityContext;
	WCHAR* fileName;
	BOOL childExisted = TRUE;
	WCHAR* origFileName = NULL;
	DWORD origOptions;

	fileName = (WCHAR*)((char*)&pEventContext->Operation.Create + pEventContext->Operation.Create.FileNameOffset);

	FSCommon::CheckFileName(fileName);

	RtlZeroMemory(&eventInfo, sizeof(EVENT_INFORMATION));
	RtlZeroMemory(&fileInfo, sizeof(PTFS_FILE_INFO));

	eventInfo.BufferLength = 0;
	eventInfo.SerialNumber = pEventContext->SerialNumber;

	fileInfo.ProcessId = pEventContext->ProcessId;
	fileInfo.pPTFSOptions = pPTFSInstance->pPTFSOptions;

	pOpenInfo = (PPTFS_OPEN_INFO)malloc(sizeof(PTFS_OPEN_INFO));
	if (pOpenInfo == NULL) 
	{
		eventInfo.Status = STATUS_INSUFFICIENT_RESOURCES;
		FSCommon::SendEventInformation(hHandle, &eventInfo, sizeof(EVENT_INFORMATION), NULL);
		return;
	}
	ZeroMemory(pOpenInfo, sizeof(PTFS_OPEN_INFO));
	pOpenInfo->OpenCount = 2;
	pOpenInfo->pEventContext = pEventContext;
	pOpenInfo->pPTFSInstance = pPTFSInstance;
	fileInfo.PTFSContext = (ULONG64)pOpenInfo;

	eventInfo.Context = (ULONG64)pOpenInfo;

	disposition = (pEventContext->Operation.Create.CreateOptions >> 24) & 0x000000ff;
	options = pEventContext->Operation.Create.CreateOptions & FILE_VALID_OPTION_FLAGS;
	origOptions = options;

	if (options & FILE_DIRECTORY_FILE)
	{
		fileInfo.IsDirectory = TRUE;
	}
	else if (pEventContext->Flags & SL_OPEN_TARGET_DIRECTORY)
	{
		origFileName = _wcsdup(fileName);

		options |= FILE_DIRECTORY_FILE;
		options &= ~FILE_NON_DIRECTORY_FILE;

		WCHAR* lastP = NULL;

		for (WCHAR* p = fileName; *p; p++)
		{
			if ((*p == L'\\' || *p == L'/') && p[1])
				lastP = p;
		}

		if (lastP) {
			*lastP = 0;
		}

		if (!fileName[0]) {
			fileName[0] = '\\';
			fileName[1] = 0;
		}
	}


	pOpenInfo->EventId = eventId++;

	if (pPTFSInstance->pPTFSOperations->ZwCreateFile) 
	{

		SetIOSecurityContext(pEventContext, &IoSecurityContext);

		if ((pEventContext->Flags & SL_OPEN_TARGET_DIRECTORY) &&
			pPTFSInstance->pPTFSOperations->Cleanup &&
			pPTFSInstance->pPTFSOperations->CloseFile)
		{

			if (options & FILE_NON_DIRECTORY_FILE && options & FILE_DIRECTORY_FILE)
				status = STATUS_INVALID_PARAMETER;
			else
				status = pPTFSInstance->pPTFSOperations->ZwCreateFile(
					origFileName, &IoSecurityContext, IoSecurityContext.DesiredAccess,
					pEventContext->Operation.Create.FileAttributes,
					pEventContext->Operation.Create.ShareAccess, disposition,
					origOptions, &fileInfo);

			if (CreateSuccesStatusCheck(status, disposition)) {
				pPTFSInstance->pPTFSOperations->Cleanup(origFileName, &fileInfo);
				pPTFSInstance->pPTFSOperations->CloseFile(origFileName, &fileInfo);
			}
			else if (status == STATUS_OBJECT_NAME_NOT_FOUND)
			{
				childExisted = FALSE;
			}

			fileInfo.IsDirectory = TRUE;
		}

		if ((options & FILE_NON_DIRECTORY_FILE) && (options & FILE_DIRECTORY_FILE))
			status = STATUS_INVALID_PARAMETER;
		else
			status = pPTFSInstance->pPTFSOperations->ZwCreateFile(
				fileName, &IoSecurityContext, IoSecurityContext.DesiredAccess,
				pEventContext->Operation.Create.FileAttributes,
				pEventContext->Operation.Create.ShareAccess, disposition, options,
				&fileInfo);

		if (CreateSuccesStatusCheck(status, disposition)&& !childExisted) 
		{
			eventInfo.Operation.Create.Information = FILE_DOES_NOT_EXIST;
		}
	}
	else 
	{
		status = STATUS_NOT_IMPLEMENTED;
	}

	pOpenInfo->IsDirectory = fileInfo.IsDirectory;
	pOpenInfo->UserContext = fileInfo.Context;



	if (!CreateSuccesStatusCheck(status, disposition)) 
	{
		if (pEventContext->Flags & SL_OPEN_TARGET_DIRECTORY) 
		{
		}
		eventInfo.Operation.Create.Information = FILE_DOES_NOT_EXIST;
		eventInfo.Status = status;

		if (status == STATUS_OBJECT_NAME_COLLISION) 
		{
			eventInfo.Operation.Create.Information = FILE_EXISTS;
		}

		if (STATUS_ACCESS_DENIED == status &&
			pPTFSInstance->pPTFSOperations->ZwCreateFile &&
			(pEventContext->Operation.Create.SecurityContext.DesiredAccess &DELETE) )
		{
			WCHAR* lastP = NULL;
			for (WCHAR* p = fileName; *p; p++)
			{
				if ((*p == L'\\' || *p == L'/') && p[1])
					lastP = p;
			}

			if (lastP) 
			{
				*lastP = 0;
			}

			SetIOSecurityContext(pEventContext, &IoSecurityContext);
			ACCESS_MASK newDesiredAccess = (MAXIMUM_ALLOWED & IoSecurityContext.DesiredAccess) ? (FILE_DELETE_CHILD | FILE_LIST_DIRECTORY) : (((DELETE & IoSecurityContext.DesiredAccess) ? FILE_DELETE_CHILD: 0) |
					((FILE_READ_ATTRIBUTES & IoSecurityContext.DesiredAccess) ? FILE_LIST_DIRECTORY: 0));

			options |= FILE_OPEN_FOR_BACKUP_INTENT; //Enable open directory
			options &= ~FILE_NON_DIRECTORY_FILE;    //Remove non dir flag

			status = pPTFSInstance->pPTFSOperations->ZwCreateFile(
				fileName, &IoSecurityContext, newDesiredAccess,
				pEventContext->Operation.Create.FileAttributes,
				pEventContext->Operation.Create.ShareAccess, disposition, options,
				&fileInfo);

			if (status == STATUS_SUCCESS) 
			{
				eventInfo.Status = STATUS_SUCCESS;
				eventInfo.Operation.Create.Information = FILE_OPENED;
			}
		}
	}
	else
	{
		eventInfo.Status = STATUS_SUCCESS;
		eventInfo.Operation.Create.Information = FILE_OPENED;

		if (disposition == FILE_CREATE || disposition == FILE_OPEN_IF ||
			disposition == FILE_OVERWRITE_IF || disposition == FILE_SUPERSEDE) 
		{
			eventInfo.Operation.Create.Information = FILE_CREATED;

			if (status == STATUS_OBJECT_NAME_COLLISION)
			{
				if (disposition == FILE_OPEN_IF) {
					eventInfo.Operation.Create.Information = FILE_OPENED;
				}
				else if (disposition == FILE_OVERWRITE_IF) {
					eventInfo.Operation.Create.Information = FILE_OVERWRITTEN;
				}
				else if (disposition == FILE_SUPERSEDE) {
					eventInfo.Operation.Create.Information = FILE_SUPERSEDED;
				}
			}
		}

		if (disposition == FILE_OVERWRITE)
			eventInfo.Operation.Create.Information = FILE_OVERWRITTEN;

		if (fileInfo.IsDirectory)
			eventInfo.Operation.Create.Flags |= PTFS_FILE_DIRECTORY;
	}

	if (origFileName)
		free(origFileName);

	if (!NT_SUCCESS(eventInfo.Status)) 
	{
		free((PPTFS_OPEN_INFO)(UINT_PTR)eventInfo.Context);
		eventInfo.Context = 0;
	}

	FSCommon::SendEventInformation(hHandle, &eventInfo, sizeof(EVENT_INFORMATION),pPTFSInstance);
}
