#include "stdafx.h"
#include "common.h"
#include "directory.h"
#include "fileinfo.h"

FSCommon::FSCommon(void)
{

}

FSCommon::~FSCommon(void)
{

}

ULONG FSCommon::DispatchGetEventInformationLength(ULONG bufferSize) 
{
    return std::max((ULONG)sizeof(EVENT_INFORMATION), (ULONG)sizeof(EVENT_INFORMATION) - 8 + bufferSize);
}

PEVENT_INFORMATION FSCommon::DispatchCommon(PEVENT_CONTEXT pEventContext, ULONG SizeOfEventInfo, 
    PPTFS_INSTANCE pPTFSInstance, PPTFS_FILE_INFO PTFSFileInfo, PPTFS_OPEN_INFO* PTFSOpenInfo) 
{
    PEVENT_INFORMATION eventInfo = (PEVENT_INFORMATION)malloc(SizeOfEventInfo);

    if (eventInfo == NULL)
        return NULL;
 
    RtlZeroMemory(eventInfo, SizeOfEventInfo);
    RtlZeroMemory(PTFSFileInfo, sizeof(PTFS_FILE_INFO));

    eventInfo->BufferLength = 0;
    eventInfo->SerialNumber = pEventContext->SerialNumber;

    PTFSFileInfo->ProcessId = pEventContext->ProcessId;
    PTFSFileInfo->pPTFSOptions = pPTFSInstance->pPTFSOptions;
    if (pEventContext->FileFlags & PTFS_DELETE_ON_CLOSE) {
        PTFSFileInfo->DeleteOnClose = 1;
    }
    if (pEventContext->FileFlags & PTFS_PAGING_IO) {
        PTFSFileInfo->PagingIo = 1;
    }
    if (pEventContext->FileFlags & PTFS_WRITE_TO_END_OF_FILE) {
        PTFSFileInfo->WriteToEndOfFile = 1;
    }
    if (pEventContext->FileFlags & PTFS_SYNCHRONOUS_IO) {
        PTFSFileInfo->SynchronousIo = 1;
    }
    if (pEventContext->FileFlags & PTFS_NOCACHE) {
        PTFSFileInfo->Nocache = 1;
    }

    *PTFSOpenInfo = FSCommon::GetPTFSOpenInfo(pEventContext, pPTFSInstance);
    if (*PTFSOpenInfo == NULL)
    {
        return eventInfo;
    }

    PTFSFileInfo->Context = (ULONG64)(*PTFSOpenInfo)->UserContext;
    PTFSFileInfo->IsDirectory = (UCHAR)(*PTFSOpenInfo)->IsDirectory;
    PTFSFileInfo->PTFSContext = (ULONG64)(*PTFSOpenInfo);

    eventInfo->Context = (ULONG64)(*PTFSOpenInfo);

    return eventInfo;
}

PPTFS_OPEN_INFO FSCommon::GetPTFSOpenInfo(PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance) 
{
    PPTFS_OPEN_INFO pOpenInfo = NULL;
    EnterCriticalSection(&pPTFSInstance->CriticalSection);

    pOpenInfo = (PPTFS_OPEN_INFO)(UINT_PTR)pEventContext->Context;
    if (pOpenInfo != NULL) 
    {
        pOpenInfo->OpenCount++;
        pOpenInfo->pEventContext = pEventContext;
        pOpenInfo->pPTFSInstance = pPTFSInstance;
    }
    LeaveCriticalSection(&pPTFSInstance->CriticalSection);
    return pOpenInfo;
}

VOID FSCommon::ReleasePTFSOpenInfo(PEVENT_INFORMATION EventInformation, PPTFS_INSTANCE pPTFSInstance) 
{
    PPTFS_OPEN_INFO pOpenInfo = NULL;
    EnterCriticalSection(&pPTFSInstance->CriticalSection);

    pOpenInfo = (PPTFS_OPEN_INFO)(UINT_PTR)EventInformation->Context;
    if (pOpenInfo != NULL) 
    {
        pOpenInfo->OpenCount--;
        if (pOpenInfo->OpenCount < 1) 
        {
            if (pOpenInfo->DirListHead != NULL) 
            {
                FSDirectory::ClearFindData(pOpenInfo->DirListHead);
                free(pOpenInfo->DirListHead);
                pOpenInfo->DirListHead = NULL;
            }

            if (pOpenInfo->StreamListHead != NULL) 
            {
                FSFileInfo::ClearFindStreamData(pOpenInfo->StreamListHead);
                free(pOpenInfo->StreamListHead);
                pOpenInfo->StreamListHead = NULL;
            }

            free(pOpenInfo);
            EventInformation->Context = 0;
        }
    }
    LeaveCriticalSection(&pPTFSInstance->CriticalSection);
}

VOID FSCommon::CheckFileName(LPWSTR FileName)
{
    size_t len = wcslen(FileName);
    if (len >= 2 && FileName[0] == L'\\' && FileName[1] == L'\\') 
    {
        int i;
        for (i = 0; FileName[i + 1] != L'\0'; ++i) {
            FileName[i] = FileName[i + 1];
        }
        FileName[i] = L'\0';
    }

    len = wcslen(FileName);
    if (len > 2 && FileName[len - 1] == L'\\')
        FileName[len - 1] = '\0';
}

VOID FSCommon::SendEventInformation(HANDLE hHandle, PEVENT_INFORMATION EventInfo,
    ULONG EventLength, PPTFS_INSTANCE pPTFSInstance) 
{
    BOOL status = FALSE;
    ULONG returnedLength;

    if (pPTFSInstance != NULL) 
    {
        FSCommon::ReleasePTFSOpenInfo(EventInfo, pPTFSInstance);
    }

    status = DeviceIoControl(hHandle,
        IOCTL_EVENT_INFO,
        EventInfo,
        EventLength,
        NULL,
        0,
        &returnedLength,
        NULL
    );
}

void FSCommon::AlignAllocationSize(PLARGE_INTEGER size, PPTFS_OPTIONS pPTFSOptions)
{
    long long r = size->QuadPart % pPTFSOptions->AllocationUnitSize;
    size->QuadPart = (size->QuadPart + (r > 0 ? pPTFSOptions->AllocationUnitSize - r : 0));
}
