#include "stdafx.h"
#include "close.h"
#include "common.h"

FSClose::FSClose(void)
{
}

FSClose::~FSClose(void)
{
}

VOID FSClose::DispatchClose(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance)
{
	PEVENT_INFORMATION pEventInfo = NULL;
	PTFS_FILE_INFO fileInfo;
	PPTFS_OPEN_INFO pOpenInfo = NULL;
	ULONG sizeOfEventInfo = FSCommon::DispatchGetEventInformationLength(0);

	UNREFERENCED_PARAMETER(hHandle);

	FSCommon::CheckFileName(pEventContext->Operation.Close.FileName);

	pEventInfo = FSCommon::DispatchCommon(pEventContext, sizeOfEventInfo, pPTFSInstance, &fileInfo, &pOpenInfo);

	pEventInfo->Status = STATUS_SUCCESS;

	if (pPTFSInstance->pPTFSOperations->CloseFile)
		pPTFSInstance->pPTFSOperations->CloseFile( pEventContext->Operation.Close.FileName, &fileInfo);

	if (pOpenInfo != NULL) 
	{
		EnterCriticalSection(&pPTFSInstance->CriticalSection);
		pOpenInfo->OpenCount--;
		LeaveCriticalSection(&pPTFSInstance->CriticalSection);
	}

	FSCommon::ReleasePTFSOpenInfo(pEventInfo, pPTFSInstance);
	free(pEventInfo);
}
