#include "stdafx.h"
#include "cleanup.h"
#include "common.h"

FSCleanup::FSCleanup(void)
{
}

FSCleanup::~FSCleanup(void)
{
}

VOID FSCleanup::DispatchCleanup(HANDLE hHandle, PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance)
{
	PEVENT_INFORMATION pEventInfo = NULL;
	PTFS_FILE_INFO FileInfo;
	PPTFS_OPEN_INFO pOpenInfo = NULL;
	ULONG sizeOfEventInfo = FSCommon::DispatchGetEventInformationLength(0);

	FSCommon::CheckFileName(pEventContext->Operation.Cleanup.FileName);
	pEventInfo = FSCommon::DispatchCommon(pEventContext, sizeOfEventInfo, pPTFSInstance, &FileInfo, &pOpenInfo);
	pEventInfo->Status = STATUS_SUCCESS;

	if (pPTFSInstance->pPTFSOperations->Cleanup)
		pPTFSInstance->pPTFSOperations->Cleanup(pEventContext->Operation.Cleanup.FileName, &FileInfo);

	if (pOpenInfo != NULL)
		pOpenInfo->UserContext = FileInfo.Context;

	FSCommon::SendEventInformation(hHandle, pEventInfo, sizeOfEventInfo, pPTFSInstance);

	free(pEventInfo);
}
