#pragma once

#include "PTFS.h"
#include "PTFSFileinfo.h"

class CPTFSUtil
{
public:
	CPTFSUtil(void);
	~CPTFSUtil(void);

public:
	static CRITICAL_SECTION	m_InstanceCriticalSection;
	static LIST_ENTRY			m_InstanceList;

public:
	static void InitializeResource();
	static void DeleteResource();

	static PPTFS_INSTANCE NewPTFSInstance();
	static void DeletePTFSInstance(PPTFS_INSTANCE pInstance);
	static int CheckMountPoint(LPCWSTR lpcwszMountPoint);
	static BOOL IsValidDriveLetter(WCHAR wDriveLetter);
	static BOOL IsNameInExpression(LPCWSTR lpcwszExpression, LPCWSTR lpcwszName, BOOL bIgnoreCase);
	static LPCWSTR GetRawDeviceName(LPCWSTR	lpcwszDeviceName);
	static VOID CheckFileName(LPWSTR	lpwszFileName);
	static ULONG GetNTStatus(DWORD dwErrorCode);

	static VOID FillDirInfo(PFILE_DIRECTORY_INFORMATION pBuffer, PWIN32_FIND_DATAW pFindData, ULONG ulIndex);
	static VOID FillFullDirInfo(PFILE_FULL_DIR_INFORMATION pBuffer, PWIN32_FIND_DATAW pFindData, ULONG ulIndex);
	static VOID FillIdFullDirInfo(PFILE_ID_FULL_DIR_INFORMATION pBuffer, PWIN32_FIND_DATAW pFindData, ULONG ulIndex);
	static VOID FillIdBothDirInfo(PFILE_ID_BOTH_DIR_INFORMATION pBuffer, PWIN32_FIND_DATAW pFindData, ULONG ulIndex);
	static VOID FillBothDirInfo(PFILE_BOTH_DIR_INFORMATION pBuffer, PWIN32_FIND_DATAW pFindData, ULONG ulIndex);
	static VOID FillNamesInfo(PFILE_NAMES_INFORMATION	pBuffer, PWIN32_FIND_DATAW pFindData, ULONG ulIndex);
	static ULONG FillDirectoryInformation(FILE_INFORMATION_CLASS DirectoryInfo, PVOID pBuffer, PULONG pulLengthRemaining,
		PWIN32_FIND_DATAW pFindData, ULONG ulIndex);
	static VOID ClearFindData(PLIST_ENTRY pListHead);
	static VOID WINAPI ClearFindData2(PPTFS_FILE_INFO FileInfo);
	static LONG MatchFiles(PEVENT_CONTEXT pEventContext, PEVENT_INFORMATION pEventInfo, PLIST_ENTRY pFindDataList, BOOLEAN bPatternCheck);

	static PPTFS_OPEN_INFO GetPTFSOpenInfo(PEVENT_CONTEXT pEventContext, PPTFS_INSTANCE pPTFSInstance);
	static VOID ReleasePTFSOpenInfo(PEVENT_INFORMATION pEventInformation, PPTFS_INSTANCE pPTFSInstance);

	static ULONG FillFileBasicInfo(PFILE_BASIC_INFORMATION pBasicInfo, PBY_HANDLE_FILE_INFORMATION pFileInfo, PULONG pulRemainingLength);
	static ULONG FillFileStandardInfo(PFILE_STANDARD_INFORMATION pStandardInfo, PBY_HANDLE_FILE_INFORMATION pFileInfo, PULONG pulRemainingLength);
	static ULONG FillFilePositionInfo(PFILE_POSITION_INFORMATION pPosInfo, PBY_HANDLE_FILE_INFORMATION pFileInfo, PULONG pulRemainingLength);
	static ULONG FillFileAllInfo(PFILE_ALL_INFORMATION pAllInfo, PBY_HANDLE_FILE_INFORMATION pFileInfo,
		PULONG pulRemainingLength, PEVENT_CONTEXT pEventContext);
	static ULONG FillFileNameInfo(PFILE_NAME_INFORMATION pNameInfo, PBY_HANDLE_FILE_INFORMATION pFileInfo,
		PULONG pulRemainingLength, PEVENT_CONTEXT pEventContext);
	static ULONG FillFileAttributeTagInfo(PFILE_ATTRIBUTE_TAG_INFORMATION pAttrTagInfo, PBY_HANDLE_FILE_INFORMATION pFileInfo, PULONG pulRemainingLength);
	static ULONG FillNetworkOpenInfo(PFILE_NETWORK_OPEN_INFORMATION pNetInfo, PBY_HANDLE_FILE_INFORMATION pFileInfo, PULONG pulRemainingLength);
	static ULONG FillInternalInfo(PFILE_INTERNAL_INFORMATION pInternalInfo, PBY_HANDLE_FILE_INFORMATION pFileInfo, PULONG pulRemainingLength);

	static int WINAPI GetDiskFreeSpace(PULONGLONG pFreeBytesAvailable, PULONGLONG pTotalNumberOfBytes,
		PULONGLONG pTotalNumberOfFreeBytes, PPTFS_FILE_INFO pPTFSFileInfo);
	static int WINAPI GetVolumeInformation(LPWSTR lpwszVolumeNameBuffer, DWORD dwVolumeNameSize, LPDWORD lpdwVolumeSerialNumber,
		LPDWORD lpdwMaximumComponentLength, LPDWORD lpdwFileSystemFlags, LPWSTR lpwszFileSystemNameBuffer, DWORD dwFileSystemNameSize,
		PPTFS_FILE_INFO pPTFSFileInfo);
	static ULONG FsVolumeInformation(PEVENT_INFORMATION pEventInfo, PEVENT_CONTEXT pEventContext, 
		PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations);
	static ULONG FsSizeInformation(PEVENT_INFORMATION pEventInfo, PEVENT_CONTEXT pEventContext,
		PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations);
	static ULONG FsAttributeInformation(PEVENT_INFORMATION pEventInfo, PEVENT_CONTEXT pEventContext,
		PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations);
	static ULONG FsFullSizeInformation(PEVENT_INFORMATION pEventInfo, PEVENT_CONTEXT pEventContext,
		PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations);

	static int SetAllocationInformation(PEVENT_CONTEXT	 pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations);
	static int SetBasicInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations);
	static int SetDispositionInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations);
	static int SetEndOfFileInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations);
	static int SetLinkInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations);
	static int SetRenameInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations);
	static int SetValidDataLengthInformation(PEVENT_CONTEXT pEventContext, PPTFS_FILE_INFO pFileInfo, PPTFS_OPERATIONS pPTFSOperations);
};
