#include "StdAfx.h"
#include "PTFSRes.h"
#include "PTFSCtl.h"
#include "util/util.h"
#include "List/List.h"


CRITICAL_SECTION	CPTFSRes::m_InstanceCriticalSection;
LIST_ENTRY				CPTFSRes::m_InstanceList;	

CPTFSRes::CPTFSRes(void)
{
}

CPTFSRes::~CPTFSRes(void)
{
}

void CPTFSRes::InitializeResource()
{
#if _MSC_VER < 1300
	InitializeCriticalSection(&m_InstanceCriticalSection);
#else
	InitializeCriticalSectionAndSpinCount(&m_InstanceCriticalSection, 0x80000400);
#endif			
	InitializeListHead(&m_InstanceList);
}

void CPTFSRes::DeleteResource()
{
	EnterCriticalSection(&m_InstanceCriticalSection);

	while(!IsListEmpty(&m_InstanceList)) {
		PLIST_ENTRY pEntry = RemoveHeadList(&m_InstanceList);
		PPTFS_INSTANCE pInstance =CONTAINING_RECORD(pEntry, PTFS_INSTANCE, ListEntry);	
		CPTFSCtl::RemoveMountPoint(pInstance->MountPoint, TRUE);
		free(pInstance);
	}

	LeaveCriticalSection(&m_InstanceCriticalSection);
	DeleteCriticalSection(&m_InstanceCriticalSection);
}

PPTFS_INSTANCE CPTFSRes::NewPTFSInstance()
{
	PPTFS_INSTANCE pInstance = (PPTFS_INSTANCE)malloc(sizeof(PTFS_INSTANCE));
	ZeroMemory(pInstance, sizeof(PTFS_INSTANCE));

#if _MSC_VER < 1300
	InitializeCriticalSection(&pInstance->CriticalSection);
#else
	InitializeCriticalSectionAndSpinCount( &pInstance->CriticalSection, 0x80000400);
#endif

	InitializeListHead(&pInstance->ListEntry);

	EnterCriticalSection(&m_InstanceCriticalSection);
	InsertTailList(&m_InstanceList, &pInstance->ListEntry);
	LeaveCriticalSection(&m_InstanceCriticalSection);

	return pInstance;
}

VOID CPTFSRes::DeletePTFSInstance(PPTFS_INSTANCE pInstance)
{
	DeleteCriticalSection(&pInstance->CriticalSection);

	EnterCriticalSection(&m_InstanceCriticalSection);
	RemoveEntryList(&pInstance->ListEntry);
	LeaveCriticalSection(&m_InstanceCriticalSection);

	free(pInstance);
}

