#pragma once

#include "PTFS.h"
#include "PTFSFileinfo.h"
#include "PTFSDriver.h"

#pragma warning(push)
#pragma warning(disable : 4201)
typedef struct _REPARSE_DATA_BUFFER {
	ULONG ReparseTag;
	USHORT ReparseDataLength;
	USHORT Reserved;
	union {
		struct {
			USHORT SubstituteNameOffset;
			USHORT SubstituteNameLength;
			USHORT PrintNameOffset;
			USHORT PrintNameLength;
			ULONG Flags;
			WCHAR PathBuffer[1];
		} SymbolicLinkReparseBuffer;
		struct {
			USHORT SubstituteNameOffset;
			USHORT SubstituteNameLength;
			USHORT PrintNameOffset;
			USHORT PrintNameLength;
			WCHAR PathBuffer[1];
		} MountPointReparseBuffer;
		struct {
			UCHAR DataBuffer[1];
		} GenericReparseBuffer;
	} DUMMYUNIONNAME;
} REPARSE_DATA_BUFFER, * PREPARSE_DATA_BUFFER;
#pragma warning(pop)

#define REPARSE_DATA_BUFFER_HEADER_SIZE     FIELD_OFFSET(REPARSE_DATA_BUFFER, GenericReparseBuffer)

class CPTFSMgr;

typedef struct _st_BroadCast_Param_
{
	WCHAR cLetter;
	BOOL bRemoved;
	BOOL bSafe;
	HANDLE hStartEvent;
	CPTFSMgr* pPTFSMgr;
}BROADCAST_PARAM, * PBROADCAST_PARAM;

class CPTFSMgr
{
public:
	CPTFSMgr(void);
	~CPTFSMgr(void);

private:
	BOOL m_bDebugMode;
	BOOL m_bUseStdErr;

	CRITICAL_SECTION	m_InstanceCriticalSection;
	LIST_ENTRY				m_InstanceList;

	PPTFS_INSTANCE		m_pPTFSInstance;
	CPTFSDriver				m_PTFSDriver;

	HANDLE						m_hKeepAlive;
	HANDLE						m_hNotify;
	HANDLE						m_hBroadCastThread;
	static UINT WINAPI PTFSLoopThreadProc(PVOID pThreadParam);
	static UINT WINAPI PTFSKeepAlive(PVOID pThreadParam);

	static UINT WINAPI BroadcastLinkThreadProc(PVOID pThreadParam);
	void WaitBroadCastThread();

public:
	BOOL							m_bCompleteMount;
	BOOL							m_bCompleteWaitMount;

public:
	void SetUseStdErr(BOOL bStatus);
	void SetDebugMode(BOOL bStatus);
	BOOL GetUseStdErr();
	BOOL GetDebugMode();

	BOOL NewPTFSInstance();
	void DeletePTFSInstance();
	PPTFS_INSTANCE GetPTFSInstance();
	CPTFSDriver* GetPTFSDriver();

	BOOL IsMountPointDriveLetter(LPCWSTR mountPoint);
	BOOL IsValidDriveLetter(WCHAR DriveLetter);
	BOOL CheckDriveLetterAvailability(WCHAR DriveLetter);
	void CheckAllocationUnitSectorSize(PPTFS_OPTIONS pPTFSOptions);
	BOOL CleanUpMountPoints();
	VOID GetRawDeviceName(LPCWSTR DeviceName, LPWSTR DestinationBuffer,
		rsize_t DestinationBufferSizeInElements);

	BOOL EnableTokenPrivilege(LPCTSTR lpszSystemName, BOOL bEnable);
	void BroadcastLink(WCHAR cLetter, BOOL bRemoved, BOOL safe);
	BOOL IsReadyToMount(WCHAR cLetter);

	BOOL CreateMountPoint(LPCWSTR MountPoint, LPCWSTR DeviceName);
	BOOL DeleteMountPoint(LPCWSTR MountPoint);
	BOOL RemoveMountPointEx(LPCWSTR MountPoint, BOOL Safe);
	BOOL PTFSRemoveMountPoint(LPCWSTR MountPoint, BOOL bForce);

	BOOL PTFSMount(LPCWSTR MountPoint, LPCWSTR DeviceName, PPTFS_OPTIONS pPTFSOptions);
	BOOL PTFSUnmount(WCHAR DriveLetter, BOOL bForce = FALSE);

	BOOL DoStart();
	int  DoInintialize(PPTFS_OPTIONS pPTFSOptions, PPTFS_OPERATIONS pPTFSOperations, HANDLE hMountWaitEvent);
	void  DoFinalize();

	BOOL SendReleaseIRP(LPCWSTR DeviceName);
	BOOL SendGlobalReleaseIRP(LPCWSTR MountPoint);

	BOOL SetDebugModeInDevice(ULONG Mode);

	PPTFS_CONTROL GetMountPointList(BOOL uncOnly, PULONG nbRead);
	VOID ReleaseMountPointList(PPTFS_CONTROL list);

	void MapKernelToUserCreateFileFlags(ACCESS_MASK DesiredAccess, ULONG FileAttributes, ULONG CreateOptions, ULONG CreateDisposition,
		ACCESS_MASK* outDesiredAccess, DWORD* outFileAttributesAndFlags, DWORD* outCreationDisposition);

	void WaitMount(WCHAR cLetter, BOOL bRemovedMount);

};
