// PTFSLib.cpp : Defines the initialization routines for the DLL.
//

#include "stdafx.h"
#include "PTFSLib.h"
#include "NetworkUtil.h"
#include "PTFSCtl.h"
#include "PTFSUtil.h"
#include "PTFSFileinfo.h"
#include "PTFSDispatch.h"
#include <winioctl.h>
#include <process.h>
#include "NtStatus/PTNtstatus.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

//
//TODO: If this DLL is dynamically linked against the MFC DLLs,
//		any functions exported from this DLL which call into
//		MFC must have the AFX_MANAGE_STATE macro added at the
//		very beginning of the function.
//
//		For example:
//
//		extern "C" BOOL PASCAL EXPORT ExportedFunction()
//		{
//			AFX_MANAGE_STATE(AfxGetStaticModuleState();
//			// normal function body here
//		}
//
//		It is very important that this macro appear in each
//		function, prior to any calls into MFC.  This means that
//		it must appear as the first statement within the 
//		function, even before any object variable declarations
//		as their constructors may generate calls into the MFC
//		DLL.
//
//		Please see MFC Technical Notes 33 and 58 for additional
//		details.
//


// CPTFSLibApp

BEGIN_MESSAGE_MAP(CPTFSLibApp, CWinApp)
END_MESSAGE_MAP()


// CPTFSLibApp construction

CPTFSLibApp::CPTFSLibApp()
{
}


// The one and only CPTFSLibApp object

CPTFSLibApp theApp;


// CPTFSLibApp initialization

BOOL CPTFSLibApp::InitInstance()
{
	CWinApp::InitInstance();
	return TRUE;
}

void CPTFSLibApp::LoadLogLeve()
{
}

int CPTFSLibApp::ExitInstance()
{
	CLogUtil::StopLog();
	return CWinApp::ExitInstance();
}
////////////////////////////////////////////////////////////////

int PTFSAPI PTFSStart(PPTFS_OPTIONS PTFSOptions, PPTFS_OPERATIONS PTFSOperations, HANDLE hMountWaitEvent)
{
	theApp.LoadLogLeve();
	return theApp.m_PTFSMgr.DoInintialize(PTFSOptions, PTFSOperations, hMountWaitEvent);
}

BOOL PTFSAPI PTFSUnmount(WCHAR	DriveLetter, BOOL bForce)
{
	return theApp.m_PTFSMgr.PTFSUnmount(DriveLetter, bForce);
}

BOOL PTFSAPI PTFSSetDebugMode(ULONG ulMode)
{
	return TRUE;
}

BOOL PTFSAPI PTFSNotifyReLogIn(LPCWSTR lpcwszMountPoint)
{
	return TRUE;
}

void PTFSAPI PTFSMapKernelToUserCreateFileFlags(ACCESS_MASK DesiredAccess, ULONG FileAttributes, ULONG CreateOptions, ULONG CreateDisposition,
	ACCESS_MASK* outDesiredAccess, DWORD* outFileAttributesAndFlags, DWORD* outCreationDisposition)
{
	return theApp.m_PTFSMgr.MapKernelToUserCreateFileFlags(DesiredAccess, FileAttributes, CreateOptions, CreateDisposition, outDesiredAccess, outFileAttributesAndFlags, outCreationDisposition);
}

NTSTATUS PTFSAPI PTFSNtStatusFromWin32(DWORD dwWin32Error)
{
	return PTNtStatus::PTNtStatusFromWin32(dwWin32Error);
}

void PTFSAPI PTFSWaitMount(WCHAR cLetter, BOOL bRemovedMount)
{
	theApp.m_PTFSMgr.WaitMount(cLetter, bRemovedMount);
}

BOOL PTFSAPI PTFSIsReadyToMountVolume(WCHAR cLetter)
{
	return theApp.m_PTFSMgr.IsReadyToMount(cLetter);
}
