#include "StdAfx.h"
#include "PTFSDriver.h"
#include "util/util.h"
#include "PTFSIoctl.h"

CPTFSDriver::CPTFSDriver(void)
{
	ZeroMemory(m_szHomeDirectory, sizeof(m_szHomeDirectory));
	m_hGlobalDevice = INVALID_HANDLE_VALUE;
}

CPTFSDriver::~CPTFSDriver(void)
{
	CloseGlobalDeviceHandle();
}

BOOL CPTFSDriver::OnLoadDriver(BOOL bCreateService)
{
	BOOL bLoad = FALSE;
	CUtil::GetHomeDirectory(m_szHomeDirectory, MAX_PATH);
	TCHAR sDeviceFile[MAX_PATH];

	CString csModuleName = L"";
	csModuleName = _T(PTFS_DRIVER_NAME_64);
	_stprintf_s(sDeviceFile, MAX_PATH, _T("%s%s"), m_szHomeDirectory, csModuleName.GetString());
	
	bLoad = LoadDeviceDriver( _T(PTFS_NAME), sDeviceFile ,&m_hGlobalDevice, SERVICE_SYSTEM_START);

	if(!bLoad)
		m_hGlobalDevice = INVALID_HANDLE_VALUE;

	if(bCreateService)
		CloseGlobalDeviceHandle();

	return bLoad;
}

BOOL CPTFSDriver::OnUnLoadDriver()
{
	BOOL bUnLoad = TRUE;

	CloseGlobalDeviceHandle();

 	bUnLoad = UnloadDeviceDriver(_T(PTFS_NAME), SERVICE_SYSTEM_START);

	return bUnLoad;
}

BOOL CPTFSDriver::OpenGlobalDevice()
{
	return OnLoadDriver();
}

void CPTFSDriver::CloseGlobalDeviceHandle()
{
	if(m_hGlobalDevice)
	{
		CloseHandle( m_hGlobalDevice );
		m_hGlobalDevice = INVALID_HANDLE_VALUE;
	}
}

BOOL CPTFSDriver::SendToGlobalDevice( DWORD dwIoControlCode, PVOID pInputBuffer, ULONG ulInputLength,
		PVOID pOutputBuffer, ULONG ulOutputLength, PULONG pulReturnedLength)
{
	BOOL bRtn;

	if(INVALID_HANDLE_VALUE == m_hGlobalDevice)
	{
		if(FALSE == OpenGlobalDevice())
		{
			return FALSE;
		}
	}

	bRtn = DeviceIoControl(
				m_hGlobalDevice,       // hHandle to device
				dwIoControlCode,		// IO Control code
				pInputBuffer,				// Input Buffer to driver.
				ulInputLength,			// Length of input buffer in bytes.
				pOutputBuffer,          // Output Buffer from driver.
				ulOutputLength,			// Length of output buffer in bytes.
				pulReturnedLength,	    // Bytes placed in buffer.
				NULL                      // synchronous call
			);


	return bRtn;
}

BOOL CPTFSDriver::SendToDevice( LPCWSTR lpcwszDeviceName, DWORD dwIoControlCode, PVOID pInputBuffer, ULONG ulInputLength,
		PVOID pOutputBuffer, ULONG ulOutputLength, PULONG pulReturnedLength, HANDLE* phDevice)
{
	HANDLE	hDevice = INVALID_HANDLE_VALUE;
	BOOL		bRtn = FALSE;

	if (phDevice)
	{
		if (*phDevice != INVALID_HANDLE_VALUE && *phDevice != NULL)
			hDevice = *phDevice;
	}

	if (hDevice == INVALID_HANDLE_VALUE)
	{
		hDevice = CreateFile( 
			lpcwszDeviceName, 
			GENERIC_READ | GENERIC_WRITE,
			FILE_SHARE_READ | FILE_SHARE_WRITE,
			NULL,
			OPEN_EXISTING,
			0,
			NULL
		);
	}

	if(INVALID_HANDLE_VALUE == hDevice)
	{
		return FALSE;
	}

	bRtn = DeviceIoControl(
				hDevice,					// hHandle to device
				dwIoControlCode,		// IO Control code
				pInputBuffer,				// Input Buffer to driver.
				ulInputLength,			// Length of input buffer in bytes.
				pOutputBuffer,          // Output Buffer from driver.
				ulOutputLength,			// Length of output buffer in bytes.
				pulReturnedLength,	    // Bytes placed in buffer.
				NULL                      // synchronous call
			);

	if (!bRtn) {
	}

	if (NULL == phDevice)
		CloseHandle(hDevice);
	else
		*phDevice = hDevice;

	return bRtn;
}

BOOL CPTFSDriver::SendToDeviceInHandle(HANDLE hDevice, DWORD dwIoControlCode, PVOID pInputBuffer, ULONG ulInputLength,
	PVOID pOutputBuffer, ULONG ulOutputLength, PULONG pulReturnedLength)
{
	BOOL bRtn = FALSE;
	bRtn = DeviceIoControl(
		hDevice,
		dwIoControlCode,
		pInputBuffer,
		ulInputLength,
		pOutputBuffer,
		ulOutputLength,
		pulReturnedLength,
		NULL
	);

	if (!bRtn) {
	}

	return bRtn;
}

