#include "StdAfx.h"
#include "PTFSCtl.h"
#include "Util/Util.h"
#include "PTFSLib.h"

CPTFSCtl::CPTFSCtl(void)
{
}

CPTFSCtl::~CPTFSCtl(void)
{
}

BOOL CPTFSCtl::MountControl(PPTFS_CONTROL pControl)
{
	theApp.m_FSManager.PantaFSControl(pControl);

	if(pControl->Status == PTFS_CONTROL_SUCCESS)
		return TRUE;

	return FALSE;
}

BOOL CPTFSCtl::Unmount(WCHAR	wDriveLetter, BOOL bForce)
{
	WCHAR wszMountPoint[8] = L"Y:\\";

	wszMountPoint[0] = wDriveLetter;

	return RemoveMountPoint(wszMountPoint, bForce);
}

BOOL CPTFSCtl::RemoveMountPoint(LPCWSTR lpcwszMountPoint, BOOL bForce)
{
	PTFS_CONTROL control;
	BOOL bResult;

	ZeroMemory(&control, sizeof(PTFS_CONTROL));

	if(bForce)
		control.Option = PTFS_CONTROL_OPTION_FORCE_UNMOUNT;

	control.Type = PTFS_CONTROL_UNMOUNT;
	wcscpy_s(control.MountPoint, sizeof(control.MountPoint) / sizeof(WCHAR), lpcwszMountPoint);

	CLogUtil::DebugLogString(DLEVEL_INFO, _T("PTFSRemoveMountPoint %ws\n"), lpcwszMountPoint);

	bResult = MountControl(&control);
	if (bResult) {
		CLogUtil::DebugLogString(DLEVEL_INFO, _T("PTFSControl recieved DeviceName:%ws\n"), control.DeviceName);
		if(wcslen(control.DeviceName))
			theApp.SendReleaseIRP(control.DeviceName);
		else if(theApp.m_pCurrentInstance)
			theApp.SendReleaseIRP(theApp.m_pCurrentInstance->DeviceName);
	} else {
		CLogUtil::DebugLogString(DLEVEL_ERROR, _T("PTFSRemoveMountPoint failed\n"));
	}
	return bResult;
}

BOOL CPTFSCtl::PTFSMount(LPCWSTR lpcwszMountPoint, LPCWSTR lpcwszDeviceName)
{
	PTFS_CONTROL control;

	ZeroMemory(&control, sizeof(PTFS_CONTROL));
	control.Type = PTFS_CONTROL_MOUNT;

	wcscpy_s(control.MountPoint, sizeof(control.MountPoint) / sizeof(WCHAR), lpcwszMountPoint);
	wcscpy_s(control.DeviceName, sizeof(control.DeviceName) / sizeof(WCHAR), lpcwszDeviceName);

	return  PTFSMountControl(&control);
}

BOOL CPTFSCtl::PTFSNotifyReLogIn(LPCWSTR lpcwszMountPoint)
{
	PTFS_CONTROL control;

	ZeroMemory(&control, sizeof(PTFS_CONTROL));
	control.Type = PTFS_CONTROL_RELOGIN;
	wcscpy_s(control.MountPoint, sizeof(control.MountPoint) / sizeof(WCHAR), lpcwszMountPoint);

	return  PTFSMountControl(&control);
}