#pragma once

#include "PTFSLibApi.h"

typedef struct _MOUNT_ENTRY {
	LIST_ENTRY		ListEntry;
	PTFS_PIPE_CONTROL	MountControl;
} MOUNT_ENTRY, *PMOUNT_ENTRY;

class CFSManager
{
public:
	CFSManager(void);
	~CFSManager(void);
		
public:
	HANDLE	m_hDevice;

	CRITICAL_SECTION	m_CriticalSection;
	LIST_ENTRY		m_MountList;

public:
	void PantaFSControl(PPTFS_PIPE_CONTROL pControl);

private:
	BOOL CreateMountPoint(LPCWSTR lpcwszMountPoint, LPCWSTR lpcwszDeviceName);
	BOOL DeleteMountPoint(LPCWSTR lpcwszMountPoint);
	BOOL CreateDriveLetter(WCHAR wDriveLetter, LPCWSTR lpwszDeviceName);
	BOOL PantaFSControlMount(LPCWSTR lpcwszMountPoint, LPCWSTR lpcwszDeviceName);
	BOOL PantaFSControlUnmount(LPCWSTR lpcwszMountPoint);
	
	VOID RemoveMountEntry(PMOUNT_ENTRY pMountEntry);
	PMOUNT_ENTRY FindMountEntry(PPTFS_PIPE_CONTROL pPantaFSControl);

	BOOL PantaFSControlFind(PPTFS_PIPE_CONTROL pControl);
	VOID PantaFSControlList(PPTFS_PIPE_CONTROL pControl);


public:
	PMOUNT_ENTRY InsertMountEntry(PPTFS_PIPE_CONTROL pPantaFSControl);

	BOOL Initialize();
	void RemoveAllMountList();
	BOOL IsMountList();
	BOOL IsPantaFSMountDrive(LPCWSTR lpcwszMountDrive);
};
