#pragma once

#include "PTFileSystem.h"

extern const UNICODE_STRING g_DosDevicesPrefix;
extern const UNICODE_STRING g_VolumeGuidPrefix;
extern const UNICODE_STRING g_ObjectManagerPrefix;

void
PTFSFcbLock(
	IN PPTFSFCB	pFcb,
	IN BOOLEAN  bReadOnly
);

void
PTFSFcbUnlock(
	IN PPTFSFCB	pFcb
);

void 
PTFSVcbLock(
	IN PPTFSVCB pVcb,
	IN BOOLEAN  bReadOnly
);

void
PTFSVcbUnlock(
	IN PPTFSVCB pVcb
);

void
PTFSPagingIoLock(
	IN PPTFSFCB pFcb,
	IN BOOLEAN  bReadOnly
);

void
PTFSPagingIoUnlock(
	IN PPTFSFCB pFcb
);

PVOID
PTFSAllocateZero(
	IN SIZE_T size
);

VOID
PTFSFreeUnicodeString(
	IN PUNICODE_STRING pUnicodeString
);

VOID
PTFSCompleteIrpRequest(
	IN PIRP pIrp,
	IN NTSTATUS status,
	IN ULONG_PTR Info
);

VOID
PTFSCompleteDispatchRoutine(
	IN PIRP pIrp,
	IN NTSTATUS status
);

BOOLEAN
StartsWith(
	IN const UNICODE_STRING* Str,
	IN const UNICODE_STRING* Prefix
);

BOOLEAN
StartsWithDosDevicesPrefix(
	IN const UNICODE_STRING* Str
);

BOOLEAN	
StartsWithVolumeGuidPrefix(
	IN const UNICODE_STRING* Str
);

BOOLEAN
IsMountPointDriveLetter(
	IN const UNICODE_STRING* punstrMountPoint
);

UNICODE_STRING
PTFSWrapUnicodeString(
	IN WCHAR* Buffer,
	IN USHORT Length
);

ULONG
PointerAlignSize(
	IN ULONG ulSizeInBytes
);

LONG
SearchStringWChar(
	IN PWCHAR pwszString,
	IN ULONG Length,
	IN WCHAR wChar
);

LONG
SearchUnicodeStringWChar(
	IN PUNICODE_STRING pUnicodeString,
	IN WCHAR wChar
);

VOID
PTFSSetFlag(
	IN PULONG Flags,
	IN ULONG FlagBit
);

VOID PTFSClearFlag(
	IN PULONG Flags,
	IN ULONG FlagBit
);

PUNICODE_STRING
PTFSAllocateUnicodeString(
	IN PCWSTR String
);

PUNICODE_STRING
PTFSAllocDuplicateString(
	IN const PUNICODE_STRING Src
);

BOOLEAN
PTFSDuplicateUnicodeString(
	OUT PUNICODE_STRING Dest,
	IN const PUNICODE_STRING Src
);

VOID
PTFSFreeUnicodeString(
	PUNICODE_STRING pUnicodeString
);

ULONG
SearchWcharinUnicodeStringWithUlong(
	IN PUNICODE_STRING inputPUnicodeString,
	IN WCHAR targetWchar,
	IN ULONG offsetPosition,
	IN int isIgnoreTargetWchar
);

PUNICODE_STRING
ChangePrefix(
	IN const UNICODE_STRING* Str,
	IN const UNICODE_STRING* Prefix,
	IN BOOLEAN HasPrefix,
	IN const UNICODE_STRING* NewPrefix
);

VOID
RunAsSystem(
	IN PKSTART_ROUTINE StartRoutine,
	PVOID pStartContext
);

NTSTATUS 
NotifyReportChange0(
	IN PPTFSFCB pFcb,
	IN PUNICODE_STRING punstrFileName,
	IN ULONG FilterMatch,
	IN ULONG Action
);

NTSTATUS
NotifyReportChange(
	IN PPTFSFCB pFcb,
	IN ULONG FilterMatch,
	IN ULONG Action
);

NTSTATUS
PTFSCheckOplock(
	IN PPTFSFCB pFcb,
	IN PIRP pIrp,
	IN OPTIONAL PVOID Context,
	IN OPTIONAL POPLOCK_WAIT_COMPLETE_ROUTINE CompletionRoutine,
	IN OPTIONAL POPLOCK_FS_PREPOST_IRP PostIrpRoutine
);

BOOLEAN
PTFSCheckCCB(
	IN PPTFSDCB pDcb,
	IN OPTIONAL PPTFSCCB pCcb
);

NTSTATUS
AllocateMdl(
	IN PIRP pIrp,
	IN ULONG Length
);

VOID 
FreeMdl(
	IN PIRP pIrp
);

PVOID
PTFSMapUserBuffer(
	IN OUT PIRP pIrp
);
