#include "Pnp.h"
#include "init.h"
#include "util.h"
#include "notification.h"
#include "event.h"


#ifdef ALLOC_PRAGMA
#pragma alloc_text (PAGE, PTFSDispatchPnp)
#endif


NTSTATUS
PTFSDispatchPnp(
	IN PDEVICE_OBJECT pDeviceObject,
	IN PIRP pIrp
)
{
    PIO_STACK_LOCATION pIrpSp = NULL;
    NTSTATUS status = STATUS_SUCCESS;

    UNREFERENCED_PARAMETER(pDeviceObject);

    __try 
    {
        KdPrint(("[PTFS]::PTFSDispatchPnp Start\n"));

        pIrpSp = IoGetCurrentIrpStackLocation(pIrp);
        pIrp->IoStatus.Information = 0;

        switch (pIrpSp->MinorFunction) {
        case IRP_MN_QUERY_REMOVE_DEVICE:
            KdPrint(("[PTFS]::PTFSDispatchPnp IRP_MN_QUERY_REMOVE_DEVICE\n"));
            break;
        case IRP_MN_SURPRISE_REMOVAL:
            KdPrint(("[PTFS]::PTFSDispatchPnp IRP_MN_SURPRISE_REMOVAL\n"));
            break;
        case IRP_MN_REMOVE_DEVICE:
            KdPrint(("[PTFS]::PTFSDispatchPnp IRP_MN_REMOVE_DEVICE\n"));
            break;
        case IRP_MN_CANCEL_REMOVE_DEVICE:
            KdPrint(("[PTFS]::PTFSDispatchPnp IRP_MN_CANCEL_REMOVE_DEVICE\n"));
            break;
        case IRP_MN_QUERY_DEVICE_RELATIONS:
            KdPrint(("[PTFS]::PTFSDispatchPnp IRP_MN_QUERY_DEVICE_RELATIONS\n"));
            status = STATUS_NOT_IMPLEMENTED;
            break;
        default:
            KdPrint(("[PTFS]::PTFSDispatchPnp other minnor function[%d]\n", pIrpSp->MinorFunction));
            break;
        }
    }
    __finally 
    {
        PTFSCompleteIrpRequest(pIrp, status, pIrp->IoStatus.Information);
        KdPrint(("[PTFS]::PTFSDispatchPnp End\n"));
    }

    return status;
}
