#pragma once

#include "PTFileSystem.h"

VOID
SetCommonEventContext(
	IN PPTFSDCB pDcb,
	IN PEVENT_CONTEXT pEventContext,
	IN PIRP Irp, IN OPTIONAL PPTFSCCB pCcb
);

PEVENT_CONTEXT
AllocateEventContextRaw(
	IN ULONG EventContextLength
);

PEVENT_CONTEXT
AllocateEventContext(
	IN PPTFSDCB pDcb,
	IN PIRP Irp,
	IN ULONG EventContextLength,
	IN OPTIONAL PPTFSCCB pCcb
);

VOID
FreeEventContext(
	IN PEVENT_CONTEXT pEventContext
);

VOID 
EventNotification(
	IN PIRP_LIST NotifyEvent,
	IN PEVENT_CONTEXT pEventContext
);

VOID
MoveIrpList(
	IN PIRP_LIST Source,
	OUT LIST_ENTRY* Dest
);

VOID 
ReleasePendingIrp(
	IN PIRP_LIST PendingIrp
);

VOID
ReleaseNotifyEvent(
	IN PIRP_LIST NotifyEvent
);

VOID
RetryIrps(
	IN PIRP_LIST PendingRetryIrp
);

VOID
NotificationLoop(
	IN PIRP_LIST PendingIrp,
	IN PIRP_LIST NotifyEvent
);

VOID
NotificationThread(
	IN PVOID pDcb
);
	
NTSTATUS
StartEventNotificationThread(
	IN PPTFSDCB pDcb
);

VOID
StopEventNotificationThread(
	IN PPTFSDCB pDcb
);

VOID
CleanupAllChangeNotificationWaiters(
	IN PPTFSVCB pVcb
);

VOID
StopFcbGarbageCollectorThread(
	IN PPTFSVCB pVcb
);

NTSTATUS
PTFSEventRelease(
	IN PDEVICE_OBJECT pDeviceObject,
	IN PIRP pIrp
);

ULONG
GetCurrentSessionId(
	IN PIRP pIrp
);

NTSTATUS
PTFSGlobalEventRelease(
	IN PDEVICE_OBJECT pDeviceObject,
	IN PIRP pIrp
);
