#pragma once

#include "PTFileSystem.h"
#include <mountmgr.h>

NTSTATUS
SendIoContlToMountManager(
    IN ULONG IoControlCode,
    IN PVOID InputBuffer,
    IN ULONG Length,
    OUT PVOID OutputBuffer,
    IN ULONG OutputLength
);

NTSTATUS 
SendVolumeMountPoint(
    IN PPTFSDCB pDcb, 
    IN BOOLEAN Create
);

NTSTATUS 
QueryAutoMount(
    OUT BOOLEAN *State
);

NTSTATUS 
SendAutoMount(
    IN BOOLEAN State
);

NTSTATUS 
SendVolumeArrivalNotification(
    IN PUNICODE_STRING DeviceName
);

VOID 
NotifyDirectoryMountPointCreated(
    IN PPTFSDCB pDcb
);

VOID 
NotifyDirectoryMountPointDeleted(
    IN PPTFSDCB pDcb
);

NTSTATUS
SendVolumeCreatePoint(
    IN PDRIVER_OBJECT pDriverObject,
    IN PUNICODE_STRING DeviceName,
    IN PUNICODE_STRING MountPoint
);

NTSTATUS
SendVolumeDeletePoints(
    IN PUNICODE_STRING MountPoint,
    IN PUNICODE_STRING DeviceName
);
