#pragma once
#include "PTFileSystem.h"
#include <ntifs.h>

ULONG 
GetProvidedInputSize(
    IN PIRP pIrp
);

PVOID GetInputBuffer(
    IN PIRP pIrp
);

#define GET_IRP_GENERIC_BUFFER_EX(Irp, Buffer, SizeCompare, Exit, Status, InformationSize)                           \
  {                                                                          \
    ULONG irpBufferLen = GetProvidedInputSize(Irp);                          \
    (Buffer) = GetInputBuffer(Irp);                                          \
    ASSERT((Buffer) != NULL);                                                \
    if (!(Buffer)) {                                                         \
      Exit((Irp), (Status), (InformationSize));                              \
    } else if (SizeCompare((Buffer), irpBufferLen)) {                        \
      (Buffer) = NULL;                                                       \
      Exit((Irp), (Status), (InformationSize));                              \
    }                                                                        \
  }

#define GET_IRP_GENERIC_BUFFER(Irp, Buffer, CompareSize) \
  GET_IRP_GENERIC_BUFFER_EX(Irp, Buffer, CompareSize, PTFS_EXIT_NONE, 0, 0)

#define GENERIC_SIZE_COMPARE(Buffer, BufferLen) \
  (sizeof(*(Buffer)) > (BufferLen))

#define MOUNTDEV_NAME_SIZE_COMPARE(MountDevName, BufferLen) \
  (GENERIC_SIZE_COMPARE(MountDevName, BufferLen) ||         \
   (ULONG)(FIELD_OFFSET(MOUNTDEV_NAME, Name[0]) +           \
           (MountDevName)->NameLength) > (BufferLen))

#define NOTIFY_PATH_INTERMEDIATE_SIZE_COMPARE(NotifyPath, \
                                                    BufferLen)       \
  (GENERIC_SIZE_COMPARE(NotifyPath, BufferLen) ||               \
   (ULONG)(FIELD_OFFSET(NOTIFY_PATH_INTERMEDIATE, Buffer[0]) + \
           (NotifyPath)->Length) > (BufferLen))

#define UNICODE_STRING_INTERMEDIATE_SIZE_COMPARE(UnicodeStringIM, \
                                                       BufferLen)          \
  (GENERIC_SIZE_COMPARE(UnicodeStringIM, BufferLen) ||                  \
   (ULONG)(FIELD_OFFSET(UNICODE_STRING_INTERMEDIATE, Buffer[0]) +    \
           (UnicodeStringIM)->Length) > (BufferLen) ||                  \
   (ULONG)(FIELD_OFFSET(UNICODE_STRING_INTERMEDIATE, Buffer[0]) +    \
           (UnicodeStringIM)->MaximumLength) > (BufferLen) ||           \
   (UnicodeStringIM)->Length > (UnicodeStringIM)->MaximumLength)

#define PTFS_EXIT_NONE(Irp, Status, InformationSize)

#define PTFS_EXIT_LEAVE(Irp, Status, InformationSize) \
  (Irp)->IoStatus.Information = InformationSize;       \
  status = Status;                                     \
  __leave;

#define PTFS_EXIT_BREAK(Irp, Status, InformationSize) \
  (Irp)->IoStatus.Information = InformationSize;       \
  status = Status;                                     \
  break;

#define PTFS_EXIT_RETURN(Irp, Status, InformationSize) return Status;

#define GET_IRP_BUFFER(Irp, Buffer) \
  GET_IRP_GENERIC_BUFFER(Irp, Buffer, GENERIC_SIZE_COMPARE)

#define GET_IRP_BUFFER_OR_LEAVE(Irp, Buffer)                   \
  GET_IRP_GENERIC_BUFFER_EX(Irp, Buffer, GENERIC_SIZE_COMPARE, \
                            PTFS_EXIT_LEAVE, STATUS_BUFFER_TOO_SMALL, 0)

#define GET_IRP_BUFFER_OR_BREAK(Irp, Buffer)                   \
  GET_IRP_GENERIC_BUFFER_EX(Irp, Buffer, GENERIC_SIZE_COMPARE, \
                            PTFS_EXIT_BREAK, STATUS_BUFFER_TOO_SMALL, 0)

#define GET_IRP_BUFFER_OR_RETURN(Irp, Buffer)                  \
  GET_IRP_GENERIC_BUFFER_EX(Irp, Buffer, GENERIC_SIZE_COMPARE, \
                            PTFS_EXIT_RETURN, STATUS_BUFFER_TOO_SMALL, 0)

#define GET_IRP_NOTIFY_PATH_INTERMEDIATE_OR_RETURN(Irp, Buffer)          \
  GET_IRP_GENERIC_BUFFER_EX(Irp, Buffer,                                 \
                            NOTIFY_PATH_INTERMEDIATE_SIZE_COMPARE, \
                            PTFS_EXIT_RETURN, STATUS_BUFFER_TOO_SMALL, 0)

#define GET_IRP_UNICODE_STRING_INTERMEDIATE_OR_RETURN(Irp, Buffer)          \
  GET_IRP_GENERIC_BUFFER_EX(Irp, Buffer,                                    \
                            UNICODE_STRING_INTERMEDIATE_SIZE_COMPARE, \
                            PTFS_EXIT_RETURN, STATUS_BUFFER_TOO_SMALL, 0)

#define GET_IRP_MOUNTDEV_NAME_OR_BREAK(Irp, Buffer)                  \
  GET_IRP_GENERIC_BUFFER_EX(Irp, Buffer, MOUNTDEV_NAME_SIZE_COMPARE, \
                            PTFS_EXIT_BREAK, STATUS_BUFFER_TOO_SMALL, 0)


PVOID 
PrepareOutputWithSize(
    IN OUT PIRP pIrp, 
    IN ULONG Size,
    IN BOOLEAN SetInformationOnFailure
);

BOOLEAN PrepareOutputHelper(
    IN OUT PIRP pIrp,
    OUT VOID * *ppBuffer,
    IN ULONG Size,
    IN BOOLEAN SetInformationOnFailure
);

#define PREPARE_OUTPUT(Irp, Buffer, SetInformationOnFailure)                   \
   PrepareOutputHelper((Irp), &(Buffer), sizeof(*Buffer),                      \
                       (SetInformationOnFailure))


BOOLEAN 
ExtendOutputBySize(
    IN OUT PIRP pIrp, 
    IN ULONG AdditionalSize,
    IN BOOLEAN UpdateInformationOnFailure
);

BOOLEAN 
AppendVarSizeOutputString(
    IN OUT PIRP pIrp, 
    IN OUT PVOID Dest,
    IN const UNICODE_STRING* Str,
    IN BOOLEAN UpdateInformationOnFailure,
    IN BOOLEAN FillSpaceWithPartialString
);

