#pragma once
#include "PTFileSystem.h"

BOOLEAN
IsMounted(
	IN PDEVICE_OBJECT pDeviceObject
);

BOOLEAN
IsUnmountPendingVcb(
	IN PPTFSVCB pVcb
);

BOOLEAN
IsUnmountPending(
	IN PDEVICE_OBJECT pDeviceObject
);

NTSTATUS
PTFSGetMountPointList(
	IN PDEVICE_OBJECT pDeviceObject,
	IN PIRP pIrp,
	IN PPTFS_GLOBAL pPTFSGlobal
);

NTSTATUS
PTFSCreateGlobalDiskDevice(
	IN PDRIVER_OBJECT pDriverObject,
	OUT PPTFS_GLOBAL *ppPTFSGlobal
);

VOID
PTFSCreateMountPoint(
	IN PPTFSDCB pDcb
);

PDEVICE_ENTRY
FindDeviceForDeleteBySessionId(
	PPTFS_GLOBAL pPTFSGlobal,
	ULONG sessionId
);


BOOLEAN
DeleteMountPointSymbolicLink(
	IN PUNICODE_STRING MountPoint
);

PMOUNT_ENTRY
FindMountEntry(
	IN PPTFS_GLOBAL pPTFSGlobal,
	IN PPTFS_CONTROL pPTFSControl,
	IN BOOLEAN lockGlobal
);

PMOUNT_ENTRY
FindMountEntryByName(
	IN PPTFS_GLOBAL pPTFSGlobal,
	IN PUNICODE_STRING DiskDeviceName,
	IN PUNICODE_STRING UNCName,
	IN BOOLEAN LockGlobal
);

VOID
RemoveMountEntry(
	IN PPTFS_GLOBAL pPTFSGlobal,
	IN PMOUNT_ENTRY pMountEntry
);

VOID
PTFSInitIrpList(
	IN PIRP_LIST pIrpList
);

NTSTATUS
PTFSCreateDiskDevice(
	IN PDRIVER_OBJECT pDriverObject,
	IN ULONG MountId,
	IN PWCHAR MountPoint,
	IN PWCHAR UNCName,
	IN ULONG SessionId,
	IN PWCHAR BaseGuid,
	IN PPTFS_GLOBAL pPTFSGlobal,
	IN DEVICE_TYPE DeviceType,
	IN ULONG DeviceCharacteristics,
	IN BOOLEAN MountGlobally,
	IN BOOLEAN UseMountManager,
	OUT PPTFSDCB* ppDcb
);

KSTART_ROUTINE PTFSDeleteMountPointSysProc;

VOID 
DeleteMountPoint(
	IN PPTFSDCB pDcb
);

VOID
DeleteDeviceObject(
	IN PPTFSDCB pDcb
);

BOOLEAN
IsDeletePending(
	IN PDEVICE_OBJECT pDeviceObject
);

BOOLEAN
PTFSNoOpAcquire(
	IN PVOID pFcb,
	IN BOOLEAN Wait
);

VOID
PTFSNoOpRelease(
	IN PVOID pFcb
);

KSTART_ROUTINE RegisterUncProvider;
KSTART_ROUTINE DeregisterUncProvider;
KSTART_ROUTINE CreateMountPointSysProc;

extern UNICODE_STRING g_sddl;
