#include "Flush.h"
#include "init.h"
#include "util.h"
#include "notification.h"
#include "event.h"

#ifdef ALLOC_PRAGMA
#pragma alloc_text (PAGE, PTFSDispatchFlush)
#endif


NTSTATUS
PTFSDispatchFlush(
	IN PDEVICE_OBJECT pDeviceObject,
	IN PIRP pIrp
)
{
    PIO_STACK_LOCATION pIrpSp = NULL;
    PFILE_OBJECT pFileObject = NULL;
    NTSTATUS status = STATUS_INVALID_PARAMETER;
    PPTFSFCB pFcb = NULL;
    PPTFSCCB pCcb = NULL;
    PPTFSVCB pVcb = NULL;
    PEVENT_CONTEXT pEventContext = NULL;
    ULONG eventLength = 0;

    __try 
    {
        KdPrint(("[PTFS]::PTFSDispatchFlush Start\n"));

        pIrpSp = IoGetCurrentIrpStackLocation(pIrp);
        pFileObject = pIrpSp->FileObject;

        if (pFileObject == NULL) 
        {
            KdPrint(("[PTFS]::PTFSDispatchFlush FileObject is Null\n"));
            status = STATUS_SUCCESS;
            __leave;
        }

        pVcb = pDeviceObject->DeviceExtension;
        if (GETIDENTIFIERTYPE(pVcb) != VCB || !PTFSCheckCCB(pVcb->pDcb, pFileObject->FsContext2)) 
        {
            KdPrint(("[PTFS]::PTFSDispatchFlush invalid identifier Type\n"));
            status = STATUS_SUCCESS;
            __leave;
        }


        pCcb = pFileObject->FsContext2;
        ASSERT(pCcb != NULL);

        pFcb = pCcb->pFcb;
        ASSERT(pFcb != NULL);

        PTFSFcbLock(pFcb, TRUE);

        eventLength = sizeof(EVENT_CONTEXT) + pFcb->unstrFileName.Length;
        pEventContext = AllocateEventContext(pVcb->pDcb, pIrp, eventLength, pCcb);
        if (pEventContext == NULL) 
        {
            KdPrint(("[PTFS]::PTFSDispatchFlush failed to AllocateEventContext\n"));
            status = STATUS_INSUFFICIENT_RESOURCES;
            __leave;
        }

        pEventContext->Context = pCcb->UserContext;
        KdPrint(("[PTFS]::PTFSDispatchFlush get Context[%X]\n", (ULONG)pCcb->UserContext));

        pEventContext->Operation.Flush.FileNameLength = pFcb->unstrFileName.Length;
        RtlCopyMemory(pEventContext->Operation.Flush.FileName, pFcb->unstrFileName.Buffer,pFcb->unstrFileName.Length);

        CcUninitializeCacheMap(pFileObject, NULL, NULL);

        status = PTFSCheckOplock(pFcb, pIrp, pEventContext, PTFSOplockComplete, PTFSPrePostIrp);

        if (status != STATUS_SUCCESS) 
        {
            if (status == STATUS_PENDING) 
                KdPrint(("[PTFS]::PTFSDispatchFlush FsRtlCheckOplock returned STATUS_PENDING\n"));
            else 
                FreeEventContext(pEventContext);

            __leave;
        }

        status = RegisterPendingIrp(pDeviceObject, pIrp, pEventContext, 0);

    }
    __finally 
    {
        if (pFcb)
            PTFSFcbUnlock(pFcb);

        PTFSCompleteIrpRequest(pIrp, status, 0);
        KdPrint(("[PTFS]::PTFSDispatchFlush end\n"));
    }

    return status;
}

VOID
PTFSCompleteFlush(
	IN PIRP_ENTRY pIrpEntry,
	IN PEVENT_INFORMATION pEventInfo
)
{
    PIRP pIrp = NULL;
    PIO_STACK_LOCATION pIrpSp = NULL;
    PPTFSCCB pCcb = NULL;
    PFILE_OBJECT pFileObject = NULL;

    pIrp = pIrpEntry->pIrp;
    pIrpSp = pIrpEntry->pIrpSp;

    KdPrint(("[PTFS]::PTFSCompleteFlush start\n"));

    pFileObject = pIrpSp->FileObject;
    pCcb = pFileObject->FsContext2;
    ASSERT(pCcb != NULL);

    pCcb->UserContext = pEventInfo->Context;

    KdPrint(("[PTFS]::PTFSCompleteFlush set Context[%X]\n", (ULONG)pCcb->UserContext));
    PTFSCompleteIrpRequest(pIrp, pEventInfo->Status, 0);
    KdPrint(("[PTFS]::PTFSCompleteFlush end\n"));
}
