#pragma once

#include "PTFileSystem.h"

extern const UNICODE_STRING g_KeepAliveFileName;
extern const UNICODE_STRING g_NotificationFileName;

PPTFSFCB 
AllocateFCB(
    IN PPTFSVCB pVcb, 
    IN PWCHAR pwszFileName,
    IN ULONG ulFileNameLength
);

NTSTATUS
FreeFCB(
    IN PPTFSVCB pVcb, 
    IN PPTFSFCB pFcb
);

PPTFSFCB 
GetFCB(
    IN PPTFSVCB pVcb, 
    IN PWCHAR pwszFileName,
    IN ULONG ulFileNameLength, 
    BOOLEAN bCaseSensitive
);

VOID 
StartFcbGarbageCollector(
    IN PPTFSVCB pVcb
);

BOOLEAN 
ScheduleFcbForGarbageCollection(
    IN PPTFSVCB pVcb,
    IN PPTFSFCB pFcb
);

VOID 
CancelFcbGarbageCollection(
    IN PPTFSFCB pFcb
);

BOOLEAN 
ForceFcbGarbageCollection(
    IN PPTFSVCB pVcb
);

VOID 
DeleteFcb(
    IN PPTFSVCB pVcb, 
    IN PPTFSFCB pFcb
);
