
#include "except.h"
#include "init.h"
#include "util.h"

NTSTATUS
PTFSExceptionFilter(
	IN PIRP pIrp,
	IN PEXCEPTION_POINTERS pExceptionPointer
)
{
    NTSTATUS Status = EXCEPTION_CONTINUE_SEARCH;
    NTSTATUS ExceptionCode;
    PEXCEPTION_RECORD pExceptRecord = NULL;

    UNREFERENCED_PARAMETER(pIrp);

    pExceptRecord = pExceptionPointer->ExceptionRecord;
    ExceptionCode = pExceptRecord->ExceptionCode;

    if (FsRtlIsNtstatusExpected(ExceptionCode)) 
    {
        KdPrint(("[PTFS]::PTFSExceptionFilter Catching exception Code[0x%x]\n", ExceptionCode));
        Status = EXCEPTION_EXECUTE_HANDLER;
    }
    else 
    {
        KdPrint(("[PTFS]::PTFSExceptionFilter Passing exception Code[0x%x]\n", ExceptionCode));
        Status = EXCEPTION_CONTINUE_SEARCH;
    }
    return Status;
}

NTSTATUS
PTFSExceptionHandler(
	IN PDEVICE_OBJECT pDeviceObject,
	IN PIRP pIrp,
	IN NTSTATUS ExceptionCode
)
{
    NTSTATUS Status = ExceptionCode;

    if(pIrp) 
    {
        PIO_STACK_LOCATION pIrpSp = NULL;
        PPTFSVCB pVcb = NULL;
        pIrpSp = IoGetCurrentIrpStackLocation(pIrp);

        pVcb = (PPTFSVCB)pDeviceObject->DeviceExtension;

        if (NULL == pVcb)
            Status = STATUS_INVALID_PARAMETER;
        else if (pVcb->Identifier.FsdIdType != VCB)
            Status = STATUS_INVALID_PARAMETER;
        else if (IsUnmountPendingVcb(pVcb))
            Status = STATUS_NO_SUCH_DEVICE;

        if (Status == STATUS_PENDING)
            return Status;
 
        PTFSCompleteIrpRequest(pIrp, Status, 0);
    }
    else
        Status = STATUS_INVALID_PARAMETER;

    return Status;
}
