#pragma once

#include "PTFileSystem.h"

VOID
PTFSCreateIrpCancelRoutine(
    IN OUT PDEVICE_OBJECT pDeviceObject,
    IN OUT PIRP pIrp
);

VOID 
PTFSIrpCancelRoutine(
    IN OUT PDEVICE_OBJECT pDeviceObject,
    IN OUT PIRP Irp
);

VOID
PTFSOplockComplete(
    IN PVOID pContext,
    IN PIRP pIrp
);

VOID
PTFSPrePostIrp(
    IN PVOID pContext,
    IN PIRP pIrp
);

NTSTATUS
RegisterPendingIrpMain(
    IN PDEVICE_OBJECT pDeviceObject,
    IN PIRP pIrp,
    IN ULONG SerialNumber,
    IN PIRP_LIST pIrpList,
    IN ULONG Flags,
    IN ULONG CheckMount,
    IN NTSTATUS CurrentStatus
);

NTSTATUS
RegisterPendingIrp(
    IN PDEVICE_OBJECT pDeviceObject,
    IN PIRP pIrp,
    IN PEVENT_CONTEXT pEventContext,
    IN ULONG Flags
);

VOID
RegisterPendingRetryIrp(
    IN PDEVICE_OBJECT pDeviceObject,
    IN PIRP pIrp
);

VOID
RegisterAsyncCreateFailure(
    IN PDEVICE_OBJECT pDeviceObject,
    IN PIRP pIrp,
    IN NTSTATUS Status
);

NTSTATUS
RegisterPendingIrpForEvent(
    IN PDEVICE_OBJECT pDeviceObject,
    IN OUT PIRP pIrp
);

NTSTATUS
RegisterPendingIrpForService(
    IN PDEVICE_OBJECT pDeviceObject,
    IN OUT PIRP pIrp
);

NTSTATUS
PTFSCompleteIrp(
    IN PDEVICE_OBJECT pDeviceObject,
    IN OUT PIRP pIrp
);

VOID
RemoveSessionDevices(
    IN PPTFS_GLOBAL pPTFSGlobal,
    IN ULONG sessionId
);

NTSTATUS
PTFSEventStart(
    IN PDEVICE_OBJECT pDeviceObject,
    IN OUT PIRP pIrp
);

NTSTATUS
PTFSEventWrite(
    IN PDEVICE_OBJECT pDeviceObject,
    IN OUT PIRP pIrp
);
