#include "dispatch.h"
#include "util.h"
#include "init.h"
#include "create.h"
#include "close.h"
#include "Read.h"
#include "Write.h"
#include "Flush.h"
#include "FileInfo.h"
#include "volume.h"
#include "directory.h"
#include "Fscontrol.h"
#include "device.h"
#include "lock.h"
#include "cleanup.h"
#include "shutdown.h"
#include "security.h"
#include "pnp.h"
#include "except.h"


VOID
PTFSCancelCreateIrp(
	IN PDEVICE_OBJECT pDeviceObject,
	IN PIRP_ENTRY pIrpEntry,
	IN NTSTATUS Status
)
{
	BOOLEAN AtIrqlPassiveLevel = FALSE;
	BOOLEAN IsTopLevelIrp = FALSE;
	PIRP pIrp = pIrpEntry->pIrp;
	PEVENT_INFORMATION pEventInfo = NULL;

	__try 
    {
		__try 
        {
			AtIrqlPassiveLevel = (KeGetCurrentIrql() == PASSIVE_LEVEL);

			if (AtIrqlPassiveLevel)
				FsRtlEnterFileSystem();

			if (!IoGetTopLevelIrp())
            {
				IsTopLevelIrp = TRUE;
				IoSetTopLevelIrp(pIrp);
			}

			pEventInfo = PTFSAllocateZero(sizeof(EVENT_INFORMATION));            
            if (pEventInfo)
            {
                pEventInfo->Status = Status;
                PTFSCompleteCreate(pIrpEntry, pEventInfo);
            }
		}
		__except (PTFSExceptionFilter(pIrp, GetExceptionInformation())) 
        {
			PTFSExceptionHandler(pDeviceObject, pIrp, GetExceptionCode());
		}
	}
	__finally 
    {
		if (pEventInfo != NULL)
            ExFreePool(pEventInfo);

		if (IsTopLevelIrp)
			IoSetTopLevelIrp(NULL);

		if (AtIrqlPassiveLevel)
			FsRtlExitFileSystem();
	}
}

NTSTATUS
DispatchRoutine(
	IN PDEVICE_OBJECT pDeviceObject,
	IN PIRP pIrp
)
{
    PIO_STACK_LOCATION pIrpSp = IoGetCurrentIrpStackLocation(pIrp);

    if (pIrpSp->MajorFunction != IRP_MJ_FILE_SYSTEM_CONTROL &&
        pIrpSp->MajorFunction != IRP_MJ_SHUTDOWN &&
        pIrpSp->MajorFunction != IRP_MJ_CLEANUP &&
        pIrpSp->MajorFunction != IRP_MJ_CLOSE &&
        pIrpSp->MajorFunction != IRP_MJ_PNP) 
    {
        if (IsUnmountPending(pDeviceObject)) 
        {
            KdPrint(("[PTFS]::DispatchRoutine Volume is not mounted so return STATUS_NO_SUCH_DEVICE Major Function[%d], Minor Function[%d]\n", pIrpSp->MajorFunction, pIrpSp->MinorFunction));
            PTFSCompleteIrpRequest(pIrp, STATUS_NO_SUCH_DEVICE, 0);
            return STATUS_NO_SUCH_DEVICE;
        }
    }

    if (IS_DEVICE_READ_ONLY(pDeviceObject)) {
        if ((pIrpSp->MajorFunction == IRP_MJ_WRITE) ||
            (pIrpSp->MajorFunction == IRP_MJ_SET_INFORMATION) ||
            (pIrpSp->MajorFunction == IRP_MJ_SET_EA) ||
            (pIrpSp->MajorFunction == IRP_MJ_FLUSH_BUFFERS) ||
            (pIrpSp->MajorFunction == IRP_MJ_SET_SECURITY) ||
            (pIrpSp->MajorFunction == IRP_MJ_SET_VOLUME_INFORMATION) ||
            (pIrpSp->MajorFunction == IRP_MJ_FILE_SYSTEM_CONTROL &&
                pIrpSp->MinorFunction == IRP_MN_USER_FS_REQUEST &&
                pIrpSp->Parameters.FileSystemControl.FsControlCode == FSCTL_MARK_VOLUME_DIRTY)) 
        {
            KdPrint(("[PTFS]::DispatchRoutine Media is write protected\n"));
            PTFSCompleteIrpRequest(pIrp, STATUS_MEDIA_WRITE_PROTECTED, 0);
            return STATUS_MEDIA_WRITE_PROTECTED;
        }
    }

    switch (pIrpSp->MajorFunction)
    {
    case IRP_MJ_CREATE:
        return PTFSDispatchCreate(pDeviceObject, pIrp);

    case IRP_MJ_CLOSE:
        return PTFSDispatchClose(pDeviceObject, pIrp);

    case IRP_MJ_READ:
        return PTFSDispatchRead(pDeviceObject, pIrp);

    case IRP_MJ_WRITE:
        return PTFSDispatchWrite(pDeviceObject, pIrp);

    case IRP_MJ_FLUSH_BUFFERS:
        return PTFSDispatchFlush(pDeviceObject, pIrp);

    case IRP_MJ_QUERY_INFORMATION:
        return PTFSDispatchQueryInformation(pDeviceObject, pIrp);

    case IRP_MJ_SET_INFORMATION:
        return PTFSDispatchSetInformation(pDeviceObject, pIrp);

    case IRP_MJ_QUERY_VOLUME_INFORMATION:
        return PTFSDispatchQueryVolumeInformation(pDeviceObject, pIrp);

    case IRP_MJ_SET_VOLUME_INFORMATION:
        return PTFSDispatchSetVolumeInformation(pDeviceObject, pIrp);

    case IRP_MJ_DIRECTORY_CONTROL:
        return PTFSDispatchDirectoryControl(pDeviceObject, pIrp);

    case IRP_MJ_FILE_SYSTEM_CONTROL:
        return PTFSDispatchFileSystemControl(pDeviceObject, pIrp);

    case IRP_MJ_DEVICE_CONTROL:
        return PTFSDispatchDeviceControl(pDeviceObject, pIrp);

    case IRP_MJ_LOCK_CONTROL:
        return PTFSDispatchLock(pDeviceObject, pIrp);

    case IRP_MJ_CLEANUP:
        return PTFSDispatchCleanup(pDeviceObject, pIrp);

    case IRP_MJ_SHUTDOWN:
        return PTFSDispatchShutdown(pDeviceObject, pIrp);

    case IRP_MJ_QUERY_SECURITY:
        return PTFSDispatchQuerySecurity(pDeviceObject, pIrp);

    case IRP_MJ_SET_SECURITY:
        return PTFSDispatchSetSecurity(pDeviceObject, pIrp);

    case IRP_MJ_PNP:
        return PTFSDispatchPnp(pDeviceObject, pIrp);

    default:
        KdPrint(("[PTFS]::DispatchRoutine Unexpected major function 0x%xh\n", pIrpSp->MajorFunction));
        PTFSCompleteIrpRequest(pIrp, STATUS_DRIVER_INTERNAL_ERROR, 0);
        return STATUS_DRIVER_INTERNAL_ERROR;
    }
}