#include "close.h"
#include "util.h"
#include "init.h"
#include "event.h"
#include "notification.h"
#include "create.h"
#include "fcb.h"

#ifdef ALLOC_PRAGMA
#pragma alloc_text (PAGE, PTFSDispatchClose)
#endif


NTSTATUS
PTFSDispatchClose(
	IN PDEVICE_OBJECT pDeviceObject,
	IN PIRP pIrp
)
{
    PPTFSVCB pVcb = NULL;
    PIO_STACK_LOCATION pIrpSp = NULL;
    NTSTATUS status = STATUS_INVALID_PARAMETER;
    PFILE_OBJECT pFileObject = NULL;
    PPTFSCCB pCcb = NULL;
    PEVENT_CONTEXT pEventContext = NULL;
    ULONG eventLength = 0;
    PPTFSFCB pFcb = NULL;

    __try 
    {
        KdPrint(("[PTFS]::PTFSDispatchClose Start\n"));

        pIrpSp = IoGetCurrentIrpStackLocation(pIrp);
        pFileObject = pIrpSp->FileObject;

        if (pFileObject == NULL) 
        {
            KdPrint(("[PTFS]::PTFSDispatchClose FileObject is NULL\n"));
            status = STATUS_SUCCESS;
            __leave;
        }

        KdPrint(("[PTFS]::PTFSDispatchClose ProcessId[%lu]\n", IoGetRequestorProcessId(pIrp)));
        pVcb = pDeviceObject->DeviceExtension;
        if (pVcb == NULL) 
        {
            KdPrint(("[PTFS]::PTFSDispatchClose device extension is NULL\n"));
            status = STATUS_SUCCESS;
            __leave;
        }

        if (GETIDENTIFIERTYPE(pVcb) != VCB || !PTFSCheckCCB(pVcb->pDcb, pFileObject->FsContext2)) 
        {
            if (pFileObject->FsContext2) 
            {
                pCcb = pFileObject->FsContext2;
                ASSERT(pCcb != NULL);

                pFcb = pCcb->pFcb;
                ASSERT(pFcb != NULL);

                KdPrint(("[PTFS]::PTFSDispatchClose Free CCB[%p]\n", pCcb));
                PTFSFcbLock(pFcb, FALSE);
                FreeCCB(pCcb);
                PTFSFcbUnlock(pFcb);
                FreeFCB(pVcb, pFcb);

                pFileObject->FsContext2 = NULL;
            }

            status = STATUS_SUCCESS;
            __leave;
        }

        pCcb = pFileObject->FsContext2;
        ASSERT(pCcb != NULL);

        pFcb = pCcb->pFcb;
        ASSERT(pFcb != NULL);

        PTFSFcbLock(pFcb, FALSE);

        if (pFcb->bBlockUserModeDispatch)
        {
            KdPrint(("[PTFS]::PTFSDispatchClose Closed file with user mode dispatch blocked[%wZ]\n", &pFcb->unstrFileName));
            FreeCCB(pCcb);
            PTFSFcbUnlock(pFcb);
            FreeFCB(pVcb, pFcb);
            status = STATUS_SUCCESS;
            __leave;
        }

        eventLength = sizeof(EVENT_CONTEXT) + pFcb->unstrFileName.Length;
        pEventContext = AllocateEventContext(pVcb->pDcb, pIrp, eventLength, pCcb);
        if (pEventContext == NULL) 
        {
            KdPrint(("[PTFS]::PTFSDispatchClose Failed to AllocateEventContext CCB[%p]\n", pCcb));
            FreeCCB(pCcb);
            PTFSFcbUnlock(pFcb);
            FreeFCB(pVcb, pFcb);
            status = STATUS_SUCCESS;
            __leave;
        }

        pEventContext->Context = pCcb->UserContext;
        KdPrint(("[PTFS]::PTFSDispatchClose UserContext[%x]\n", (ULONG)pCcb->UserContext));

        pEventContext->Operation.Close.FileNameLength = pFcb->unstrFileName.Length;
        RtlCopyMemory(pEventContext->Operation.Close.FileName, pFcb->unstrFileName.Buffer, pFcb->unstrFileName.Length);

        FreeCCB(pCcb);
        PTFSFcbUnlock(pFcb);
        FreeFCB(pVcb, pFcb);

        EventNotification(&pVcb->pDcb->NotifyEventIrpList, pEventContext);
        status = STATUS_SUCCESS;
    }
    __finally 
    {
        PTFSCompleteIrpRequest(pIrp, status, 0);
        KdPrint(("[PTFS]::PTFSDispatchClose end\n"));
    }

    return status;
}
