#include "access.h"
#include "irp_buffer_helper.h"

NTSTATUS
GetAccessToken(
	IN PDEVICE_OBJECT pDeviceObject,
	IN OUT PIRP pIrp
)
{
	KIRQL oldIrql = 0;
	PLIST_ENTRY thisEntry, nextEntry, listHead;
	PIRP_ENTRY pIrpEntry = NULL;
	PPTFSVCB pVcb = NULL;
	PEVENT_INFORMATION pEventInfo = NULL;
	PACCESS_TOKEN pAccessToken = NULL;
	NTSTATUS status = STATUS_INVALID_PARAMETER;
	PIO_STACK_LOCATION pIrpSp = NULL;
	HANDLE handle;
	BOOLEAN hasLock = FALSE;
	ULONG outBufferLen;
	PACCESS_STATE pAccessState = NULL;

	KdPrint(("[PTFS]::GetAccessToken Start\n"));

	pVcb = pDeviceObject->DeviceExtension;

	__try
	{

		if (pIrp->RequestorMode != UserMode)
		{
			KdPrint(("[PTFS]::GetAccessToken needs to be called from user-mode\n"));
			status = STATUS_INVALID_PARAMETER;
			__leave;
		}

		if (GETIDENTIFIERTYPE(pVcb) != VCB) 
		{
			KdPrint(("[PTFS]::GetAccessToken invalid Type\n"));
			status = STATUS_INVALID_PARAMETER;
			__leave;
		}

		GET_IRP_BUFFER_OR_LEAVE(pIrp, pEventInfo)
		pIrpSp = IoGetCurrentIrpStackLocation(pIrp);
		outBufferLen = pIrpSp->Parameters.DeviceIoControl.OutputBufferLength;

		if (outBufferLen != sizeof(EVENT_INFORMATION)) 
		{
			KdPrint(("[PTFS]::GetAccessToken wrong output buffer length\n"));
			status = STATUS_INVALID_PARAMETER;
			__leave;
		}

		ASSERT(KeGetCurrentIrql() <= DISPATCH_LEVEL);
		KeAcquireSpinLock(&pVcb->pDcb->PendingIrpList.ListSpinLock, &oldIrql);
		hasLock = TRUE;

		listHead = &pVcb->pDcb->PendingIrpList.ListHead;

		for (thisEntry = listHead->Flink; thisEntry != listHead; thisEntry = nextEntry) 
		{
			nextEntry = thisEntry->Flink;
			pIrpEntry = CONTAINING_RECORD(thisEntry, IRP_ENTRY, ListEntry);

			if (pIrpEntry->ulSerialNumber != pEventInfo->SerialNumber) 
				continue;

			if (pIrpEntry->pIrpSp->Parameters.Create.SecurityContext) 
				pAccessState = pIrpEntry->pIrpSp->Parameters.Create.SecurityContext->AccessState;

			break;
		}
		KeReleaseSpinLock(&pVcb->pDcb->PendingIrpList.ListSpinLock, oldIrql);
		hasLock = FALSE;

		if (pAccessState == NULL) 
		{
			KdPrint(("[PTFS]::GetAccessToken can't find pending Irp[%d]\n", pEventInfo->SerialNumber));
			__leave;
		}

		pAccessToken =SeQuerySubjectContextToken(&pAccessState->SubjectSecurityContext);
		if (pAccessToken == NULL) 
		{
			KdPrint(("[PTFS]::GetAccessToken null AccessToken\n"));
			__leave;
		}

		status = ObOpenObjectByPointer(pAccessToken, 0, NULL, GENERIC_ALL, *SeTokenObjectType, KernelMode, &handle);
		if (!NT_SUCCESS(status))
		{
			KdPrint(("[PTFS]::GetAccessToken Failed to ObOpenObjectByPointer status[0x%x]\n", status));
			__leave;
		}

		pEventInfo->Operation.AccessToken.hHandle = handle;
		pIrp->IoStatus.Information = sizeof(EVENT_INFORMATION);
		status = STATUS_SUCCESS;

	}
	__finally 
	{
		if (hasLock) 
			KeReleaseSpinLock(&pVcb->pDcb->PendingIrpList.ListSpinLock, oldIrql);
	}

	KdPrint(("[PTFS]::GetAccessToken End\n"));
	return status;
}
