#pragma once

#include <ntifs.h>
#include "PTFSIoctl.h"

#define PTFS_DISK_DEVICE_NAME			L"\\Device\\PTFSVolume"
#define PTFS_SYMBOLIC_LINK_NAME		L"\\DosDevices\\Global\\PTFSVolume"

#define PTFS_GLOBAL_DEVICE_NAME						L"\\Device\\PTFileSystem"
#define PTFS_GLOBAL_SYMBOLIC_LINK_NAME		L"\\DosDevices\\Global\\PTFileSystem"

#define PTFS_GLOBAL_FS_DISK_DEVICE_NAME		L"\\Device\\PTFS_Fs"

#define PTFS_NET_DEVICE_NAME       L"\\Device\\PTFSRedirector"
#define PTFS_NET_SYMBOLIC_LINK_NAME       L"\\DosDevices\\Global\\PTFSRedirector"

typedef enum _FSD_IDENTIFIER_TYPE {
	PGL = ':PGL',			// PTFS Global
    DCB = ':PDC',			// Panta Disk Control Block
    VCB = ':PVC',			// Panta Volume Control Block
    FCB = ':PFC',			// Panta File Control Block
    CCB = ':PCC',			// Panta Context Control Block
	FREED_FCB = ':PFF', // Panta FCB that has been freed
} FSD_IDENTIFIER_TYPE;

typedef struct _st_FSD_IDENTIFIER {
    FSD_IDENTIFIER_TYPE	FsdIdType;
    ULONG                   ulSize;
} FSD_IDENTIFIER, *PFSD_IDENTIFIER;

typedef struct _st_IRP_LIST {
	LIST_ENTRY		ListHead;
	KEVENT				NotEmptyEvent;
	KSPIN_LOCK		ListSpinLock;
} IRP_LIST, *PIRP_LIST;

typedef struct _MOUNT_ENTRY {
    LIST_ENTRY ListEntry;
    PTFS_CONTROL MountControl;
} MOUNT_ENTRY, * PMOUNT_ENTRY;

typedef struct _st_PTFS_GLOBAL_ {
	FSD_IDENTIFIER		Identifier;
	ERESOURCE				Resource;
	PDEVICE_OBJECT	pDeviceObject;
	PDEVICE_OBJECT	pFsDiskDeviceObject;
	ULONG						ulMountId;
	IRP_LIST					PendingServiceIrpList;
	IRP_LIST					NotifyServiceIrpList;

	PKTHREAD				DeviceDeleteThread;
	LIST_ENTRY			MountPointList;
	LIST_ENTRY			DeviceDeleteList;
	KEVENT					KillDeleteDeviceEvent;
    KEVENT					DeleteDeviceEvent;

	ERESOURCE				MountManagerLock;
} PTFS_GLOBAL, *PPTFS_GLOBAL;

typedef struct _st_IRP_ENTRY_ {
    LIST_ENTRY ListEntry;
    ULONG ulSerialNumber;
    PIRP pIrp;
    PIO_STACK_LOCATION pIrpSp;
    PFILE_OBJECT pFileObject;
    BOOLEAN bCancelRoutineFreeMemory;
    NTSTATUS AsyncStatus;
    ULONG ulFlags;
    LARGE_INTEGER liTickCount;
    PIRP_LIST pIrpList;
} IRP_ENTRY, * PIRP_ENTRY;

typedef struct _st_DEVICE_ENTRY_ {
    LIST_ENTRY ListEntry;
    PDEVICE_OBJECT pDiskDeviceObject;
    PDEVICE_OBJECT pVolumeDeviceObject;
    ULONG ulSessionId;
    ULONG ulCounter;
    UNICODE_STRING unstrMountPoint;
} DEVICE_ENTRY, * PDEVICE_ENTRY;

typedef struct _st_DRIVER_EVENT_CONTEXT 
{
    LIST_ENTRY ListEntry;
    PKEVENT pCompletedEvent;
    EVENT_CONTEXT EventContext;
} DRIVER_EVENT_CONTEXT, *PDRIVER_EVENT_CONTEXT;


typedef struct _st_PTFSDiskControlBlock_ {
    FSD_IDENTIFIER Identifier;
    ERESOURCE Resource;
    PPTFS_GLOBAL pPTFSGlobal;
    PDRIVER_OBJECT pDriverObject;
    PDEVICE_OBJECT pDeviceObject;

    PVOID pVcb;

    IRP_LIST PendingIrpList;
    IRP_LIST PendingEventIrpList;
    IRP_LIST NotifyEventIrpList;
    IRP_LIST PendingRetryIrpList;

    PUNICODE_STRING punstrDiskDeviceName;
    PUNICODE_STRING punstrSymbolicLinkName;
    PUNICODE_STRING punstrPersistentSymbolicLinkName;
    PUNICODE_STRING punstrMountPoint;
    PUNICODE_STRING punstrUNCName;
    LPWSTR pwszVolumeLabel;

    DEVICE_TYPE DeviceType;
    DEVICE_TYPE VolumeDeviceType;
    ULONG ulDeviceCharacteristics;
    HANDLE hMupHandle;
    UNICODE_STRING unstrMountedDeviceInterfaceName;
    UNICODE_STRING unstrDiskDeviceInterfaceName;

    KEVENT KillEvent;
    KEVENT ForceTimeoutEvent;
    KEVENT ReleaseEvent;

    PKTHREAD TimeoutThread;
    PKTHREAD EventNotificationThread;

    USHORT usUseAltStream;
    USHORT usUseMountManager;
    USHORT usMountGlobally;
    USHORT usFileLockInUserMode;

    ULONG ulSerialNumber;

    ULONG ulMountId;
    ULONG ulFlags;
    LARGE_INTEGER liTickCount;

    CACHE_MANAGER_CALLBACKS CacheManagerCallbacks;
    CACHE_MANAGER_CALLBACKS CacheManagerNoOpCallbacks;

    ULONG ulIrpTimeout;
    ULONG ulSessionId;
    IO_REMOVE_LOCK RemoveLock;

    BOOLEAN bMountPointDetermined;

    BOOLEAN bOplocksDisabled;
    ULONG ulFcbGarbageCollectionIntervalMs;
} PTFSDCB, * PPTFSDCB;

typedef struct _st_PTFSVolumeControlBlock {
    FSD_IDENTIFIER Identifier;
    FSRTL_ADVANCED_FCB_HEADER VolumeFileHeader;
    SECTION_OBJECT_POINTERS SectionObjectPointers;
    FAST_MUTEX AdvancedFCBHeaderMutex;

    ERESOURCE Resource;
    PDEVICE_OBJECT pDeviceObject;
    PPTFSDCB pDcb;
    LIST_ENTRY NextFCB;

    PNOTIFY_SYNC NotifySync;
    LIST_ENTRY DirNotifyList;

    LONG FcbAllocated;
    LONG FcbFreed;
    LONG CcbAllocated;
    LONG CcbFreed;
    ULONG ulFlags;
    BOOLEAN bHasEventWait;

    LONG64 ValidFcbMask;
    BOOLEAN bIsKeepaliveActive;

    PKTHREAD FcbGarbageCollectorThread;
    LIST_ENTRY FcbGarbageList;
    KEVENT FcbGarbageListNotEmpty;

    VOLUME_METRICS VolumeMetrics;
} PTFSVCB, * PPTFSVCB;

typedef struct _st_PTFSFileControlBlock_ {
    FSD_IDENTIFIER Identifier;
    FSRTL_ADVANCED_FCB_HEADER AdvancedFCBHeader;
    SECTION_OBJECT_POINTERS SectionObjectPointers;
    FAST_MUTEX AdvancedFCBHeaderMutex;
    ERESOURCE PagingIoResource;
    PPTFSVCB pVcb;
    LIST_ENTRY NextFCB;
    LIST_ENTRY NextCCB;
    LONG lFileCount;
    ULONG ulFlags;
    SHARE_ACCESS ShareAccess;
    UNICODE_STRING unstrFileName;
    FILE_LOCK FileLock;
    OPLOCK Oplock;

    BOOLEAN bIsKeepalive;
    BOOLEAN bBlockUserModeDispatch;
    LIST_ENTRY NextGarbageCollectableFcb;
    BOOLEAN bGarbageCollectionGracePeriodPassed;
} PTFSFCB, * PPTFSFCB;

typedef struct _st_PTFSContextControlBlock_ {
    FSD_IDENTIFIER Identifier;
    ERESOURCE Resource;
    PPTFSFCB pFcb;
    LIST_ENTRY NextCCB;
    ULONG64 Context;
    ULONG64 UserContext;
    PWCHAR pwszSearchPattern;
    ULONG ulSearchPatternLength;
    ULONG ulFlags;
    ULONG ulMountId;
    BOOLEAN bIsKeepaliveActive;
    BOOLEAN bAtomicOplockRequestPending;
    HANDLE hProcessId;
} PTFSCCB, * PPTFSCCB;


// WARN: Undocumented Microsoft struct.
struct SYMLINK_ECP_CONTEXT {
    USHORT UnparsedNameLength;
    union {
        USHORT Flags;
        struct {
            USHORT MountPoint : 1;
        } MountPoint;
    } FlagsMountPoint;
    USHORT DeviceNameLength;
    USHORT Zero;
    struct SYMLINK_ECP_CONTEXT* Reparsed;
    UNICODE_STRING Name;
};

#ifndef DWORD
typedef unsigned long DWORD;
#endif

#if (NTDDI_VERSION > NTDDI_WIN7)
#define PTFSGetFcbOplock(F) &(F)->AdvancedFCBHeader.Oplock
#else
#define PTFSGetFcbOplock(F) &(F)->Oplock
#endif


#define VCB_MOUNTED 0x00000004
#define VCB_DISMOUNT_PENDING 0x00000008

#define DCB_DELETE_PENDING 0x00000001
#define DCB_MOUNTPOINT_DELETED 0x00000004


#define GETIDENTIFIERTYPE(pObj) (((PFSD_IDENTIFIER)pObj)->FsdIdType)
#define IsFlagOn(a, b) ((BOOLEAN)(FlagOn(a, b) == b))

#define SetLongFlag(_F, _SF) PTFSSetFlag(&(_F), (ULONG)(_SF))
#define ClearLongFlag(_F, _SF) PTFSClearFlag(&(_F), (ULONG)(_SF))

#define PTFSFCBFlagsGet(fcb) ((fcb)->ulFlags)
#define PTFSFCBFlagsIsSet(fcb, bit) (((fcb)->ulFlags) & (bit))
#define PTFSFCBFlagsSetBit(fcb, bit) SetLongFlag((fcb)->ulFlags, (bit))
#define PTFSFCBFlagsClearBit(fcb, bit) ClearLongFlag((fcb)->ulFlags, (bit))

#define PTFSCCBFlagsGet PTFSFCBFlagsGet
#define PTFSCCBFlagsIsSet PTFSFCBFlagsIsSet
#define PTFSCCBFlagsSetBit PTFSFCBFlagsSetBit
#define PTFSCCBFlagsClearBit PTFSFCBFlagsClearBit


#define IS_DEVICE_READ_ONLY(DeviceObject)                                      \
  (DeviceObject->Characteristics & FILE_READ_ONLY_DEVICE)

#ifndef DOE_UNLOAD_PENDING
#define DOE_UNLOAD_PENDING 0x00000001
#define DOE_DELETE_PENDING 0x00000002
#define DOE_REMOVE_PENDING 0x00000004
#define DOE_REMOVE_PROCESSED 0x00000008
#define DOE_START_PENDING 0x00000010
#endif

#define TAG (ULONG)'sshs'

#define PTFS_MDL_ALLOCATED 0x1

#define PTFSAllocate(size)	ExAllocatePoolWithTag(NonPagedPool, size, TAG)
#define PTFSFree(p)	ExFreePoolWithTag(p, TAG)

extern NPAGED_LOOKASIDE_LIST g_PTFSIrpEntryLookasideList;
#define AllocateIrpEntry()                                                \
  ExAllocateFromNPagedLookasideList(&g_PTFSIrpEntryLookasideList)
#define FreeIrpEntry(IrpEntry)                                            \
  ExFreeToNPagedLookasideList(&g_PTFSIrpEntryLookasideList, IrpEntry)

extern ULONG g_PTFSMdlSafePriority;
#define MmGetSystemAddressForMdlNormalSafe(mdl)                                \
  MmGetSystemAddressForMdlSafe(mdl, NormalPagePriority | g_PTFSMdlSafePriority)


#define DRIVER_CONTEXT_EVENT 2
#define DRIVER_CONTEXT_IRP_ENTRY 3

#define PTFS_IRP_PENDING_TIMEOUT (1000 * 15)
#define PTFS_IRP_PENDING_TIMEOUT_RESET_MAX (1000 * 60 * 5)
#define PTFS_CHECK_INTERVAL (1000 * 5)
#define PTFS_DELETE_DEVICE_CHECK_INTERVAL (1000 * 1)

#define PTFS_KEEPALIVE_TIMEOUT_DEFAULT (1000 * 15)

// {9F9439FC-76B1-4305-9D41-138CBEF0FD10}
#ifndef PTFS_BASE_GUID
#define PTFS_BASE_GUID  {0x9f9439fc, 0x76b1, 0x4305, {0x9d, 0x41, 0x13, 0x8c, 0xbe, 0xf0, 0xfd, 0x10}}
#endif

#ifndef NTDDI_WIN8
#define NTDDI_WIN8                          0x06020000
#endif

#ifndef MdlMappingNoWrite
#define MdlMappingNoWrite       0x80000000
#endif

#ifndef MdlMappingNoExecute
#define MdlMappingNoExecute     0x40000000
#endif

#ifndef VOLUME_LABEL
#define VOLUME_LABEL L"PTFSSJK"
#endif

typedef NTKERNELAPI BOOLEAN 
PFN_FsRtlCheckLockForOplockRequest(
    IN PFILE_LOCK FileLock, 
    IN PLARGE_INTEGER AllocationSize
);

typedef NTKERNELAPI BOOLEAN
PFN_FsRtlAreThereWaitingFileLocks(
    IN PFILE_LOCK FileLock
);


extern LOOKASIDE_LIST_EX g_PTFSCCBLookasideList;
extern LOOKASIDE_LIST_EX g_PTFSFCBLookasideList;
extern LOOKASIDE_LIST_EX g_PTFSEResourceLookasideList;
extern BOOLEAN		g_FixFileNameForReparseMountPoint;
extern ULONG g_Debug;

extern PFN_FsRtlCheckLockForOplockRequest* g_pfn_FsRtlCheckLockForOplockRequest;
extern PFN_FsRtlAreThereWaitingFileLocks* g_pfn_FsRtlAreThereWaitingFileLocks;


NTSTATUS
PTFSDispatchRoutine(
    IN PDEVICE_OBJECT pDeviceObject,
    IN PIRP pIrp
);