#include "lock.h"
#include "init.h"
#include "util.h"
#include "notification.h"
#include "event.h"

#ifdef ALLOC_PRAGMA
#pragma alloc_text (PAGE, PTFSCommonLockControl)
#pragma alloc_text (PAGE, PTFSDispatchLock)
#endif

NTSTATUS
PTFSCommonLockControl(
    IN PIRP pIrp
) 
{
    NTSTATUS Status = STATUS_SUCCESS;
    PIO_STACK_LOCATION pIrpSp = IoGetCurrentIrpStackLocation(pIrp);
    PFILE_OBJECT pFileObject = NULL;
    PPTFSFCB pFcb = NULL;
    PPTFSCCB pCcb = NULL;

    KdPrint(("[PTFS]::PTFSCommonLockControl Start\n"));

    pFileObject = pIrpSp->FileObject;

    pCcb = pFileObject->FsContext2;
    if (pCcb == NULL || pCcb->Identifier.FsdIdType != CCB) 
    {
        KdPrint(("[PTFS]::PTFSCommonLockControl STATUS_INVALID_PARAMETER(CCB)\n"));
        return STATUS_INVALID_PARAMETER;
    }

    pFcb = pCcb->pFcb;
    if (pFcb == NULL || pFcb->Identifier.FsdIdType != FCB) 
    {
        KdPrint(("[PTFS]::PTFSCommonLockControl STATUS_INVALID_PARAMETER(FCB)\n"));
        return STATUS_INVALID_PARAMETER;
    }

    if (PTFSFCBFlagsIsSet(pFcb, PTFS_FILE_DIRECTORY)) 
    {
        KdPrint(("[PTFS]::PTFSCommonLockControl STATUS_INVALID_PARAMETER(PTFS_FILE_DIRECTORY)\n"));
        return STATUS_INVALID_PARAMETER;
    }

    if ( !g_pfn_FsRtlAreThereWaitingFileLocks ||
        ( (IRP_MN_LOCK == pIrpSp->MinorFunction) && ((ULONGLONG)pIrpSp->Parameters.LockControl.ByteOffset.QuadPart < (ULONGLONG)pFcb->AdvancedFCBHeader.AllocationSize.QuadPart) ) ||
        ( (IRP_MN_LOCK != pIrpSp->MinorFunction) && g_pfn_FsRtlAreThereWaitingFileLocks(&pFcb->FileLock) ) ) 
    {
        Status = PTFSCheckOplock(pFcb, pIrp, NULL ,NULL, NULL);
    }

    if (Status == STATUS_SUCCESS)
        Status = FsRtlProcessFileLock(&pFcb->FileLock, pIrp, NULL);

    KdPrint(("[PTFS]::PTFSCommonLockControl End\n"));
    return Status;
}

NTSTATUS
PTFSDispatchLock(
	IN PDEVICE_OBJECT pDeviceObject,
	IN PIRP pIrp
)
{
    PIO_STACK_LOCATION pIrpSp = NULL;
    NTSTATUS status = STATUS_INVALID_PARAMETER;
    PFILE_OBJECT pFileObject = NULL;
    PPTFSCCB pCcb = NULL;
    PPTFSFCB pFcb = NULL;
    PPTFSVCB pVcb = NULL;
    PPTFSDCB pDcb = NULL;
    PEVENT_CONTEXT pEventContext = NULL;
    ULONG eventLength = 0;
    BOOLEAN completeIrp = TRUE;

    __try 
    {
        KdPrint(("[PTFS]::PTFSDispatchLock Start\n"));
        pIrpSp = IoGetCurrentIrpStackLocation(pIrp);
        pFileObject = pIrpSp->FileObject;

        if (pFileObject == NULL) 
        {
            KdPrint(("[PTFS]::PTFSDispatchLock FileObject is null\n"));
            status = STATUS_INVALID_PARAMETER;
            __leave;
        }

        pVcb = pDeviceObject->DeviceExtension;
        if (GETIDENTIFIERTYPE(pVcb) != VCB ||!PTFSCheckCCB(pVcb->pDcb, pFileObject->FsContext2)) 
        {
            status = STATUS_INVALID_PARAMETER;
            __leave;
        }

        pDcb = pVcb->pDcb;

        KdPrint(("[PTFS]::PTFSDispatchLock ProcessId %lu\n", IoGetRequestorProcessId(pIrp)));

        switch (pIrpSp->MinorFunction) 
        {
        case IRP_MN_LOCK:
            KdPrint(("[PTFS]::PTFSDispatchLock IRP_MN_LOCK\n"));
            break;
        case IRP_MN_UNLOCK_ALL:
            KdPrint(("[PTFS]::PTFSDispatchLock IRP_MN_UNLOCK_ALL\n"));
            break;
        case IRP_MN_UNLOCK_ALL_BY_KEY:
            KdPrint(("[PTFS]::PTFSDispatchLock IRP_MN_UNLOCK_ALL_BY_KEY\n"));
            break;
        case IRP_MN_UNLOCK_SINGLE:
            KdPrint(("[PTFS]::PTFSDispatchLock IRP_MN_UNLOCK_SINGLE\n"));
            break;
        default:
            KdPrint(("[PTFS]::PTFSDispatchLock unknown function : %d\n", pIrpSp->MinorFunction));
            break;
        }

        pCcb = pFileObject->FsContext2;
        ASSERT(pCcb != NULL);

        pFcb = pCcb->pFcb;
        ASSERT(pFcb != NULL);
        PTFSFcbLock(pFcb, FALSE);

        if (pDcb->usFileLockInUserMode) 
        {
            eventLength = sizeof(EVENT_CONTEXT) + pFcb->unstrFileName.Length;
            pEventContext = AllocateEventContext(pVcb->pDcb, pIrp, eventLength, pCcb);
            if (pEventContext == NULL) 
            {
                status = STATUS_INSUFFICIENT_RESOURCES;
                __leave;
            }

            pEventContext->Context = pCcb->UserContext;
            pEventContext->Operation.Lock.FileNameLength = pFcb->unstrFileName.Length;
            RtlCopyMemory(pEventContext->Operation.Lock.FileName, pFcb->unstrFileName.Buffer, pFcb->unstrFileName.Length);
            pEventContext->Operation.Lock.ByteOffset = pIrpSp->Parameters.LockControl.ByteOffset;
            if (pIrpSp->Parameters.LockControl.Length != NULL) 
                pEventContext->Operation.Lock.Length.QuadPart = pIrpSp->Parameters.LockControl.Length->QuadPart;
            else
                KdPrint(("[PTFS]::PTFSDispatchLock LockControl.Length is NULL\n"));

            pEventContext->Operation.Lock.Key = pIrpSp->Parameters.LockControl.Key;
            status = RegisterPendingIrp(pDeviceObject, pIrp, pEventContext, 0);
        }
        else 
        {
            status = PTFSCommonLockControl(pIrp);
            completeIrp = FALSE;
        }
    }
    __finally 
    {
        if (pFcb)
            PTFSFcbUnlock(pFcb);

        if (completeIrp) 
            PTFSCompleteIrpRequest(pIrp, status, 0);

        KdPrint(("[PTFS]::PTFSDispatchLock End\n"));
    }
    return status;
}

VOID
PTFSCompleteLock(
	IN PIRP_ENTRY pIrpEntry,
	IN PEVENT_INFORMATION pEventInfo
)
{
    PIRP pIrp = NULL;
    PIO_STACK_LOCATION pIrpSp = NULL;

    pIrp = pIrpEntry->pIrp;
    pIrpSp = pIrpEntry->pIrpSp;

    KdPrint(("[PTFS]::PTFSCompleteLock Start\n"));

    PTFSCompleteIrpRequest(pIrp, pEventInfo->Status, 0);

    KdPrint(("[PTFS]::PTFSCompleteLock End\n"));
}
