// Thread.h: interface for the CThread class.
//
//////////////////////////////////////////////////////////////////////

#pragma once

class CThread  
{
  public :
   
      CThread();
      
      virtual ~CThread();

      HANDLE GetHandle() const;

      void Wait() const;

      bool Wait(DWORD timeoutMillis) const;

      void Start();

      void Terminate(
         DWORD exitCode = 0);

	void ResetThreadHandle();
	void ReuseHandle();

   private :

      virtual BOOL Run() = 0;

      static unsigned int __stdcall ThreadFunction(void *pV);

      HANDLE m_hThread;

      // No copies do not implement
      CThread(const CThread &rhs);
      CThread &operator=(const CThread &rhs);
};

