// SEvent.h: interface for the CSEvent class.
//
//////////////////////////////////////////////////////////////////////

#pragma once

class CSEvent  
{
  public :
   
      CSEvent( LPSECURITY_ATTRIBUTES lpSecurityAttributes,
			   bool manualReset,
			   bool initialState );
#ifdef _AFX
      CSEvent( LPSECURITY_ATTRIBUTES lpSecurityAttributes,
			   bool manualReset,
			   bool initialState,
			   const CString &name );
#endif
      virtual ~CSEvent();

      HANDLE GetEvent() const;

      void Wait() const;

      bool Wait(
         DWORD timeoutMillis) const;

      void Reset();

      void Set();

      void Pulse();

   private :

      HANDLE m_hEvent;

      // No copies do not implement
      CSEvent(const CSEvent &rhs);
      CSEvent &operator=(const CSEvent &rhs);
};

