// Locking.h: interface for the CLocking class.
//
//////////////////////////////////////////////////////////////////////

#pragma once

class CLocking  
{
   public :
   
      class Owner
      {
         public:

            explicit Owner(
               CLocking &crit);

            ~Owner();
      
         private :

            CLocking &m_crit;

            // No copies do not implement
            Owner(const Owner &rhs);
            Owner &operator=(const Owner &rhs);
      };

      CLocking();
      
      ~CLocking();

      void Enter();

      void Leave();

   private :

      CRITICAL_SECTION m_crit;

      // No copies do not implement
      CLocking(const CLocking &rhs);
      CLocking &operator=(const CLocking &rhs);
};

