// Locking.cpp: implementation of the CLocking class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Locking.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CLocking::CLocking()
{
   ::InitializeCriticalSection(&m_crit);
}
      
CLocking::~CLocking()
{
   ::DeleteCriticalSection(&m_crit);
}

void CLocking::Enter()
{
   ::EnterCriticalSection(&m_crit);
}

void CLocking::Leave()
{
   ::LeaveCriticalSection(&m_crit);
}

///////////////////////////////////////////////////////////////////////////////
// CCriticalSection::Owner
///////////////////////////////////////////////////////////////////////////////

CLocking::Owner::Owner(
   CLocking &crit)
   : m_crit(crit)
{
   m_crit.Enter();
}

CLocking::Owner::~Owner()
{
   m_crit.Leave();
}
