#pragma once

#include "DefineNoMinMax.h"
#include <windows.h>

#if _MSC_VER < 1300
#define FORCEINLINE __inline
#endif

FORCEINLINE VOID InitializeListHead(PLIST_ENTRY pListHead)
{
    pListHead->Flink = pListHead->Blink = pListHead;
}

FORCEINLINE BOOLEAN IsListEmpty(const LIST_ENTRY * pcListHead)
{
    return (BOOLEAN)(pcListHead == NULL || pcListHead->Flink == pcListHead);
}

FORCEINLINE BOOLEAN RemoveEntryList(PLIST_ENTRY pEntry)
{
    PLIST_ENTRY pBlink;
    PLIST_ENTRY Flink;

	if (pEntry != NULL) {
    	Flink = pEntry->Flink;
    	pBlink = pEntry->Blink;
    	pBlink->Flink = Flink;
    	Flink->Blink = pBlink;
		return (BOOLEAN)(Flink == pBlink);
	}
    return TRUE;
}

FORCEINLINE PLIST_ENTRY RemoveHeadList( PLIST_ENTRY ListHead)
{
    PLIST_ENTRY Flink;
    PLIST_ENTRY pEntry;

    pEntry = ListHead->Flink;
    Flink = pEntry->Flink;
    ListHead->Flink = Flink;
    Flink->Blink = ListHead;
    return pEntry;
}

FORCEINLINE PLIST_ENTRY RemoveTailList(PLIST_ENTRY ListHead)
{
    PLIST_ENTRY Blink;
    PLIST_ENTRY pEntry;

    pEntry = ListHead->Blink;
    Blink = pEntry->Blink;
    ListHead->Blink = Blink;
    Blink->Flink = ListHead;
    return pEntry;
}

FORCEINLINE VOID InsertTailList(PLIST_ENTRY ListHead, PLIST_ENTRY pEntry)
{
    PLIST_ENTRY Blink;

    Blink = ListHead->Blink;
    pEntry->Flink = ListHead;
    pEntry->Blink = Blink;
    Blink->Flink = pEntry;
    ListHead->Blink = pEntry;
}

FORCEINLINE VOID InsertHeadList(PLIST_ENTRY ListHead, PLIST_ENTRY pEntry)
{
    PLIST_ENTRY Flink;

    Flink = ListHead->Flink;
    pEntry->Flink = Flink;
    pEntry->Blink = ListHead;
    Flink->Blink = pEntry;
    ListHead->Flink = pEntry;
}

FORCEINLINE VOID AppendTailList(PLIST_ENTRY ListHead, PLIST_ENTRY ListToAppend)
{
    PLIST_ENTRY ListEnd = ListHead->Blink;

    ListHead->Blink->Flink = ListToAppend;
    ListHead->Blink = ListToAppend->Blink;
    ListToAppend->Blink->Flink = ListHead;
    ListToAppend->Blink = ListEnd;
}

FORCEINLINE PSINGLE_LIST_ENTRY PopEntryList(PSINGLE_LIST_ENTRY ListHead)
{
    PSINGLE_LIST_ENTRY FirstEntry;
    FirstEntry = ListHead->Next;
    if (FirstEntry != NULL) {
        ListHead->Next = FirstEntry->Next;
    }

    return FirstEntry;
}

FORCEINLINE VOID PushEntryList(PSINGLE_LIST_ENTRY ListHead, PSINGLE_LIST_ENTRY pEntry)
{
    pEntry->Next = ListHead->Next;
    ListHead->Next = pEntry;
}
