// DriverManager.h: interface for the CDriverManager class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_DRIVERMANAGER_H__F498C08A_DD62_4419_8D8D_7357215B268F__INCLUDED_)
#define AFX_DRIVERMANAGER_H__F498C08A_DD62_4419_8D8D_7357215B268F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <winsvc.h>
#include <filesystem>

class CDriverManager  
{
public:
	CDriverManager();
	virtual ~CDriverManager();

protected:
	BOOL InstallDriver( SC_HANDLE SchSCManager, LPCTSTR DriverName, LPCTSTR ServiceExe, int nStartType);
	BOOL StartDriver( SC_HANDLE SchSCManager, LPCTSTR DriverName );
	BOOL OpenDevice( LPCTSTR DriverName, HANDLE * lphDevice );
	BOOL StopDriver( SC_HANDLE SchSCManager, LPCTSTR DriverName );
	BOOL RemoveDriver( SC_HANDLE SchSCManager, LPCTSTR DriverName );
	virtual LPCWSTR GetDriverName() const = 0;
	virtual LPCWSTR GetDriverFileName() const = 0;

public:
	BOOL UnloadDeviceDriver( LPCTSTR Name,int nStartType );
	BOOL RemoveDeviceDriver(LPCTSTR Name);
	BOOL LoadDeviceDriver( LPCTSTR Name, LPCTSTR Path, HANDLE * lphDevice, int nStartType);
};

#endif // !defined(AFX_DRIVERMANAGER_H__F498C08A_DD62_4419_8D8D_7357215B268F__INCLUDED_)
