// DriverManager.cpp: implementation of the CDriverManager class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "winsvc.h"
#include "DriverManager.h"
#include <stdlib.h>
#include <stdio.h>
#include "Util/Util.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#endif

using namespace std;

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CDriverManager::CDriverManager()
{	
}

CDriverManager::~CDriverManager()
{

}

BOOL CDriverManager::InstallDriver( SC_HANDLE SchSCManager, LPCTSTR DriverName, LPCTSTR ServiceExe, int nStartType)
{
    SC_HANDLE  schService;

    schService = CreateService( SchSCManager,			// SCManager database
                                DriverName,								// name of service
                                DriverName,								// name to display
                                SERVICE_ALL_ACCESS,			// desired access
                                SERVICE_KERNEL_DRIVER,	  // service type
                                nStartType,				// start type
                                SERVICE_ERROR_NORMAL,	// error control type
                                ServiceExe,				// service's binary
                                NULL,					// no load ordering group
                                NULL,					// no tag identifier
                                NULL,					// no dependencies
                                NULL,					// LocalSystem account
                                NULL					// no password
                                );
    if ( schService == NULL )
	{
        return FALSE;
	}

    CloseServiceHandle( schService );

    return TRUE;
}

BOOL CDriverManager::StartDriver( SC_HANDLE SchSCManager, LPCTSTR DriverName )
{
    SC_HANDLE  schService;
    BOOL       ret;

    schService = OpenService( SchSCManager,
                              DriverName,
                              SERVICE_ALL_ACCESS
                              );
    if ( schService == NULL )
	{
        return FALSE;
	}

    ret = StartService( schService, 0, NULL )
       || GetLastError() == ERROR_SERVICE_ALREADY_RUNNING;

    CloseServiceHandle( schService );

    return ret;
}

BOOL CDriverManager::OpenDevice( LPCTSTR DriverName, HANDLE * lphDevice )
{
    HANDLE   hDevice = INVALID_HANDLE_VALUE;

	TCHAR completeDeviceName[64] = { 0x00, };
	swprintf_s( completeDeviceName, _T("\\\\.\\Global\\%s"), DriverName );

	hDevice = CreateFile( completeDeviceName,
		GENERIC_READ | GENERIC_WRITE,
		0,
		NULL,
		OPEN_EXISTING,
		FILE_ATTRIBUTE_NORMAL,
		NULL
		);

    if ( hDevice == ((HANDLE)-1) )
	{
        return FALSE;
	}

	if ( lphDevice )
		*lphDevice = hDevice;
	else
	    CloseHandle( hDevice );

    return TRUE;
}



BOOL CDriverManager::StopDriver( SC_HANDLE SchSCManager, LPCTSTR DriverName )
{
    SC_HANDLE       schService;
    BOOL            ret;
    SERVICE_STATUS  serviceStatus;

    schService = OpenService( SchSCManager, DriverName, SERVICE_ALL_ACCESS );
    if ( schService == NULL )
        return FALSE;

    ret = ControlService( schService, SERVICE_CONTROL_STOP, &serviceStatus );

    CloseServiceHandle( schService );

    return ret;
}


BOOL CDriverManager::RemoveDriver( SC_HANDLE SchSCManager, LPCTSTR DriverName )
{
    SC_HANDLE  schService;
    BOOL       ret;

    schService = OpenService( SchSCManager,
                              DriverName,
                              SERVICE_ALL_ACCESS
                              );

    if ( schService == NULL )
	{
		return FALSE;
	}

    ret = DeleteService( schService );

    CloseServiceHandle( schService );	

    return ret;
}


BOOL CDriverManager::UnloadDeviceDriver( LPCTSTR Name, int nStartType)
{
	SC_HANDLE	schSCManager;

	if( nStartType != SERVICE_DEMAND_START)
		return TRUE;
	
	schSCManager = OpenSCManager( NULL,              // machine (NULL == local)
                              	  NULL,							// database (NULL == default)
								  SC_MANAGER_ALL_ACCESS // access required
								);

	StopDriver( schSCManager, Name );

	RemoveDriver( schSCManager, Name );
	const BOOL removed = RemoveDriver(schSCManager, Name);

	CloseServiceHandle( schSCManager );
	return TRUE;
}

BOOL CDriverManager::RemoveDeviceDriver(LPCTSTR Name)
{
	SC_HANDLE	schSCManager;

	schSCManager = OpenSCManager(NULL,              // machine (NULL == local)
		NULL,							// database (NULL == default)
		SC_MANAGER_ALL_ACCESS // access required
	);

	BOOL result = RemoveDriver(schSCManager, Name);

	CloseServiceHandle(schSCManager);
	return result;
}

BOOL CDriverManager::LoadDeviceDriver( LPCTSTR Name, LPCTSTR Path, HANDLE * lphDevice, int nStartType)
{
	SC_HANDLE	schSCManager = NULL;
	BOOL		okay = FALSE;

	if(nStartType <= SERVICE_AUTO_START)
	{
		okay = OpenDevice( Name, lphDevice );
	}

	if(!okay)
	{
		schSCManager = OpenSCManager( NULL, NULL, SC_MANAGER_ALL_ACCESS );
		okay = StartDriver( schSCManager, Name );
	}

	if(!okay)
	{
		RemoveDriver( schSCManager, Name );		
		InstallDriver( schSCManager, Name, Path , nStartType);		
		okay = StartDriver( schSCManager, Name );	
	}

	okay = OpenDevice( Name, lphDevice );

	if (schSCManager)
	{
		CloseServiceHandle(schSCManager);
		schSCManager = NULL;
	}

	return okay;
}



