#pragma once

#include "PTFSIoctl.h"

#ifndef NTSTATUS
typedef _Return_type_success_(return >= 0) LONG NTSTATUS;
typedef NTSTATUS* PNTSTATUS;
#endif

#ifndef _M_X64	
  #ifdef PTFS_EXPORTS
	#define PTFSAPI __declspec(dllexport) __stdcall
  #else
	#define PTFSAPI __declspec(dllimport) __stdcall
  #endif
#else
  #define PTFSAPI
#endif

#define PTFS_CALLBACK __stdcall

#define PTFS_VERSION					800

#define PTFS_OPTION_DEBUG			1 // ouput debug message
#define PTFS_OPTION_STDERR			2 // ouput debug message to stderr
#define PTFS_OPTION_ALT_STREAM	4 // use alternate stream
#define PTFS_OPTION_WRITE_PROTECT 8
#define PTFS_OPTION_NETWORK 16
#define PTFS_OPTION_REMOVABLE 32
#define PTFS_OPTION_MOUNT_MANAGER 64
#define PTFS_OPTION_CURRENT_SESSION 128
#define PTFS_OPTION_FILELOCK_USER_MODE 256
#define PTFS_OPTION_ENABLE_NOTIFICATION_API 512
#define PTFS_OPTION_DISABLE_OPLOCKS 1024
#define PTFS_OPTION_ENABLE_FCB_GARBAGE_COLLECTION 2048

#define PTFS_MOUNT_POINT_SUPPORTED_VERSION 600
#define PTFS_SECURITY_SUPPORTED_VERSION	600

#define PTFS_GLOBAL_DEVICE_NAME	L"\\\\.\\PTFileSystem"
#define PTFS_CONTROL_PIPE		L"\\\\.\\pipe\\PTFSMounter"

#define PTFS_MOUNTER_SERVICE L"PTFSMounter"
#define PTFS_DRIVER_SERVICE L"PTFS"

#define PTFS_PIPE_CONTROL_MOUNT		1
#define PTFS_PIPE_CONTROL_UNMOUNT	2
#define PTFS_PIPE_CONTROL_CHECK			3
#define PTFS_PIPE_CONTROL_FIND			4
#define PTFS_PIPE_CONTROL_LIST			5
#define PTFS_PIPE_CONTROL_RELOGIN		6

#define PTFS_CONTROL_OPTION_FORCE_UNMOUNT 1

#define PTFS_CONTROL_SUCCESS	1
#define PTFS_CONTROL_FAIL		0

#define PTFS_SERVICE_START		1
#define PTFS_SERVICE_STOP		2
#define PTFS_SERVICE_DELETE	3

#define PTFS_KEEPALIVE_TIME	3000 // in miliseconds

#define PTFS_MAX_THREAD		15

typedef struct _PTFS_OPTIONS {
	USHORT	Version;			// Supported PTFS Version, ex. "530" (PTFS ver 0.5.3)
	USHORT	ThreadCount;	// number of threads to be used
	ULONG	Options;				// combination of PTFS_OPTIONS_*
	ULONG64	GlobalContext;	// FileSystem can use this variable
	LPCWSTR	MountPoint;		//  mount point "M:\" (drive letter) or "C:\mount\PTFS" (path in NTFS)
	LPCWSTR UNCName;
	ULONG Timeout;
	ULONG AllocationUnitSize;
	ULONG SectorSize;
} PTFS_OPTIONS, *PPTFS_OPTIONS;

typedef struct _PTFS_FILE_INFO {
	ULONG64	Context;			// FileSystem can use this variable
	ULONG64	PTFSContext;	// Don't touch this
	PPTFS_OPTIONS pPTFSOptions; // A pointer to PTFS_OPTIONS which was  passed to PTFSMain.
	ULONG	ProcessId;		// process id for the thread that originally requested a given I/O operation
	UCHAR	IsDirectory;		// requesting a directory file
	UCHAR	DeleteOnClose;	// Delete on when "cleanup" is called
	UCHAR	PagingIo;			// Read or write is paging IO.
	UCHAR	SynchronousIo;  // Read or write is synchronous IO.
	UCHAR	Nocache;
	UCHAR	WriteToEndOfFile; //  If true, write to the current end of file instead of Offset parameter.

} PTFS_FILE_INFO, *PPTFS_FILE_INFO;

typedef int (WINAPI *PFillFindData) (PWIN32_FIND_DATAW, PPTFS_FILE_INFO);
typedef int(WINAPI* PFillFindStreamData)(PWIN32_FIND_STREAM_DATA, PPTFS_FILE_INFO);

/* PTFSMain returns error codes */
#define PTFS_SUCCESS							0
#define PTFS_ERROR								-1
#define PTFS_DRIVE_LETTER_ERROR	-2
#define PTFS_DRIVER_INSTALL_ERROR	-3
#define PTFS_START_ERROR					-4
#define PTFS_MOUNT_ERROR				-5
#define PTFS_MOUNT_POINT_ERROR	-6


#ifdef __cplusplus
extern "C" {
#endif

typedef struct _PTFS_OPERATIONS {

	NTSTATUS(PTFS_CALLBACK* ZwCreateFile)(LPCWSTR FileName,
		PPTFS_IO_SECURITY_CONTEXT SecurityContext,
		ACCESS_MASK DesiredAccess,
		ULONG FileAttributes,
		ULONG ShareAccess,
		ULONG CreateDisposition,
		ULONG CreateOptions,
		PPTFS_FILE_INFO PTFSFileInfo);

	void(PTFS_CALLBACK* Cleanup)(LPCWSTR FileName,
		PPTFS_FILE_INFO PTFSFileInfo);

	void(PTFS_CALLBACK* CloseFile)(LPCWSTR FileName,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* ReadFile)(LPCWSTR FileName,
		LPVOID Buffer,
		DWORD BufferLength,
		LPDWORD ReadLength,
		LONGLONG Offset,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* WriteFile)(LPCWSTR FileName,
		LPCVOID Buffer,
		DWORD NumberOfBytesToWrite,
		LPDWORD NumberOfBytesWritten,
		LONGLONG Offset,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* FlushFileBuffers)(LPCWSTR FileName,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* GetFileInformation)(LPCWSTR FileName,
		LPBY_HANDLE_FILE_INFORMATION Buffer,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* FindFiles)(LPCWSTR FileName,
		PFillFindData FillFindData,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* FindFilesWithPattern)(LPCWSTR PathName,
		LPCWSTR SearchPattern,
		PFillFindData FillFindData,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* SetFileAttributes)(LPCWSTR FileName,
		DWORD FileAttributes,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* SetFileTime)(LPCWSTR FileName,
		CONST FILETIME* CreationTime,
		CONST FILETIME* LastAccessTime,
		CONST FILETIME* LastWriteTime,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* DeleteFile)(LPCWSTR FileName,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* DeleteDirectory)(LPCWSTR FileName,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* MoveFile)(LPCWSTR FileName,
		LPCWSTR NewFileName,
		BOOL ReplaceIfExisting,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* SetEndOfFile)(LPCWSTR FileName,
		LONGLONG ByteOffset,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* SetAllocationSize)(LPCWSTR FileName,
		LONGLONG AllocSize,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* LockFile)(LPCWSTR FileName,
		LONGLONG ByteOffset,
		LONGLONG Length,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* UnlockFile)(LPCWSTR FileName,
		LONGLONG ByteOffset,
		LONGLONG Length,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* GetDiskFreeSpace)(PULONGLONG FreeBytesAvailable,
		PULONGLONG TotalNumberOfBytes,
		PULONGLONG TotalNumberOfFreeBytes,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* GetVolumeInformation)(LPWSTR VolumeNameBuffer,
		DWORD VolumeNameSize,
		LPDWORD VolumeSerialNumber,
		LPDWORD MaximumComponentLength,
		LPDWORD FileSystemFlags,
		LPWSTR FileSystemNameBuffer,
		DWORD FileSystemNameSize,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* Mounted)(PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* Unmounted)(PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* GetFileSecurity)(LPCWSTR FileName,
		PSECURITY_INFORMATION SecurityInformation,
		PSECURITY_DESCRIPTOR SecurityDescriptor,
		ULONG BufferLength,
		PULONG LengthNeeded,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* SetFileSecurity)(LPCWSTR FileName,
		PSECURITY_INFORMATION SecurityInformation,
		PSECURITY_DESCRIPTOR SecurityDescriptor,
		ULONG BufferLength,
		PPTFS_FILE_INFO PTFSFileInfo);

	NTSTATUS(PTFS_CALLBACK* FindStreams)(LPCWSTR FileName,
		PFillFindStreamData FillFindStreamData,
		PPTFS_FILE_INFO PTFSFileInfo);

} PTFS_OPERATIONS, *PPTFS_OPERATIONS;


typedef struct _PTFS_INSTANCE {
	CRITICAL_SECTION	CriticalSection;

	WCHAR	DeviceName[64];
	WCHAR	MountPoint[MAX_PATH];
	WCHAR	UNCName[64];

	ULONG	DeviceNumber;
	ULONG	MountId;

	PPTFS_OPTIONS		pPTFSOptions;
	PPTFS_OPERATIONS	pPTFSOperations;

	LIST_ENTRY	ListEntry;
} PTFS_INSTANCE, *PPTFS_INSTANCE;

typedef struct _PTFS_OPEN_INFO {
	BOOL			IsDirectory;
	ULONG			OpenCount;
	PEVENT_CONTEXT	pEventContext;
	PPTFS_INSTANCE	pPTFSInstance;
	ULONG64			UserContext;
	ULONG			EventId;
	PLIST_ENTRY		DirListHead;
	PLIST_ENTRY StreamListHead;
} PTFS_OPEN_INFO, *PPTFS_OPEN_INFO;

#if _MSC_VER < 1300 // VC6
typedef ULONG ULONG_PTR;
#endif

typedef struct _PTFS_FIND_DATA {
	WIN32_FIND_DATAW	win32FindData;
	LIST_ENTRY			ListEntry;
} PTFS_FIND_DATA, *PPTFS_FIND_DATA;

typedef struct _PTFS_PIPE_CONTROL {
	ULONG	Type;
	WCHAR	MountPoint[MAX_PATH];
	WCHAR	DeviceName[64];
	ULONG	Option;
	ULONG	Status;
} PTFS_PIPE_CONTROL, * PPTFS_PIPE_CONTROL;

int PTFSAPI PTFSStart(PPTFS_OPTIONS PTFSOptions, PPTFS_OPERATIONS PTFSOperations, HANDLE hMountWaitEvent = NULL);
BOOL PTFSAPI PTFSUnmount(WCHAR	DriveLetter, BOOL bForce);
BOOL PTFSAPI PTFSSetDebugMode(ULONG ulMode);
BOOL PTFSAPI PTFSNotifyReLogIn(LPCWSTR lpcwszMountPoint);
void PTFSAPI PTFSMapKernelToUserCreateFileFlags(ACCESS_MASK DesiredAccess, ULONG FileAttributes, ULONG CreateOptions, ULONG CreateDisposition,
	ACCESS_MASK* outDesiredAccess, DWORD* outFileAttributesAndFlags, DWORD* outCreationDisposition);

NTSTATUS PTFSAPI PTFSNtStatusFromWin32(DWORD dwWin32Error);
void PTFSAPI PTFSWaitMount(WCHAR cLetter, BOOL bRemovedMount);
BOOL PTFSAPI PTFSIsReadyToMountVolume(WCHAR cLetter);

#ifdef __cplusplus
}
#endif


