#pragma once


#define PTFS_DRIVER_NAME		"PTFileSystem.sys"
#define PTFS_DRIVER_NAME_64	"PTFileSystem64.sys"
#define PTFS_DRIVER_NAME_ARM64	"PTFileSystemArm64.sys"
#define PTFS_NAME				"PTFileSystem"


#define PTFS_DRIVER_VERSION					1001

#define EVENT_CONTEXT_MAX_SIZE			(1024*64)
#define EVENT_CONTEXT_MAX_SIZE_64		(1024*512)	//buffer ũ 

#define IOCTL_GET_VERSION				CTL_CODE(FILE_DEVICE_UNKNOWN, 0x911, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_SET_DEBUG_MODE		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x912, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EVENT_WAIT					CTL_CODE(FILE_DEVICE_UNKNOWN, 0x913, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EVENT_INFO					CTL_CODE(FILE_DEVICE_UNKNOWN, 0x914, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EVENT_RELEASE			CTL_CODE(FILE_DEVICE_UNKNOWN, 0x915, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EVENT_START				CTL_CODE(FILE_DEVICE_UNKNOWN, 0x916, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EVENT_WRITE				CTL_CODE(FILE_DEVICE_UNKNOWN, 0x917, METHOD_OUT_DIRECT, FILE_ANY_ACCESS)
#define IOCTL_KEEPALIVE						CTL_CODE(FILE_DEVICE_UNKNOWN, 0x918, METHOD_NEITHER, FILE_ANY_ACCESS)
#define IOCTL_SERVICE_WAIT				CTL_CODE(FILE_DEVICE_UNKNOWN, 0x919, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_RESET_TIMEOUT			CTL_CODE(FILE_DEVICE_UNKNOWN, 0x91A, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_GET_ACCESS_TOKEN	CTL_CODE(FILE_DEVICE_UNKNOWN, 0x91B, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_EVENT_MOUNTPOINT_LIST		CTL_CODE(FILE_DEVICE_UNKNOWN, 0x91C, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_MOUNTPOINT_CLEANUP			CTL_CODE(FILE_DEVICE_UNKNOWN, 0x91D, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define IOCTL_GET_VOLUME_METRICS			CTL_CODE(FILE_DEVICE_UNKNOWN, 0x91F, METHOD_BUFFERED, FILE_ANY_ACCESS)

#define FSCTL_ACTIVATE_KEEPALIVE           CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 0x920, METHOD_BUFFERED, FILE_ANY_ACCESS)
#define FSCTL_NOTIFY_PATH                        CTL_CODE(FILE_DEVICE_FILE_SYSTEM, 0x921, METHOD_BUFFERED, FILE_ANY_ACCESS)


#define DRIVER_FUNC_INSTALL	0x01
#define DRIVER_FUNC_REMOVE	0x02

#define PTFS_MOUNTED			1
#define PTFS_USED					2
#define PTFS_START_FAILED	3

#define PTFS_DEVICE_MAX	10

#define PTFS_DEFAULT_SECTOR_SIZE						512
#define PTFS_DEFAULT_ALLOCATION_UNIT_SIZE	512
#define PTFS_DEFAULT_DISK_SIZE							((ULONGLONG)20 * (ULONGLONG)(1024 * 1024 * 1024))


#ifndef MAX_PATH
#define MAX_PATH          260
#endif

typedef struct _st_UNICODE_STRING_INTERMEDIATE_ {
	USHORT Length;
	USHORT MaximumLength;
	WCHAR Buffer[1];
} UNICODE_STRING_INTERMEDIATE, * PUNICODE_STRING_INTERMEDIATE;

typedef struct _st_NOTIFY_PATH_INTERMEDIATE {
	ULONG CompletionFilter;
	ULONG Action;
	USHORT Length;
	WCHAR Buffer[1];
} NOTIFY_PATH_INTERMEDIATE, * PNOTIFY_PATH_INTERMEDIATE;

typedef struct _st_ACCESS_STATE_INTERMEDIATE {
	BOOLEAN SecurityEvaluated;
	BOOLEAN GenerateAudit;
	BOOLEAN GenerateOnClose;
	BOOLEAN AuditPrivileges;
	ULONG Flags;
	ACCESS_MASK RemainingDesiredAccess;
	ACCESS_MASK PreviouslyGrantedAccess;
	ACCESS_MASK OriginalDesiredAccess;
	ULONG SecurityDescriptorOffset;
	ULONG UnicodeStringObjectNameOffset;
	ULONG UnicodeStringObjectTypeOffset;
} ACCESS_STATE_INTERMEDIATE, * PACCESS_STATE_INTERMEDIATE;

typedef struct _st_PTFS_ACCESS_STATE {
	BOOLEAN SecurityEvaluated;
	BOOLEAN GenerateAudit;
	BOOLEAN GenerateOnClose;
	BOOLEAN AuditPrivileges;
	ULONG Flags;
	ACCESS_MASK RemainingDesiredAccess;
	ACCESS_MASK PreviouslyGrantedAccess;
	ACCESS_MASK OriginalDesiredAccess;
	PSECURITY_DESCRIPTOR SecurityDescriptor;
	UNICODE_STRING ObjectName;
	UNICODE_STRING ObjectType;
} PTFS_ACCESS_STATE, * PPTFS_ACCESS_STATE;

typedef struct _st_IO_SECURITY_CONTEXT_INTERMEDIATE {
	ACCESS_STATE_INTERMEDIATE AccessState;
	ACCESS_MASK DesiredAccess;
} IO_SECURITY_CONTEXT_INTERMEDIATE,* PIO_SECURITY_CONTEXT_INTERMEDIATE;

typedef struct  st_PTFS_IO_SECURITY_CONTEXT {
	PTFS_ACCESS_STATE AccessState;
	ACCESS_MASK DesiredAccess;
} PTFS_IO_SECURITY_CONTEXT, * PPTFS_IO_SECURITY_CONTEXT;

typedef struct _st_CREATE_CONTEXT {
	IO_SECURITY_CONTEXT_INTERMEDIATE SecurityContext;
	ULONG FileAttributes;
	ULONG CreateOptions;
	ULONG ShareAccess;
	ULONG FileNameLength;
	ULONG FileNameOffset;
} CREATE_CONTEXT, * PCREATE_CONTEXT;

typedef struct _st_CLEANUP_CONTEXT {
	ULONG FileNameLength;
	WCHAR FileName[1];
} CLEANUP_CONTEXT, * PCLEANUP_CONTEXT;

typedef struct _st_CLOSE_CONTEXT {
	ULONG FileNameLength;
	WCHAR FileName[1];
} CLOSE_CONTEXT, * PCLOSE_CONTEXT;

typedef struct _st_DIRECTORY_CONTEXT {
	ULONG FileInformationClass;
	ULONG FileIndex;
	ULONG BufferLength;
	ULONG DirectoryNameLength;
	ULONG SearchPatternLength;
	ULONG SearchPatternOffset;
	WCHAR DirectoryName[1];
	WCHAR SearchPatternBase[1];
} DIRECTORY_CONTEXT, * PDIRECTORY_CONTEXT;

typedef struct _st_READ_CONTEXT {
	LARGE_INTEGER ByteOffset;
	ULONG BufferLength;
	ULONG FileNameLength;
	WCHAR FileName[1];
} READ_CONTEXT, * PREAD_CONTEXT;

typedef struct _st_WRITE_CONTEXT {
	LARGE_INTEGER ByteOffset;
	ULONG BufferLength;
	ULONG BufferOffset;
	ULONG RequestLength;
	ULONG FileNameLength;
	WCHAR FileName[2];
} WRITE_CONTEXT, * PWRITE_CONTEXT;

typedef struct _st_FILEINFO_CONTEXT {
	ULONG FileInformationClass;
	ULONG BufferLength;
	ULONG FileNameLength;
	WCHAR FileName[1];
} FILEINFO_CONTEXT, * PFILEINFO_CONTEXT;

typedef struct _st_SETFILE_CONTEXT {
	ULONG FileInformationClass;
	ULONG BufferLength;
	ULONG BufferOffset;
	ULONG FileNameLength;
	WCHAR FileName[1];
} SETFILE_CONTEXT, * PSETFILE_CONTEXT;

typedef struct _st_VOLUME_CONTEXT {
	ULONG FsInformationClass;
	ULONG BufferLength;
} VOLUME_CONTEXT, * PVOLUME_CONTEXT;

typedef struct _st_LOCK_CONTEXT {
	LARGE_INTEGER ByteOffset;
	LARGE_INTEGER Length;
	ULONG Key;
	ULONG FileNameLength;
	WCHAR FileName[1];
} LOCK_CONTEXT, * PLOCK_CONTEXT;

typedef struct _st_FLUSH_CONTEXT {
	ULONG FileNameLength;
	WCHAR FileName[1];
} FLUSH_CONTEXT, * PFLUSH_CONTEXT;

typedef struct _st_UNMOUNT_CONTEXT {
	WCHAR DeviceName[64];
	ULONG Option;
} UNMOUNT_CONTEXT, * PUNMOUNT_CONTEXT;

typedef struct _st_SECURITY_CONTEXT {
	SECURITY_INFORMATION SecurityInformation;
	ULONG BufferLength;
	ULONG FileNameLength;
	WCHAR FileName[1];
} SECURITY_CONTEXT, * PSECURITY_CONTEXT;

typedef struct _st_SET_SECURITY_CONTEXT {
	SECURITY_INFORMATION SecurityInformation;
	ULONG BufferLength;
	ULONG BufferOffset;
	ULONG FileNameLength;
	WCHAR FileName[1];
} SET_SECURITY_CONTEXT, * PSET_SECURITY_CONTEXT;

typedef struct _st_EVENT_CONTEXT {
	ULONG	Length;
	ULONG	MountId;
	ULONG	SerialNumber;
	ULONG	ProcessId;
	UCHAR	MajorFunction;
	UCHAR	MinorFunction;
	ULONG	Flags;
	ULONG	FileFlags;
	ULONG64	Context;
	union {
		DIRECTORY_CONTEXT Directory;
		READ_CONTEXT Read;
		WRITE_CONTEXT Write;
		FILEINFO_CONTEXT File;
		CREATE_CONTEXT Create;
		CLOSE_CONTEXT Close;
		SETFILE_CONTEXT SetFile;
		CLEANUP_CONTEXT Cleanup;
		LOCK_CONTEXT Lock;
		VOLUME_CONTEXT Volume;
		FLUSH_CONTEXT Flush;
		UNMOUNT_CONTEXT Unmount;
		SECURITY_CONTEXT Security;
		SET_SECURITY_CONTEXT SetSecurity;
	}Operation;
} EVENT_CONTEXT, *PEVENT_CONTEXT;

typedef struct _st_VOLUME_METRICS {
	ULONG64 NormalFcbGarbageCollectionCycles;
	ULONG64 NormalFcbGarbageCollectionPasses;
	ULONG64 ForcedFcbGarbageCollectionPasses;
	ULONG64 FcbAllocations;
	ULONG64 FcbDeletions;
	ULONG64 FcbGarbageCollectionCancellations;
} VOLUME_METRICS, * PVOLUME_METRICS;

typedef struct _EVENT_DRIVER_INFO {
	ULONG DriverVersion;
	ULONG Status;
	ULONG DeviceNumber;
	ULONG MountId;
	WCHAR DeviceName[64];
} EVENT_DRIVER_INFO, * PEVENT_DRIVER_INFO;

typedef struct _EVENT_START {
	ULONG UserVersion;
	ULONG DeviceType;
	ULONG Flags;
	WCHAR MountPoint[260];
	WCHAR UNCName[64];
	ULONG IrpTimeout;
} EVENT_START, * PEVENT_START;

#ifdef _MSC_VER
#pragma warning(push)
#pragma warning(disable : 4201)
#endif
typedef struct _st_PTFS_RENAME_INFORMATION {
#if (_WIN32_WINNT >= _WIN32_WINNT_WIN10_RS1)
	union {
		BOOLEAN ReplaceIfExists;  // FileRenameInformation
		ULONG Flags;              // FileRenameInformationEx
	} DUMMYUNIONNAME;
#else
	BOOLEAN ReplaceIfExists;
#endif
	ULONG FileNameLength;
	WCHAR FileName[1];
} PTFS_RENAME_INFORMATION, * PPTFS_RENAME_INFORMATION;
#ifdef _MSC_VER
#pragma warning(pop)
#endif

typedef struct _st_PTFS_LINK_INFORMATION {
	BOOLEAN ReplaceIfExists;
	ULONG FileNameLength;
	WCHAR FileName[1];
} PTFS_LINK_INFORMATION, * PPTFS_LINK_INFORMATION;


#define WRITE_MAX_SIZE                                                         \
  (EVENT_CONTEXT_MAX_SIZE - sizeof(EVENT_CONTEXT) - 256 * sizeof(WCHAR))

typedef struct _EVENT_INFORMATION {
	ULONG SerialNumber;
	NTSTATUS Status;
	ULONG Flags;
	union {
		struct {
			ULONG Index;
		} Directory;
		struct {
			ULONG Flags;
			ULONG Information;
		} Create;
		struct {
			LARGE_INTEGER CurrentByteOffset;
		} Read;
		struct {
			LARGE_INTEGER CurrentByteOffset;
		} Write;
		struct {
			UCHAR DeleteOnClose;
		} Delete;
		struct {
			ULONG Timeout;
		} ResetTimeout;
		struct {
			HANDLE hHandle;
		} AccessToken;
	} Operation;
	ULONG64 Context;
	ULONG BufferLength;
	UCHAR Buffer[8];

} EVENT_INFORMATION, * PEVENT_INFORMATION;

/////////////////////////////////////////////////////////////////////////////////////
typedef struct _st_PTFS_CONTROL {
	ULONG Type;
	WCHAR MountPoint[MAX_PATH];
	WCHAR UNCName[64];
	WCHAR DeviceName[64];
	PVOID64 VolumeDeviceObject;
	ULONG SessionId;
} PTFS_CONTROL, * PPTFS_CONTROL;

#define KEEPALIVE_FILE_NAME L"\\__drive_fs_keepalive"
#define NOTIFICATION_FILE_NAME L"\\drive_fs_notification"


#define PTFS_FILE_DIRECTORY		1
#define PTFS_FILE_DELETED			2
#define PTFS_FILE_OPENED			4
#define PTFS_DIR_MATCH_ALL		8
#define PTFS_DELETE_ON_CLOSE 16
#define PTFS_PAGING_IO				32
#define PTFS_SYNCHRONOUS_IO 64
#define PTFS_WRITE_TO_END_OF_FILE		128
#define PTFS_NOCACHE									256
#define PTFS_RETRY_CREATE						512
#define PTFS_FILE_CHANGE_LAST_WRITE	1024

#define PTFS_DISK_FILE_SYSTEM			0
#define PTFS_NETWORK_FILE_SYSTEM	1

#define PTFS_EVENT_ALTERNATIVE_STREAM_ON                0x0001
#define PTFS_EVENT_WRITE_PROTECT                                0x0002
#define PTFS_EVENT_REMOVABLE												0x0004
#define PTFS_EVENT_MOUNT_MANAGER                                   0x0008
#define PTFS_EVENT_CURRENT_SESSION                                 0x0010
#define PTFS_EVENT_FILELOCK_USER_MODE                            0x0020
#define PTFS_EVENT_DISABLE_OPLOCKS                                 0x0040
#define PTFS_EVENT_ENABLE_FCB_GC                                   0x0080


#define PTFS_VOLUME_SERIAL_NUMBER		0x19740424