$prevPwd = $PWD

try {

$RootPath = (get-item $PSScriptRoot).parent.FullName
Set-Location -LiteralPath $RootPath
Write-Host "current directory: $PWD"

$pinfo = New-Object System.Diagnostics.ProcessStartInfo
$pinfo.FileName = "git"
$pinfo.RedirectStandardError = $true
$pinfo.RedirectStandardOutput = $true
$pinfo.UseShellExecute = $false

#
# git rev-list --count  HEAD
#
Write-Host "`n--------------------------------------------------------------------------------"
Write-Host "git rev-list --count  HEAD"
$pinfo.Arguments = "rev-list --count  HEAD"
$p = New-Object System.Diagnostics.Process
$p.StartInfo = $pinfo
$p.Start() | Out-Null
$p.WaitForExit()
$stdout = $p.StandardOutput.ReadToEnd()
$stderr = $p.StandardError.ReadToEnd()
Write-Host -NoNewline "stdout: $stdout"
Write-Host "stderr: $stderr"
Write-Host "exit code: " + $p.ExitCode
$count10000 = [int]$stdout.Trim() + 10000
Write-Host "count + 10,000: $count10000"

# git name-rev --name-only HEAD
Write-Host "`n--------------------------------------------------------------------------------"
Write-Host "git name-rev --name-only HEAD"
$pinfo.Arguments = "name-rev --name-only HEAD"
$p = New-Object System.Diagnostics.Process
$p.StartInfo = $pinfo
$p.Start() | Out-Null
$p.WaitForExit()
$stdout = $p.StandardOutput.ReadToEnd()
$stderr = $p.StandardError.ReadToEnd()
Write-Host -NoNewline "stdout: $stdout"
Write-Host "stderr: $stderr"
Write-Host "exit code: " + $p.ExitCode
$remoteBranch = $stdout.Trim()
Write-Host "remote branch: $remoteBranch"

#
# git rev-parse HEAD
#
Write-Host "`n--------------------------------------------------------------------------------"
Write-Host "git rev-parse HEAD"
$pinfo.Arguments = "rev-parse HEAD"
$p = New-Object System.Diagnostics.Process
$p.StartInfo = $pinfo
$p.Start() | Out-Null
$p.WaitForExit()
$stdout = $p.StandardOutput.ReadToEnd()
$stderr = $p.StandardError.ReadToEnd()
Write-Host -NoNewline "stdout: $stdout"
Write-Host "stderr: $stderr"
Write-Host "exit code: " + $p.ExitCode
$hash = $stdout.Trim()
Write-Host "last commit: $hash"

#
#  git rev-parse --short HEAD
#
Write-Host "`n--------------------------------------------------------------------------------"
Write-Host "git rev-parse --short HEAD"
$pinfo.Arguments = "rev-parse --short HEAD"
$p = New-Object System.Diagnostics.Process
$p.StartInfo = $pinfo
$p.Start() | Out-Null
$p.WaitForExit()
$stdout = $p.StandardOutput.ReadToEnd()
$stderr = $p.StandardError.ReadToEnd()
Write-Host -NoNewline "stdout: $stdout"
Write-Host "stderr: $stderr"
Write-Host "exit code: " + $p.ExitCode
$short = $stdout.Trim()
Write-Host "last commit short: $short"

Write-Host "`n--------------------------------------------------------------------------------"
$versionPath = Join-Path $PWD 'PTCommon\Includes\version.h'
$versionTemplatePath = Join-Path $PWD 'PTCommon\Includes\version.h.template'
$versionHeader = (Get-Content -Raw $versionTemplatePath | Out-String)
# Write-Host "$versionHeader"
$versionHeader = $versionHeader.Replace('COUNT', $count10000)
$versionHeader = $versionHeader.Replace('COMMIT', $short + ' ' + $remoteBranch + ' ' + $hash)
Write-Host "$versionHeader"
Set-Content -NoNewline -Path  $versionPath -Value $versionHeader

Write-Host "`n--------------------------------------------------------------------------------"
$versionPath = Join-Path $PWD 'PTSmartUpdate\Installer\version.nsh'
$versionTemplatePath = Join-Path $PWD 'PTSmartUpdate\Installer\version.nsh.template'
$versionHeader = (Get-Content -Raw $versionTemplatePath | Out-String)
# Write-Host "$versionHeader"
$versionHeader = $versionHeader.Replace('COUNT', $count10000)
$versionHeader = $versionHeader.Replace('COMMIT_SHORT', $short)
$versionHeader = $versionHeader.Replace('COMMIT', $short + ' ' + $remoteBranch + ' ' + $hash)
Write-Host "$versionHeader"
Set-Content -NoNewline -Path  $versionPath -Value $versionHeader

Write-Host "`n--------------------------------------------------------------------------------"
$versionPath = Join-Path $PWD 'PTSmartUpdate\InstalleriLooko\version.nsh'
$versionTemplatePath = Join-Path $PWD 'PTSmartUpdate\InstalleriLooko\version.nsh.template'
$versionHeader = (Get-Content -Raw $versionTemplatePath | Out-String)
# Write-Host "$versionHeader"
$versionHeader = $versionHeader.Replace('COUNT', $count10000)
$versionHeader = $versionHeader.Replace('COMMIT', $short + ' ' + $remoteBranch + ' ' + $hash)
Write-Host "$versionHeader"
Set-Content -NoNewline -Path  $versionPath -Value $versionHeader

}
finally {
  # Restore the previous location.
  $prevPwd | Set-Location
}